/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.settle.busi.impl;

import com.ohaotian.plugin.base.exception.BusinessException;
import com.ohaotian.plugin.db.Page;
import com.tydic.fsc.settle.atom.EnumsService;
import com.tydic.fsc.settle.atom.OrganizationInfoService;
import com.tydic.fsc.settle.busi.api.BusiQueryOutstockInfo4PurchaserService;
import com.tydic.fsc.settle.busi.api.bo.BusiQueryOutstockInfoReqBO;
import com.tydic.fsc.settle.busi.api.bo.BusiQueryOutstockInfoRspBO;
import com.tydic.fsc.settle.busi.api.bo.SaleOrderDetailInfoRspBO;
import com.tydic.fsc.settle.busi.api.vo.OutstockInfoVO;
import com.tydic.fsc.settle.dao.OutstockDetailMapper;
import com.tydic.fsc.settle.dao.OutstockInfoMapper;
import com.tydic.fsc.settle.dao.SaleInvoiceInfoMapper;
import com.tydic.fsc.settle.dao.SaleOrderInfoMapper;
import com.tydic.fsc.settle.dao.po.OutstockInfo;
import com.tydic.fsc.settle.dao.po.SaleOrderInfo;
import com.tydic.fsc.settle.dao.vo.QueryOutstockInfoVO;
import com.tydic.fsc.settle.dao.vo.SaleOrderInfoVO;
import com.tydic.fsc.settle.enums.BaseEnums;
import com.tydic.fsc.settle.enums.OrderSource;
import com.tydic.fsc.settle.enums.OutstockInfoStatus;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

@Service
public class BusiQueryOutstockInfo4PurchaserServiceImpl
implements BusiQueryOutstockInfo4PurchaserService {
    private static final Logger logger = LoggerFactory.getLogger(BusiQueryOutstockInfo4PurchaserServiceImpl.class);
    @Autowired
    private OutstockInfoMapper outstockInfoMapper;
    @Autowired
    private SaleInvoiceInfoMapper saleInvoiceInfoMapper;
    @Autowired
    private OrganizationInfoService organizationInfoService;
    @Autowired
    private EnumsService enumsService;
    @Autowired
    private OutstockDetailMapper outstockDetailMapper;
    @Autowired
    private SaleOrderInfoMapper saleOrderInfoMapper;

    public BusiQueryOutstockInfoRspBO<OutstockInfoVO> queryOutstockInfo(BusiQueryOutstockInfoReqBO reqBO) {
        if (logger.isDebugEnabled()) {
            logger.debug("\u51fa\u5e93\u5355\u67e5\u8be2\u670d\u52a1\u7684\u5b9e\u73b0\u7c7b\u5165\u53c2\uff1a" + reqBO.toString());
        }
        if (reqBO.getPurchaseProjectId() == null) {
            throw new BusinessException("18000", "\u8bf7\u9009\u62e9\u91c7\u8d2d\u5355\u4f4d");
        }
        String orderBy = "t.OUTSTOCK_NO DESC";
        BusiQueryOutstockInfoRspBO rspPageBO = new BusiQueryOutstockInfoRspBO();
        QueryOutstockInfoVO queryOutstockInfoVO = new QueryOutstockInfoVO();
        BeanUtils.copyProperties((Object)reqBO, (Object)queryOutstockInfoVO);
        queryOutstockInfoVO.setOrderBy(orderBy);
        Page page = new Page(reqBO.getPageNo(), reqBO.getPageSize());
        List<OutstockInfo> returnOutstockList = this.outstockInfoMapper.getOutStockInfoList(queryOutstockInfoVO, (Page<Map<String, Object>>)page);
        if (null == returnOutstockList || returnOutstockList.isEmpty()) {
            return rspPageBO;
        }
        ArrayList<OutstockInfoVO> outstockVOList = new ArrayList<OutstockInfoVO>();
        for (OutstockInfo outstockInfoPO : returnOutstockList) {
            OutstockInfoVO outstockInfoVO = new OutstockInfoVO();
            BeanUtils.copyProperties((Object)outstockInfoPO, (Object)outstockInfoVO);
            String purchaseName = this.organizationInfoService.queryOrgName(outstockInfoPO.getPurchaseNo());
            outstockInfoVO.setPurchaseName(purchaseName);
            String statusDesc = this.enumsService.getDescr(OutstockInfoStatus.getInstance(outstockInfoPO.getStatus()));
            outstockInfoVO.setStatusDesc(statusDesc);
            String sourceDescr = this.enumsService.getDescr((BaseEnums)OrderSource.getInstance((String)outstockInfoPO.getSource()));
            outstockInfoVO.setSourceDescr(sourceDescr);
            outstockInfoVO.setPurchaseProjectName(this.organizationInfoService.queryProjectName(outstockInfoPO.getPurchaseProjectId()).getAccountName());
            List<String> invoiceNos = this.saleInvoiceInfoMapper.getInvoiceNoByApplyNo(outstockInfoPO.getApplyNo());
            String invoiceNo = "";
            if (invoiceNos.size() > 0) {
                for (String invoNo : invoiceNos) {
                    invoiceNo = invoNo + ",";
                }
            }
            if (StringUtils.hasText((String)invoiceNo)) {
                invoiceNo = invoiceNo.substring(0, invoiceNo.length() - 1);
            }
            outstockInfoVO.setInvoiceNo(invoiceNo);
            LinkedList<SaleOrderDetailInfoRspBO> saleOrderDetailList = new LinkedList<SaleOrderDetailInfoRspBO>();
            List<Long> inspectionIds = this.outstockDetailMapper.selectInspectionIdList(outstockInfoPO.getOutstockNo());
            if (!CollectionUtils.isEmpty(inspectionIds)) {
                SaleOrderInfoVO saleOrderInfoVO = new SaleOrderInfoVO();
                saleOrderInfoVO.setInspectionIdList(inspectionIds);
                List<SaleOrderInfo> saleOrderInfoList = this.saleOrderInfoMapper.getList(saleOrderInfoVO);
                for (SaleOrderInfo orderInfo : saleOrderInfoList) {
                    SaleOrderDetailInfoRspBO detailRspBO = new SaleOrderDetailInfoRspBO();
                    detailRspBO.setInspectionId(orderInfo.getInspectionId());
                    detailRspBO.setSaleOrderCode(orderInfo.getSaleOrderCode());
                    detailRspBO.setSaleOrderName(orderInfo.getSaleOrderName());
                    saleOrderDetailList.add(detailRspBO);
                }
            }
            outstockInfoVO.setSaleOrderDetailList(saleOrderDetailList);
            outstockVOList.add(outstockInfoVO);
        }
        rspPageBO.setRows(outstockVOList);
        rspPageBO.setRecordsTotal(page.getTotalCount());
        rspPageBO.setTotal(page.getTotalPages());
        rspPageBO.setPageNo(page.getPageNo());
        return rspPageBO;
    }
}

