/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.settle.busi.impl;

import com.ohaotian.plugin.base.exception.BusinessException;
import com.tydic.fsc.settle.atom.SequenceNoService;
import com.tydic.fsc.settle.atom.SourceMappingService;
import com.tydic.fsc.settle.atom.SubAccountService;
import com.tydic.fsc.settle.atom.bo.AccountantEngineReqBO;
import com.tydic.fsc.settle.bo.FscBaseRspBo;
import com.tydic.fsc.settle.busi.api.BusiReceivableWriteOffExtService;
import com.tydic.fsc.settle.busi.api.BusiReceivableWriteOffXbjService;
import com.tydic.fsc.settle.busi.api.bo.BusiReceivableWriteOffDetailExtReqBO;
import com.tydic.fsc.settle.busi.api.bo.BusiReceivableWriteOffDetailReqBO;
import com.tydic.fsc.settle.busi.api.bo.BusiReceivableWriteOffExtReqBO;
import com.tydic.fsc.settle.busi.api.bo.BusiReceivableWriteOffReqBO;
import com.tydic.fsc.settle.busi.api.bo.BusiReceivableWriteOffXbjInfoReqBO;
import com.tydic.fsc.settle.busi.api.bo.BusiReceivableWriteOffXbjReqBO;
import com.tydic.fsc.settle.busi.api.bo.SubAcctInfoExt;
import com.tydic.fsc.settle.dao.RecvAbleInfoMapper;
import com.tydic.fsc.settle.dao.po.RecvAbleInfo;
import com.tydic.fsc.settle.enums.BusinessType;
import com.tydic.fsc.settle.enums.OrderSource;
import com.tydic.fsc.settle.enums.RecvAbleInfoRecvStatus;
import com.tydic.fsc.settle.enums.SubAccountServiceType;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class BusiReceivableWriteOffExtServiceImpl
implements BusiReceivableWriteOffExtService {
    private static final Logger logger = LoggerFactory.getLogger(BusiReceivableWriteOffExtServiceImpl.class);
    @Autowired
    private SubAccountService subAccountService;
    @Resource
    private SequenceNoService recAmtConfirmSeqNoService;
    @Autowired
    private RecvAbleInfoMapper recvAbleInfoMapper;
    @Autowired(required=false)
    private SourceMappingService sourceMappingService;
    @Autowired(required=false)
    private BusiReceivableWriteOffXbjService busiReceivableWriteOffXbjService;

    public FscBaseRspBo processWriteOff(BusiReceivableWriteOffExtReqBO reqBO) {
        if (logger.isDebugEnabled()) {
            logger.debug("\u5e94\u6536\u6838\u9500\u670d\u52a1\u5165\u53c2\uff1a" + reqBO);
        }
        if (CollectionUtils.isEmpty((Collection)reqBO.getWriteOffDatas())) {
            throw new BusinessException("0001", "\u6838\u9500\u6570\u636e\u4e0d\u80fd\u4e3a\u7a7a");
        }
        String source = this.checkAndGetSource(reqBO.getWriteOffDatas());
        if (!OrderSource.CONSULT_PRICE.getCode().equals(source)) {
            throw new BusinessException("18000", "\u7535\u529b\u4e13\u533a\u3001\u7164\u70ad\u4e13\u533a\u4e0d\u652f\u6301\u529e\u7406\u8be5\u4e1a\u52a1");
        }
        BusiReceivableWriteOffXbjReqBO xbjReqBO = this.getXbjWriteOffData(reqBO.getWriteOffDatas());
        this.busiReceivableWriteOffXbjService.processWriteOff(xbjReqBO);
        return new FscBaseRspBo();
    }

    private List<BusiReceivableWriteOffReqBO> groupByProjectId(BusiReceivableWriteOffExtReqBO reqBO) {
        LinkedList<BusiReceivableWriteOffReqBO> writeOffList = new LinkedList<BusiReceivableWriteOffReqBO>();
        HashMap writeOffMap = new HashMap();
        for (BusiReceivableWriteOffDetailExtReqBO reWriteOffDetailExt : reqBO.getWriteOffDatas()) {
            Long projectId = reWriteOffDetailExt.getPurchaseProjectId();
            if (writeOffMap.containsKey(projectId)) {
                ((List)writeOffMap.get(projectId)).add(reWriteOffDetailExt);
                continue;
            }
            LinkedList<BusiReceivableWriteOffDetailExtReqBO> newWriteOffList = new LinkedList<BusiReceivableWriteOffDetailExtReqBO>();
            newWriteOffList.add(reWriteOffDetailExt);
            writeOffMap.put(projectId, newWriteOffList);
        }
        for (Map.Entry entry : writeOffMap.entrySet()) {
            BusiReceivableWriteOffReqBO reWriteOff = new BusiReceivableWriteOffReqBO();
            reWriteOff.setWriteOffDatas(new LinkedList());
            BusiReceivableWriteOffDetailReqBO reWriteOffDetail = null;
            for (BusiReceivableWriteOffDetailExtReqBO reWriteOffDetailExt : (List)entry.getValue()) {
                reWriteOffDetail = new BusiReceivableWriteOffDetailReqBO();
                BeanUtils.copyProperties((Object)reWriteOffDetailExt, (Object)reWriteOffDetail);
                reWriteOff.getWriteOffDatas().add(reWriteOffDetail);
            }
            reWriteOff.setPurchaseProjectId(((BusiReceivableWriteOffDetailExtReqBO)((List)entry.getValue()).get(0)).getPurchaseProjectId());
            reWriteOff.setPurchaseNo(((BusiReceivableWriteOffDetailExtReqBO)((List)entry.getValue()).get(0)).getPurchaseNo());
            reWriteOff.setCompanyId(reqBO.getCompanyId());
            writeOffList.add(reWriteOff);
        }
        return writeOffList;
    }

    private List<AccountantEngineReqBO> dealWithWriteOff(BusiReceivableWriteOffReqBO reWriteOffReqBO) {
        Long purchaseNo = reWriteOffReqBO.getPurchaseNo();
        Long purchaseProjectId = reWriteOffReqBO.getPurchaseProjectId();
        Long operUnitNo = reWriteOffReqBO.getCompanyId();
        List writeOffDatas = reWriteOffReqBO.getWriteOffDatas();
        if (purchaseNo == null || purchaseNo <= 0L) {
            throw new BusinessException("0001", "\u5165\u53c2\u91c7\u8d2d\u5355\u4f4d\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (purchaseProjectId == null || purchaseProjectId <= 0L) {
            throw new BusinessException("0001", "\u5165\u53c2\u91c7\u8d2d\u5355\u4f4d\u8d26\u5957\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (operUnitNo == null || operUnitNo <= 0L) {
            throw new BusinessException("0001", "\u5165\u53c2\u516c\u53f8ID\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (writeOffDatas == null || writeOffDatas.isEmpty()) {
            throw new BusinessException("0001", "\u5165\u53c2\u5e94\u6536\u8bb0\u5f55\u4e0d\u80fd\u4e3a\u7a7a");
        }
        String source = null;
        BigDecimal toWriteoffAmtSum = BigDecimal.ZERO;
        for (BusiReceivableWriteOffDetailReqBO writeOffData : writeOffDatas) {
            String recvableNo = writeOffData.getRecvableNo();
            BigDecimal toWriteoffAmt = writeOffData.getToWriteoffAmt();
            if (toWriteoffAmt == null || toWriteoffAmt.compareTo(BigDecimal.ZERO) <= 0) {
                logger.error("\u5e94\u6536\u8bb0\u5f55[\u5e94\u6536\u7f16\u53f7=" + recvableNo + "]\u7684\u672c\u6b21\u6536\u6b3e\u91d1\u989d\u5fc5\u987b\u5927\u4e8e0");
                throw new BusinessException("18000", "\u5e94\u6536\u8bb0\u5f55[\u5e94\u6536\u7f16\u53f7=" + recvableNo + "]\u7684\u672c\u6b21\u6536\u6b3e\u91d1\u989d\u5fc5\u987b\u5927\u4e8e0");
            }
            RecvAbleInfo recvAbleInfo = this.recvAbleInfoMapper.selectByPrimaryKey(recvableNo);
            if (!RecvAbleInfoRecvStatus.TO_RECEIVE.getCode().equals(recvAbleInfo.getRecvStatus())) {
                throw new BusinessException("18000", "\u53ea\u6709\u6536\u6b3e\u72b6\u6001\u4e3a\u5f85\u6536\u6b3e\u7684\u8bb0\u5f55\u624d\u80fd\u529e\u7406\u6b64\u4e1a\u52a1");
            }
            if (recvAbleInfo.getRecvableAmt().subtract(recvAbleInfo.getWriteoffAmt()).compareTo(toWriteoffAmt) < 0) {
                logger.error("\u5e94\u6536\u8bb0\u5f55[\u5e94\u6536\u7f16\u53f7=" + recvableNo + "]\u7684\u53ef\u6838\u9500\u91d1\u989d\u5c0f\u4e8e\u672c\u6b21\u6536\u6b3e\u91d1\u989d");
                throw new BusinessException("18000", "\u5e94\u6536\u8bb0\u5f55[\u5e94\u6536\u7f16\u53f7=" + recvableNo + "]\u7684\u53ef\u6838\u9500\u91d1\u989d\u5c0f\u4e8e\u672c\u6b21\u6536\u6b3e\u91d1\u989d");
            }
            if (!recvAbleInfo.getPurchaseNo().equals(purchaseNo) || !recvAbleInfo.getPurchaseProjectId().equals(purchaseProjectId)) {
                throw new BusinessException("18000", "\u5e94\u6536\u8bb0\u5f55\u548c\u5b50\u8d26\u6237\u7684\u91c7\u8d2d\u5355\u4f4d\u4fe1\u606f\u4e0d\u5339\u914d");
            }
            if (null == source) {
                source = recvAbleInfo.getSource();
            } else if (!source.equals(recvAbleInfo.getSource())) {
                throw new BusinessException("18000", "\u6765\u6e90\u4e0d\u540c\u7684\u5e94\u6536\u8bb0\u5f55\u4e0d\u80fd\u4e00\u8d77\u6838\u9500");
            }
            toWriteoffAmtSum = toWriteoffAmtSum.add(toWriteoffAmt);
        }
        String targetSource = this.sourceMappingService.queryAccountingTargetSource(source);
        SubAcctInfoExt paySubAcctInfo = this.subAccountService.getWithMainAccount(operUnitNo, targetSource, purchaseNo, purchaseProjectId, SubAccountServiceType.DEFAULT.getCode());
        if (paySubAcctInfo == null) {
            logger.error("\u91c7\u8d2d\u5355\u4f4d\u5b50\u8d26\u6237\u4e0d\u5b58\u5728");
            throw new BusinessException("18000", "\u91c7\u8d2d\u5355\u4f4d\u5b50\u8d26\u6237\u4e0d\u5b58\u5728");
        }
        String subAcctNo = paySubAcctInfo.getSubAcctNo();
        if (paySubAcctInfo.getBalance().compareTo(toWriteoffAmtSum) < 0) {
            logger.error("\u91c7\u8d2d\u5355\u4f4d\u5b50\u8d26\u6237\u4f59\u989d\u4e0d\u8db3\u3002\u8d26\u53f7=" + paySubAcctInfo.getSubAcctNo() + ",\u4f59\u989d=" + paySubAcctInfo.getBalance() + ",\u5f85\u6838\u9500\u91d1\u989d=" + toWriteoffAmtSum);
            throw new BusinessException("18000", "\u91c7\u8d2d\u5355\u4f4d\u5b50\u8d26\u6237\u4f59\u989d\u4e0d\u8db3\u3002\u8d26\u53f7=" + paySubAcctInfo.getSubAcctNo() + ",\u4f59\u989d=" + paySubAcctInfo.getBalance() + ",\u5f85\u6838\u9500\u91d1\u989d=" + toWriteoffAmtSum);
        }
        ArrayList<AccountantEngineReqBO> accountantEngineReqBOList = new ArrayList<AccountantEngineReqBO>();
        for (BusiReceivableWriteOffDetailReqBO writeOffData : writeOffDatas) {
            String recvableNo = writeOffData.getRecvableNo();
            RecvAbleInfo recvAbleInfo = this.recvAbleInfoMapper.selectByPrimaryKey(recvableNo);
            RecvAbleInfo record = new RecvAbleInfo();
            record.setRecvableNo(recvableNo);
            record.setWriteoffAmt(recvAbleInfo.getWriteoffAmt().add(writeOffData.getToWriteoffAmt()));
            if (recvAbleInfo.getRecvableAmt().compareTo(record.getWriteoffAmt()) <= 0) {
                record.setRecvStatus(RecvAbleInfoRecvStatus.RECEIVED.getCode());
            }
            this.recvAbleInfoMapper.updateByPrimaryKeySelective(record);
            AccountantEngineReqBO accountantEngineReqBO = new AccountantEngineReqBO();
            accountantEngineReqBO.setBusinessType(BusinessType.ORDER_PAY.getCode());
            accountantEngineReqBO.setSource(targetSource);
            accountantEngineReqBO.setClientAcctNo(subAcctNo);
            accountantEngineReqBO.setOperUnit(operUnitNo);
            accountantEngineReqBO.setServiceNo(recvAbleInfo.getSaleOrderCode());
            accountantEngineReqBO.setRemark("\u5e94\u6536\u6838\u9500");
            accountantEngineReqBO.setAmounts(Arrays.asList(writeOffData.getToWriteoffAmt()));
            accountantEngineReqBOList.add(accountantEngineReqBO);
        }
        return accountantEngineReqBOList;
    }

    private String checkAndGetSource(List<BusiReceivableWriteOffDetailExtReqBO> writeOffDatas) {
        String source = null;
        for (BusiReceivableWriteOffDetailExtReqBO writeOffData : writeOffDatas) {
            String recvableNo = writeOffData.getRecvableNo();
            RecvAbleInfo recvAbleInfo = this.recvAbleInfoMapper.selectByPrimaryKey(recvableNo);
            if (null == source) {
                source = recvAbleInfo.getSource();
                continue;
            }
            if (source.equals(recvAbleInfo.getSource())) continue;
            throw new BusinessException("18000", "\u6765\u6e90\u4e0d\u540c\u7684\u5e94\u6536\u8bb0\u5f55\u4e0d\u80fd\u4e00\u8d77\u6838\u9500");
        }
        return source;
    }

    private BusiReceivableWriteOffXbjReqBO getXbjWriteOffData(List<BusiReceivableWriteOffDetailExtReqBO> writeOffDatas) {
        BusiReceivableWriteOffXbjReqBO xbjReqBO = new BusiReceivableWriteOffXbjReqBO();
        xbjReqBO.setXbjWriteOffInfo(new LinkedList());
        BusiReceivableWriteOffXbjInfoReqBO xbjInfoReqBO = null;
        for (BusiReceivableWriteOffDetailExtReqBO reqBO : writeOffDatas) {
            xbjInfoReqBO = new BusiReceivableWriteOffXbjInfoReqBO();
            BeanUtils.copyProperties((Object)reqBO, (Object)xbjInfoReqBO);
            xbjReqBO.getXbjWriteOffInfo().add(xbjInfoReqBO);
        }
        return xbjReqBO;
    }
}

