/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.settle.busi.impl;

import com.ohaotian.plugin.base.exception.BusinessException;
import com.tydic.fsc.settle.busi.api.BusiSumUpSaleOrderInfoDlzqService;
import com.tydic.fsc.settle.busi.api.bo.BusiSumUpSaleOrderInfoDlzqReqBO;
import com.tydic.fsc.settle.busi.api.bo.BusiSumUpSaleOrderInfoDlzqRspBO;
import com.tydic.fsc.settle.dao.SaleItemInfoMapper;
import com.tydic.fsc.settle.dao.SaleOrderInfoMapper;
import com.tydic.fsc.settle.dao.po.SaleOrderInfo;
import com.tydic.fsc.settle.dao.vo.SaleItemInfoVO;
import com.tydic.fsc.settle.dao.vo.SaleOrderInfoVO;
import com.tydic.fsc.settle.enums.OrderSource;
import java.math.BigDecimal;
import java.util.HashSet;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class BusiSumUpSaleOrderInfoDlzqServiceImpl
implements BusiSumUpSaleOrderInfoDlzqService {
    private static final Logger logger = LoggerFactory.getLogger(BusiSumUpSaleOrderInfoDlzqServiceImpl.class);
    @Autowired
    private SaleItemInfoMapper saleItemInfoMapper;
    @Autowired
    private SaleOrderInfoMapper saleOrderInfoMapper;

    public BusiSumUpSaleOrderInfoDlzqRspBO query(BusiSumUpSaleOrderInfoDlzqReqBO reqBO) {
        List<Long> supplierIds;
        Object set;
        BusiSumUpSaleOrderInfoDlzqRspBO rspBO = new BusiSumUpSaleOrderInfoDlzqRspBO();
        if (logger.isDebugEnabled()) {
            logger.debug("\u7edf\u8ba1\u9500\u552e\u8ba2\u5355\u7b14\u6570\u548c\u91d1\u989d\u670d\u52a1(\u7535\u529b\u4e13\u533a)(\u4e13\u4e1a\u516c\u53f8\u548c\u91c7\u8d2d\u5355\u4f4d\u5171\u7528)\u5165\u53c2\uff1a" + reqBO);
        }
        if (reqBO == null) {
            throw new BusinessException("0001", "\u5165\u53c2\u4e0d\u80fd\u4e3a\u7a7a");
        }
        List seqNos = reqBO.getSeqNos();
        if (seqNos == null || seqNos.isEmpty()) {
            throw new BusinessException("0001", "\u5165\u53c2\u5546\u54c1ID\u3010seqNos\u3011\u4e0d\u80fd\u4e3a\u7a7a");
        }
        SaleItemInfoVO saleItemInfoVO = new SaleItemInfoVO();
        saleItemInfoVO.setSeqList(seqNos);
        List<SaleOrderInfo> saleOrderInfoList = this.saleItemInfoMapper.selectSumGroupByInspectionId(saleItemInfoVO);
        SaleOrderInfoVO saleOrderInfoVO = new SaleOrderInfoVO();
        saleOrderInfoVO.setSeqList(seqNos);
        List<SaleOrderInfo> list = this.saleOrderInfoMapper.getList(saleOrderInfoVO);
        SaleOrderInfo order = new SaleOrderInfo();
        order.setInspectionId(saleOrderInfoList.get(0).getInspectionId());
        order = this.saleOrderInfoMapper.getModelBy(order);
        if (!OrderSource.CONSULT_PRICE_FRAME.getCode().equals(order.getSource()) && !OrderSource.CONSULT_PRICE.getCode().equals(order.getSource()) && (set = new HashSet<Long>(supplierIds = this.saleItemInfoMapper.getSupIdBySeqs(seqNos))).size() != 1) {
            throw new BusinessException("18000", "\u4e0d\u540c\u4f9b\u5e94\u5546\u4e0d\u80fd\u4e00\u8d77\u63d0\u4ea4\u5f00\u7968\u7533\u8bf7");
        }
        if (OrderSource.CONSULT_PRICE_FRAME.getCode().equals(order.getSource()) || OrderSource.CONSULT_PRICE.getCode().equals(order.getSource())) {
            Long purchaseProjectId = list.get(0).getPurchaseProjectId();
            logger.debug("list.get(0)====" + purchaseProjectId);
            for (SaleOrderInfo saleOrderInfo : list) {
                logger.debug("saleOrderInfo.getPurchaseProjectId()====" + saleOrderInfo.getPurchaseProjectId());
                if (saleOrderInfo.getPurchaseProjectId().equals(purchaseProjectId)) continue;
                throw new BusinessException("18000", "\u5fc5\u987b\u4e3a\u540c\u4e00\u4e2a\u91c7\u8d2d\u5355\u4f4d\u7684\u8ba2\u5355\u624d\u80fd\u591f\u5408\u5e76\u53d1\u8d77\u5f00\u7968\u901a\u77e5\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u3002");
            }
        }
        BigDecimal totalAmt = BigDecimal.ZERO;
        Integer recordsTotal = saleOrderInfoList.size();
        Long orderId = null;
        for (SaleOrderInfo saleOrderInfo : saleOrderInfoList) {
            totalAmt = totalAmt.add(saleOrderInfo.getOrderAmt());
            if (!OrderSource.ELECTRIC_AREA.getCode().equals(order.getSource()) && !OrderSource.COAL_AREA.getCode().equals(order.getSource())) continue;
            if (orderId != null && !orderId.equals(saleOrderInfo.getOrderId())) {
                throw new BusinessException("18000", "\u7535\u529b\u4e13\u533a/\u7164\u70ad\u4e13\u533a\u4e0d\u5141\u8bb8\u591a\u4e2a\u8ba2\u5355\u4e00\u8d77\u7533\u8bf7\u5f00\u7968");
            }
            orderId = saleOrderInfo.getOrderId();
        }
        rspBO.setRecordsTotal(recordsTotal);
        rspBO.setTotalAmt(totalAmt);
        return rspBO;
    }
}

