/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.settle.busi.impl;

import com.tydic.fsc.settle.atom.EnumsService;
import com.tydic.fsc.settle.atom.OrganizationInfoService;
import com.tydic.fsc.settle.atom.UserInfoService;
import com.tydic.fsc.settle.busi.api.BusiTranDetailListService;
import com.tydic.fsc.settle.busi.api.bo.BusiTranDetailListRspBO;
import com.tydic.fsc.settle.busi.api.bo.BusiTranDetailReqBO;
import com.tydic.fsc.settle.busi.api.bo.BusiTranDetailRspBO;
import com.tydic.fsc.settle.dao.TranDetailMapper;
import com.tydic.fsc.settle.dao.bo.TranDetailExt;
import com.tydic.fsc.settle.dao.po.Pagination;
import com.tydic.fsc.settle.enums.BusinessType;
import com.tydic.fsc.settle.enums.SubAccountServiceType;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class BusiTranDetailListServiceImpl
implements BusiTranDetailListService {
    private static final Logger logger = LoggerFactory.getLogger(BusiTranDetailListServiceImpl.class);
    @Autowired
    private TranDetailMapper mapper;
    @Autowired
    private OrganizationInfoService orgService;
    @Autowired
    private EnumsService enumsService;
    @Autowired
    private UserInfoService userInfoService;

    public BusiTranDetailListRspBO listTranDetail(BusiTranDetailReqBO reqBO) {
        if (logger.isDebugEnabled()) {
            logger.debug("\u4ea4\u6613\u5386\u53f2\u660e\u7ec6\u67e5\u8be2BO:" + reqBO);
        }
        Long orgId = reqBO.getOrgId();
        TranDetailExt extInfo = new TranDetailExt();
        BeanUtils.copyProperties((Object)reqBO, (Object)((Object)extInfo));
        extInfo.setOrgId(orgId);
        if (BusinessType.ACCOUNT_REGULATION.getCode().equals(extInfo.getBusinessType())) {
            ArrayList<String> businessTypeList = new ArrayList<String>();
            businessTypeList.add(BusinessType.ACCOUNT_REGULATION.getCode());
            businessTypeList.add(BusinessType.BANK_RECONCILIATION.getCode());
            businessTypeList.add(BusinessType.MALL_RECONCILIATION.getCode());
            extInfo.setBusinessTypeList(businessTypeList);
            extInfo.setBusinessType(null);
        }
        int tot = this.mapper.selectForCount(extInfo);
        Pagination pg = new Pagination();
        pg.setPage(reqBO.getPageNo());
        pg.setPageSize(reqBO.getPageSize());
        pg.setTotalCount(tot);
        int rowIndex = pg.getRowIndex();
        extInfo.setPageSize(pg.getPageSize());
        extInfo.setRowIndex(rowIndex);
        List<TranDetailExt> ls = this.mapper.queryPageSelective(extInfo);
        BusiTranDetailListRspBO resp = new BusiTranDetailListRspBO();
        resp.setTotal(pg.getPageCount().intValue());
        resp.setRecordsTotal(pg.getTotalCount().intValue());
        resp.setPageNo(pg.getPage().intValue());
        resp.setRows(new ArrayList());
        for (int i = 0; i < ls.size(); ++i) {
            TranDetailExt inf = ls.get(i);
            BusiTranDetailRspBO respBo = new BusiTranDetailRspBO();
            resp.getRows().add(respBo);
            BeanUtils.copyProperties((Object)((Object)inf), (Object)respBo);
            String userName = this.userInfoService.queryUserNameByUserId(inf.getLoginId());
            respBo.setLoginName(userName);
            respBo.setPayOrgName(this.orgService.queryOrgName(inf.getPayOrgId()));
            respBo.setRecvOrgName(this.orgService.queryOrgName(inf.getRecvOrgId()));
            BusinessType busiType = BusinessType.getInstance(inf.getBusinessType());
            respBo.setBusinessTypeDescr(this.enumsService.getDescr(busiType));
            SubAccountServiceType srvType = SubAccountServiceType.convert(inf.getPayServiceType());
            respBo.setPayServiceTypeDescr(this.enumsService.getDescr(srvType));
            srvType = SubAccountServiceType.convert(inf.getRecvServiceType());
            respBo.setRecvServiceTypeDescr(this.enumsService.getDescr(srvType));
        }
        return resp;
    }
}

