/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.settle.busi.impl;

import com.ohaotian.plugin.base.exception.BusinessException;
import com.ohaotian.plugin.db.Page;
import com.tydic.fsc.settle.atom.BillSNService;
import com.tydic.fsc.settle.atom.EnumsService;
import com.tydic.fsc.settle.busi.api.DzcsInvoiceReturnApplyBlueInvoiceService;
import com.tydic.fsc.settle.busi.api.bo.DzcsInvoiceReturnApplyBlueInvoiceReqBO;
import com.tydic.fsc.settle.busi.api.bo.DzcsInvoiceReturnApplyBlueInvoiceRspBO;
import com.tydic.fsc.settle.busi.api.vo.InvoiceHeaderVO;
import com.tydic.fsc.settle.busi.api.vo.InvoiceMailAddrInfoVO;
import com.tydic.fsc.settle.dao.BillApplyInfoMapper;
import com.tydic.fsc.settle.dao.InvoiceReturnDetailMapper;
import com.tydic.fsc.settle.dao.InvoiceReturnMapper;
import com.tydic.fsc.settle.dao.SaleInvoiceDetailMapper;
import com.tydic.fsc.settle.dao.SaleItemInfoMapper;
import com.tydic.fsc.settle.dao.po.BillApplyInfo;
import com.tydic.fsc.settle.dao.po.InvoiceReturn;
import com.tydic.fsc.settle.dao.po.InvoiceReturnDetail;
import com.tydic.fsc.settle.dao.po.SaleInvoiceDetail;
import com.tydic.fsc.settle.dao.po.SaleItemInfo;
import com.tydic.fsc.settle.dao.vo.InvoiceReturnDetailVO;
import com.tydic.fsc.settle.dao.vo.SaleInvoiceDetailVO;
import com.tydic.fsc.settle.dao.vo.SaleItemInfoVO;
import com.tydic.fsc.settle.enums.BillStatus;
import com.tydic.fsc.settle.enums.BillType;
import com.tydic.fsc.settle.enums.InvoiceClasses;
import com.tydic.fsc.settle.enums.InvoiceReturnStatus;
import com.tydic.fsc.settle.enums.RedBlue;
import com.tydic.fsc.settle.enums.SaleItemApplyInfoStatus;
import com.tydic.fsc.settle.enums.YesNo;
import com.tydic.fsc.settle.utils.FscStringUtils;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

@Service
public class DzcsInvoiceReturnApplyBlueInvoiceServiceImpl
implements DzcsInvoiceReturnApplyBlueInvoiceService {
    private static final Logger logger = LoggerFactory.getLogger(DzcsInvoiceReturnApplyBlueInvoiceServiceImpl.class);
    @Autowired
    private BillSNService billSNService;
    @Autowired
    private EnumsService enumsService;
    @Autowired
    private InvoiceReturnMapper invoiceReturnMapper;
    @Autowired
    private InvoiceReturnDetailMapper invoiceReturnDetailMapper;
    @Autowired
    private BillApplyInfoMapper billApplyInfoMapper;
    @Autowired
    private SaleInvoiceDetailMapper saleInvoiceDetailMapper;
    @Autowired
    private SaleItemInfoMapper saleItemInfoMapper;

    public DzcsInvoiceReturnApplyBlueInvoiceRspBO process(DzcsInvoiceReturnApplyBlueInvoiceReqBO reqBO) {
        if (logger.isDebugEnabled()) {
            logger.debug("\u84dd\u5b57\u5f00\u7968\u7533\u8bf7\u670d\u52a1\uff08\u7535\u5b50\u8d85\u5e02\u9000\u7968\uff09\u5165\u53c2\uff1a" + reqBO);
        }
        String billNo = reqBO.getBillNo();
        InvoiceHeaderVO invoiceInfo = reqBO.getInvoiceInfo();
        InvoiceMailAddrInfoVO mailAddrInfo = reqBO.getMailAddrInfo();
        if (!StringUtils.hasText((String)billNo)) {
            throw new BusinessException("0001", "\u9000\u7968\u7533\u8bf7\u5355\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (null == mailAddrInfo) {
            throw new BusinessException("0001", "\u53d1\u7968\u90ae\u5bc4\u5730\u5740\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (null == invoiceInfo) {
            throw new BusinessException("0001", "\u53d1\u7968\u62ac\u5934\u4e0d\u80fd\u4e3a\u7a7a");
        }
        InvoiceReturn invoiceReturn = this.invoiceReturnMapper.selectByPrimaryKey(billNo);
        if (null == invoiceReturn) {
            throw new BusinessException("18001", "\u9000\u7968\u7533\u8bf7\u5355\u53f7" + billNo + "\u6ca1\u6709\u9000\u7968\u7533\u8bf7\u8bb0\u5f55");
        }
        InvoiceReturnDetailVO vo = new InvoiceReturnDetailVO();
        vo.setBillNo(billNo);
        List<InvoiceReturnDetail> details = this.invoiceReturnDetailMapper.selectList(vo);
        if (CollectionUtils.isEmpty(details)) {
            throw new BusinessException("18001", "\u9000\u7968\u7533\u8bf7\u5355\u53f7" + billNo + "\u6ca1\u6709\u9000\u7968\u7533\u8bf7\u660e\u7ec6\u8bb0\u5f55");
        }
        if (!InvoiceReturnStatus.RETURNED.getCode().equals(invoiceReturn.getStatus())) {
            throw new BusinessException("0001", "\u72b6\u6001\u5fc5\u987b\u662f\uff1a" + this.enumsService.getDescr(InvoiceReturnStatus.RETURNED));
        }
        HashMap applyNo1Map = new HashMap();
        for (InvoiceReturnDetail invoiceReturnDetail : details) {
            if (applyNo1Map.containsKey(invoiceReturnDetail.getApplyNo1())) {
                ((List)applyNo1Map.get(invoiceReturnDetail.getApplyNo1())).add(invoiceReturnDetail.getInvoiceNo1());
                continue;
            }
            ArrayList<String> arrayList = new ArrayList<String>();
            arrayList.add(invoiceReturnDetail.getInvoiceNo1());
            applyNo1Map.put(invoiceReturnDetail.getApplyNo1(), arrayList);
        }
        ArrayList<String> applyNo3s = new ArrayList<String>();
        for (Map.Entry entry : applyNo1Map.entrySet()) {
            String applyNo1 = (String)entry.getKey();
            List invoiceNo1s = (List)entry.getValue();
            Page page = new Page(1, 999999);
            SaleInvoiceDetailVO saleInvoiceDatailVO = new SaleInvoiceDetailVO();
            saleInvoiceDatailVO.setInvoiceNoList(invoiceNo1s);
            List<SaleInvoiceDetail> detailList = this.saleInvoiceDetailMapper.selectListPage(saleInvoiceDatailVO, (Page<Map<String, Object>>)page);
            if (CollectionUtils.isEmpty(detailList)) {
                throw new BusinessException("18000", "\u539f\u53d1\u7968\u6570\u636e\u5bf9\u5e94\u7684\u53d1\u7968\u660e\u7ec6\u4e0d\u5b58\u5728");
            }
            HashSet<Long> itemNoSet = new HashSet<Long>();
            HashSet<Long> inspectionIdSet = new HashSet<Long>();
            for (SaleInvoiceDetail invoiceDetail : detailList) {
                itemNoSet.add(invoiceDetail.getItemNo());
                inspectionIdSet.add(invoiceDetail.getInspectionId());
            }
            SaleItemInfoVO saleItemInfoVO = new SaleItemInfoVO();
            saleItemInfoVO.setApplyNo(applyNo1);
            saleItemInfoVO.setSaleItemApplyInfoStatus(SaleItemApplyInfoStatus.VALID.getCode());
            saleItemInfoVO.setInspectionIdList(new ArrayList<Long>(inspectionIdSet));
            saleItemInfoVO.setItemNoList(new ArrayList<Long>(itemNoSet));
            List<SaleItemInfo> saleItems = this.saleItemInfoMapper.getListJoinSaleItemApplyInfo(saleItemInfoVO);
            if (CollectionUtils.isEmpty(saleItems)) {
                throw new BusinessException("18000", "\u6839\u636e\u5f00\u7968\u7533\u8bf7\u5355\u53f7[" + applyNo1 + "]\u67e5\u4e0d\u5230\u5546\u54c1\u660e\u7ec6");
            }
            BigDecimal amt = BigDecimal.ZERO;
            for (SaleItemInfo saleItemInfo : saleItems) {
                amt = amt.add(saleItemInfo.getAmount());
            }
            BillApplyInfo billApplyInfo1 = this.billApplyInfoMapper.selectByPrimaryKey(applyNo1);
            String applyNo3 = this.billSNService.getSnAsString(BillType.INVOICE_APPLICATION);
            BillApplyInfo billApplyInfo3 = new BillApplyInfo();
            billApplyInfo3.setApplyNo(applyNo3);
            billApplyInfo3.setApplyDate(new Date());
            billApplyInfo3.setReturnBillNo(billNo);
            billApplyInfo3.setRedBlue(RedBlue.BLUE.getCode());
            billApplyInfo3.setAmt(amt);
            billApplyInfo3.setBillStatus(BillStatus.NO_APPLY.getCode());
            billApplyInfo3.setUserId(reqBO.getUserId());
            billApplyInfo3.setSource(billApplyInfo1.getSource());
            billApplyInfo3.setApplyType(billApplyInfo1.getApplyType());
            billApplyInfo3.setSupplierNo(billApplyInfo1.getSupplierNo());
            billApplyInfo3.setSupplierName(billApplyInfo1.getSupplierName());
            billApplyInfo3.setOperUnitNo(billApplyInfo1.getOperUnitNo());
            billApplyInfo3.setOperUnitName(billApplyInfo1.getOperUnitName());
            billApplyInfo3.setPayFeeType(billApplyInfo1.getPayFeeType());
            billApplyInfo3.setInvoiceClasses(InvoiceClasses.PAPER_INVOICE.getCode());
            billApplyInfo3.setInvoiceType(String.valueOf(invoiceInfo.getInvoiceType()));
            billApplyInfo3.setInvoceName(invoiceInfo.getInvoiceTitle());
            billApplyInfo3.setTaxNo(invoiceInfo.getTaxpayerId());
            billApplyInfo3.setAddr(invoiceInfo.getAddress());
            billApplyInfo3.setPhone(invoiceInfo.getPhone());
            billApplyInfo3.setBankName(invoiceInfo.getBank());
            billApplyInfo3.setBankAcctNo(invoiceInfo.getAccount());
            billApplyInfo3.setName(mailAddrInfo.getName());
            billApplyInfo3.setProvince(mailAddrInfo.getProvince());
            billApplyInfo3.setCity(mailAddrInfo.getCity());
            billApplyInfo3.setCounty(mailAddrInfo.getCounty());
            billApplyInfo3.setTown("0".equals(mailAddrInfo.getTown()) ? null : mailAddrInfo.getTown());
            billApplyInfo3.setProvId(mailAddrInfo.getProvId());
            billApplyInfo3.setCityId(mailAddrInfo.getCityId());
            billApplyInfo3.setCountyId(mailAddrInfo.getCountyId());
            billApplyInfo3.setTownId(mailAddrInfo.getTownId());
            billApplyInfo3.setAddrDesc(mailAddrInfo.getAddrDesc());
            billApplyInfo3.setMobile(mailAddrInfo.getTel());
            billApplyInfo3.setTel(mailAddrInfo.getSpecialPlane());
            billApplyInfo3.setPostCode(mailAddrInfo.getPostCode());
            billApplyInfo3.setUrgedInvoice(YesNo.NO.getCode());
            billApplyInfo3.setRemark(null);
            this.billApplyInfoMapper.insert(billApplyInfo3);
            InvoiceReturnDetailVO whereRecord = new InvoiceReturnDetailVO();
            whereRecord.setBillNo(billNo);
            whereRecord.setApplyNo1(applyNo1);
            InvoiceReturnDetailVO valueRecord = new InvoiceReturnDetailVO();
            valueRecord.setApplyNo3(applyNo3);
            this.invoiceReturnDetailMapper.updateBy(whereRecord, valueRecord);
            applyNo3s.add(applyNo3);
        }
        invoiceReturn = new InvoiceReturn();
        invoiceReturn.setBillNo(billNo);
        invoiceReturn.setStatus(InvoiceReturnStatus.TO_BILL.getCode());
        this.invoiceReturnMapper.updateByPrimaryKeySelective(invoiceReturn);
        DzcsInvoiceReturnApplyBlueInvoiceRspBO dzcsInvoiceReturnApplyBlueInvoiceRspBO = new DzcsInvoiceReturnApplyBlueInvoiceRspBO();
        dzcsInvoiceReturnApplyBlueInvoiceRspBO.setMsg("\u540e\u53f0\u751f\u6210" + applyNo3s.size() + "\u4e2a\u84dd\u5b57\u5f00\u7968\u7533\u8bf7\u5355\uff0c\u548c\u539f\u5f00\u7968\u7533\u8bf7\u5355\u4e00\u4e00\u5bf9\u5e94\uff1a" + FscStringUtils.list2String(applyNo3s, "\uff0c"));
        return dzcsInvoiceReturnApplyBlueInvoiceRspBO;
    }
}

