/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.settle.busi.impl;

import com.ohaotian.plugin.base.exception.BusinessException;
import com.tydic.fsc.settle.atom.EnumsService;
import com.tydic.fsc.settle.bo.FscBaseRspBo;
import com.tydic.fsc.settle.busi.api.DzcsInvoiceReturnCheckService;
import com.tydic.fsc.settle.busi.api.bo.DzcsInvoiceReturnCheckReqBO;
import com.tydic.fsc.settle.dao.BillApplyInfoMapper;
import com.tydic.fsc.settle.dao.po.BillApplyInfo;
import com.tydic.fsc.settle.dao.vo.BillApplyInfoVO;
import com.tydic.fsc.settle.enums.BillStatus;
import java.util.Collection;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class DzcsInvoiceReturnCheckServiceImpl
implements DzcsInvoiceReturnCheckService {
    private static final Logger logger = LoggerFactory.getLogger(DzcsInvoiceReturnCheckServiceImpl.class);
    @Autowired
    private EnumsService enumsService;
    @Autowired
    private BillApplyInfoMapper billApplyInfoMapper;

    public FscBaseRspBo query(DzcsInvoiceReturnCheckReqBO reqBO) {
        List applyNos;
        if (logger.isDebugEnabled()) {
            logger.debug("\u9000\u7968\u6821\u9a8c\u670d\u52a1\uff08\u7535\u5b50\u8d85\u5e02\u9000\u7968\uff09\u5165\u53c2\uff1a" + reqBO);
        }
        if (CollectionUtils.isEmpty((Collection)(applyNos = reqBO.getApplyNos()))) {
            throw new BusinessException("0001", "\u8bf7\u52fe\u9009");
        }
        BillApplyInfoVO billApplyInfoVO = new BillApplyInfoVO();
        billApplyInfoVO.setApplyNoList(applyNos);
        List<BillApplyInfo> applys = this.billApplyInfoMapper.getList(billApplyInfoVO);
        Long purchaseProjectId = null;
        Long operUnitNo = null;
        String invoiceType = null;
        String invoiceClasses = null;
        for (BillApplyInfo apply : applys) {
            if (!BillStatus.SEND_BILL.getCode().equals(apply.getBillStatus())) {
                throw new BusinessException("0001", "\u5f00\u7968\u7533\u8bf7\u5355\u7684\u72b6\u6001\u5fc5\u987b\u662f" + this.enumsService.getDescr(BillStatus.SEND_BILL));
            }
            if (purchaseProjectId == null) {
                purchaseProjectId = apply.getPurchaseProjectId();
            } else if (!purchaseProjectId.equals(apply.getPurchaseProjectId())) {
                throw new BusinessException("0001", "\u4e0d\u540c\u91c7\u8d2d\u5355\u4f4d\u4e0d\u80fd\u4e00\u8d77\u7533\u8bf7\u9000\u7968");
            }
            if (operUnitNo == null) {
                operUnitNo = apply.getOperUnitNo();
            } else if (!operUnitNo.equals(apply.getOperUnitNo())) {
                throw new BusinessException("0001", "\u4e0d\u540c\u4e13\u4e1a\u516c\u53f8\u4e0d\u80fd\u4e00\u8d77\u7533\u8bf7\u9000\u7968");
            }
            if (invoiceType == null) {
                invoiceType = apply.getInvoiceType();
            } else if (!invoiceType.equals(apply.getInvoiceType())) {
                throw new BusinessException("0001", "\u4e13\u7968\u548c\u666e\u7968\u4e0d\u80fd\u4e00\u8d77\u7533\u8bf7\u9000\u7968");
            }
            if (invoiceClasses == null) {
                invoiceClasses = apply.getInvoiceClasses();
                continue;
            }
            if (invoiceClasses.equals(apply.getInvoiceClasses())) continue;
            throw new BusinessException("0001", "\u7535\u5b50\u53d1\u7968\u548c\u7eb8\u8d28\u53d1\u7968\u4e0d\u80fd\u4e00\u8d77\u7533\u8bf7\u9000\u7968");
        }
        return new FscBaseRspBo();
    }
}

