/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.settle.busi.impl;

import com.alibaba.druid.util.StringUtils;
import com.ohaotian.plugin.base.exception.BusinessException;
import com.tydic.fsc.settle.atom.EnumsService;
import com.tydic.fsc.settle.busi.api.DzcsInvoiceReturnQryApplyDetailService;
import com.tydic.fsc.settle.busi.api.bo.DzcsInvoiceReturnQryApplyDetailItemRspBO;
import com.tydic.fsc.settle.busi.api.bo.DzcsInvoiceReturnQryApplyDetailReqBO;
import com.tydic.fsc.settle.busi.api.bo.DzcsInvoiceReturnQryApplyDetailRspBO;
import com.tydic.fsc.settle.dao.InvoiceReturnDetailMapper;
import com.tydic.fsc.settle.dao.InvoiceReturnMapper;
import com.tydic.fsc.settle.dao.po.InvoiceReturn;
import com.tydic.fsc.settle.dao.po.InvoiceReturnDetail;
import com.tydic.fsc.settle.dao.vo.InvoiceReturnDetailExt;
import com.tydic.fsc.settle.dao.vo.InvoiceReturnDetailVO;
import com.tydic.fsc.settle.enums.InvoiceClasses;
import com.tydic.fsc.settle.enums.InvoiceReturnType;
import com.tydic.fsc.settle.enums.InvoiceType;
import com.tydic.fsc.settle.enums.SaleInvoiceInfoInvoiceStatus;
import com.tydic.fsc.settle.utils.FileUtils;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class DzcsInvoiceReturnQryApplyDetailServiceImpl
implements DzcsInvoiceReturnQryApplyDetailService {
    private static final Logger logger = LoggerFactory.getLogger(DzcsInvoiceReturnQryApplyDetailServiceImpl.class);
    private static final boolean isDebugEnabled = logger.isDebugEnabled();
    @Autowired
    private InvoiceReturnMapper invoiceReturnMapper;
    @Autowired
    private InvoiceReturnDetailMapper invoiceReturnDetailMapper;
    @Autowired
    private EnumsService enumsService;

    public DzcsInvoiceReturnQryApplyDetailRspBO query(DzcsInvoiceReturnQryApplyDetailReqBO reqBO) {
        if (isDebugEnabled) {
            logger.debug("\u7535\u5b50\u8d85\u5e02\u67e5\u770b\u9000\u7968\u7533\u8bf7\u8be6\u60c5\u9875\u9762\u670d\u52a1\u5165\u53c2\uff1a{}", (Object)reqBO);
        }
        if (reqBO == null) {
            throw new BusinessException("0001", "\u8bf7\u6c42\u5165\u53c2\u4e3a\u7a7a");
        }
        if (StringUtils.isEmpty((CharSequence)reqBO.getBillNo())) {
            throw new BusinessException("0001", "\u9000\u7968\u7533\u8bf7\u5355\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
        }
        String billNo = reqBO.getBillNo();
        InvoiceReturn invoiceReturn = this.invoiceReturnMapper.selectByPrimaryKey(billNo);
        if (invoiceReturn == null) {
            throw new BusinessException("0001", "\u9000\u7968\u7533\u8bf7\u5355\u4e0d\u5b58\u5728\uff0c\u8bf7\u6838\u5b9e");
        }
        DzcsInvoiceReturnQryApplyDetailRspBO resultRspBO = new DzcsInvoiceReturnQryApplyDetailRspBO();
        resultRspBO.setAuthRemark(invoiceReturn.getAuthRemark());
        resultRspBO.setCreateMail(invoiceReturn.getCreateMail());
        resultRspBO.setCreateOrg(invoiceReturn.getCreateOrg());
        resultRspBO.setCreatePhone(invoiceReturn.getCreatePhone());
        resultRspBO.setCreateUser(invoiceReturn.getCreateUser());
        resultRspBO.setReturnRemark(invoiceReturn.getRemark());
        resultRspBO.setType(invoiceReturn.getType());
        resultRspBO.setTypeDescr(this.enumsService.getDescr(InvoiceReturnType.getInstance(invoiceReturn.getType())));
        ArrayList<DzcsInvoiceReturnQryApplyDetailItemRspBO> detailItemList = new ArrayList<DzcsInvoiceReturnQryApplyDetailItemRspBO>();
        resultRspBO.setDetailItemList(detailItemList);
        InvoiceReturnDetailVO vo = new InvoiceReturnDetailVO();
        vo.setBillNo(invoiceReturn.getBillNo());
        vo.setOrderBy("BILL_NO, APPLY_NO_1");
        List<InvoiceReturnDetail> returnDetailList = this.invoiceReturnDetailMapper.selectList(vo);
        for (InvoiceReturnDetail detailVO : returnDetailList) {
            vo.setBillNoConcatInvoiceNo(detailVO.getBillNo() + "-" + detailVO.getInvoiceNo1());
            List<InvoiceReturnDetailExt> detailExtList = this.invoiceReturnDetailMapper.selectJoinApplyAndInvoice(vo);
            DzcsInvoiceReturnQryApplyDetailItemRspBO itemRspBO = new DzcsInvoiceReturnQryApplyDetailItemRspBO();
            for (InvoiceReturnDetailExt extBO : detailExtList) {
                DzcsInvoiceReturnQryApplyDetailItemRspBO.DzcsInvoiceReturnQryInvoiceDetailRspBO invoiceDetailRspBO = new DzcsInvoiceReturnQryApplyDetailItemRspBO.DzcsInvoiceReturnQryInvoiceDetailRspBO(itemRspBO);
                BeanUtils.copyProperties((Object)extBO, (Object)invoiceDetailRspBO);
                Integer invoiceTypeValue = StringUtils.isEmpty((CharSequence)invoiceDetailRspBO.getInvoiceType()) ? null : Integer.valueOf(Integer.parseInt(invoiceDetailRspBO.getInvoiceType()));
                invoiceDetailRspBO.setInvoiceTypeDescr(this.enumsService.getDescr(InvoiceType.getInstance(invoiceTypeValue)));
                invoiceDetailRspBO.setInvoiceClassesDescr(this.enumsService.getDescr(InvoiceClasses.getInstance(invoiceDetailRspBO.getInvoiceClasses())));
                invoiceDetailRspBO.setInvoiceStatusDescr(this.enumsService.getDescr(SaleInvoiceInfoInvoiceStatus.getInstance(invoiceDetailRspBO.getInvoiceStatus())));
                invoiceDetailRspBO.setInvoiceUrl(FileUtils.obtainOSSUrl(invoiceDetailRspBO.getElectronicInvoiceName()));
                if ("1".equals(extBO.getReturnFlag())) {
                    itemRspBO.setOriginInvoiceDetailRspBO(invoiceDetailRspBO);
                    continue;
                }
                if ("2".equals(extBO.getReturnFlag())) {
                    itemRspBO.setRedInvoiceDetailRspBO(invoiceDetailRspBO);
                    continue;
                }
                if (!"3".equals(extBO.getReturnFlag())) continue;
                itemRspBO.setBlueInvoiceDetailRspBO(invoiceDetailRspBO);
            }
            detailItemList.add(itemRspBO);
        }
        return resultRspBO;
    }
}

