/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.settle.busi.impl;

import com.ohaotian.plugin.base.exception.BusinessException;
import com.tydic.fsc.settle.atom.BillSNService;
import com.tydic.fsc.settle.atom.EnumsService;
import com.tydic.fsc.settle.atom.OrganizationInfoService;
import com.tydic.fsc.settle.atom.UserInfoService;
import com.tydic.fsc.settle.busi.api.InvoiceReturnPreApplyService;
import com.tydic.fsc.settle.busi.api.bo.InvoiceReturnFileRspBO;
import com.tydic.fsc.settle.busi.api.bo.InvoiceReturnInvoiceRspBO;
import com.tydic.fsc.settle.busi.api.bo.InvoiceReturnPreApplyReqBO;
import com.tydic.fsc.settle.busi.api.bo.InvoiceReturnPreApplyRspBO;
import com.tydic.fsc.settle.dao.BillApplyInfoMapper;
import com.tydic.fsc.settle.dao.InvoiceReturnMapper;
import com.tydic.fsc.settle.dao.SaleInvoiceInfoMapper;
import com.tydic.fsc.settle.dao.po.BillApplyInfo;
import com.tydic.fsc.settle.dao.po.InvoiceReturn;
import com.tydic.fsc.settle.dao.po.SaleInvoiceInfo;
import com.tydic.fsc.settle.dao.vo.SaleInvoiceInfoVO;
import com.tydic.fsc.settle.enums.BillType;
import com.tydic.fsc.settle.enums.InvoiceClasses;
import com.tydic.fsc.settle.enums.InvoiceReturnFileType;
import com.tydic.fsc.settle.enums.InvoiceType;
import com.tydic.fsc.settle.enums.SaleInvoiceInfoInvoiceStatus;
import com.tydic.fsc.settle.utils.FileUtils;
import com.tydic.fsc.settle.utils.FscStringUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class InvoiceReturnPreApplyServiceImpl
implements InvoiceReturnPreApplyService {
    private static final Logger logger = LoggerFactory.getLogger(InvoiceReturnPreApplyServiceImpl.class);
    @Autowired
    private BillSNService billSNService;
    @Autowired
    private OrganizationInfoService organizationInfoService;
    @Autowired
    private UserInfoService userInfoService;
    @Autowired
    private EnumsService enumsService;
    @Autowired
    private InvoiceReturnMapper invoiceReturnMapper;
    @Autowired
    private BillApplyInfoMapper billApplyInfoMapper;
    @Autowired
    private SaleInvoiceInfoMapper saleInvoiceInfoMapper;

    public InvoiceReturnPreApplyRspBO process(InvoiceReturnPreApplyReqBO reqBO) {
        List applyNos;
        if (logger.isDebugEnabled()) {
            logger.debug("\u9000\u7968\u9884\u7533\u8bf7\u670d\u52a1\uff08\u5e73\u53f0\u4f7f\u7528\u8d39\u9000\u7968\uff09\u5165\u53c2\uff1a" + reqBO);
        }
        if (CollectionUtils.isEmpty((Collection)(applyNos = reqBO.getApplyNos()))) {
            throw new BusinessException("0001", "\u8bf7\u52fe\u9009");
        }
        String billNo = this.billSNService.getSnAsString(BillType.INVOICE_RETURN);
        String applyNo1 = FscStringUtils.list2String(applyNos, ",");
        InvoiceReturnPreApplyRspBO rspBO = new InvoiceReturnPreApplyRspBO();
        ArrayList<InvoiceReturnInvoiceRspBO> invoices = new ArrayList<InvoiceReturnInvoiceRspBO>();
        rspBO.setInvoices(invoices);
        for (String applyNo : applyNos) {
            BillApplyInfo billApplyInfo = this.billApplyInfoMapper.selectByPrimaryKey(applyNo);
            SaleInvoiceInfoVO saleInvoiceInfoVO = new SaleInvoiceInfoVO();
            saleInvoiceInfoVO.setApplyNo(applyNo);
            List<SaleInvoiceInfo> saleInvoiceInfos = this.saleInvoiceInfoMapper.selectBy(saleInvoiceInfoVO);
            for (SaleInvoiceInfo saleInvoiceInfo : saleInvoiceInfos) {
                InvoiceReturnInvoiceRspBO invoice = new InvoiceReturnInvoiceRspBO();
                invoices.add(invoice);
                BeanUtils.copyProperties((Object)billApplyInfo, (Object)invoice);
                invoice.setMatchFlag("0");
                invoice.setSupplierName(this.organizationInfoService.querySupplierName(billApplyInfo.getSupplierNo()));
                invoice.setInvoiceTypeDescr(this.enumsService.getDescr(InvoiceType.getInstance(Integer.valueOf(billApplyInfo.getInvoiceType()))));
                invoice.setOperUnitName(this.organizationInfoService.queryOrgName(billApplyInfo.getOperUnitNo()));
                invoice.setInvoiceClassesDescr(this.enumsService.getDescr(InvoiceClasses.getInstance(billApplyInfo.getInvoiceClasses())));
                invoice.setInvoiceNo(saleInvoiceInfo.getInvoiceNo());
                invoice.setInvoiceCode(saleInvoiceInfo.getInvoiceCode());
                invoice.setInvoiceDate(saleInvoiceInfo.getInvoiceDate());
                invoice.setUntaxAmt(saleInvoiceInfo.getUntaxAmt());
                invoice.setTaxAmt(saleInvoiceInfo.getTaxAmt());
                invoice.setAmt(saleInvoiceInfo.getAmt());
                invoice.setInvoiceStatusDescr(this.enumsService.getDescr(SaleInvoiceInfoInvoiceStatus.getInstance(saleInvoiceInfo.getInvoiceStatus())));
            }
        }
        rspBO.setBillNo(billNo);
        rspBO.setCreateUser(this.userInfoService.queryUserNameByUserId(reqBO.getUserId()));
        rspBO.setCreatePhone(reqBO.getCellphone());
        rspBO.setCreateOrg(this.organizationInfoService.queryOrgName(reqBO.getCompanyId()));
        rspBO.setType(null);
        rspBO.setRemark(null);
        ArrayList<InvoiceReturnFileRspBO> files = new ArrayList<InvoiceReturnFileRspBO>();
        rspBO.setFiles(files);
        InvoiceReturnFileRspBO file = new InvoiceReturnFileRspBO();
        file.setFileType(Integer.valueOf(1));
        file.setItemname(InvoiceReturnFileType.LICENSE_FILE.getDescr());
        file.setFilename("");
        file.setFilenameUrl("");
        file.setShowFilenameUrl("0");
        file.setTemplateUrl("");
        file.setShowTemplateUrl("0");
        file.setShowUpload("1");
        file.setShowDelete("0");
        files.add(file);
        file = new InvoiceReturnFileRspBO();
        file.setFileType(Integer.valueOf(2));
        file.setItemname(InvoiceReturnFileType.BANK_LICENSE_FILE.getDescr());
        file.setFilename("");
        file.setFilenameUrl("");
        file.setShowFilenameUrl("0");
        file.setTemplateUrl("");
        file.setShowTemplateUrl("0");
        file.setShowUpload("1");
        file.setShowDelete("0");
        files.add(file);
        file = new InvoiceReturnFileRspBO();
        file.setFileType(Integer.valueOf(3));
        file.setItemname(InvoiceReturnFileType.APPLY_FILE.getDescr());
        file.setFilename("");
        file.setFilenameUrl("");
        file.setShowFilenameUrl("0");
        file.setTemplateUrl(FileUtils.obtainOSSUrl(this.enumsService.queryInvoiceReturnTemplate1()));
        file.setShowTemplateUrl("1");
        file.setShowUpload("1");
        file.setShowDelete("0");
        files.add(file);
        file = new InvoiceReturnFileRspBO();
        file.setFileType(Integer.valueOf(4));
        file.setItemname(InvoiceReturnFileType.REMARK_FILE.getDescr());
        file.setFilename("");
        file.setFilenameUrl("");
        file.setShowFilenameUrl("0");
        file.setTemplateUrl(FileUtils.obtainOSSUrl(this.enumsService.queryInvoiceReturnTemplate2()));
        file.setShowTemplateUrl("1");
        file.setShowUpload("1");
        file.setShowDelete("0");
        files.add(file);
        file = new InvoiceReturnFileRspBO();
        file.setFileType(Integer.valueOf(5));
        file.setItemname(InvoiceReturnFileType.INVOICE_FILE.getDescr());
        file.setFilename("");
        file.setFilenameUrl("");
        file.setShowFilenameUrl("0");
        file.setTemplateUrl("");
        file.setShowTemplateUrl("0");
        file.setShowUpload("1");
        file.setShowDelete("0");
        files.add(file);
        InvoiceReturn invoiceReturn = new InvoiceReturn();
        invoiceReturn.setBillNo(billNo);
        invoiceReturn.setApplyNo1(applyNo1);
        this.invoiceReturnMapper.insert(invoiceReturn);
        return rspBO;
    }
}

