/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.settle.busi.impl;

import com.ohaotian.plugin.base.exception.BusinessException;
import com.ohaotian.plugin.db.Page;
import com.tydic.fsc.settle.atom.EnumsService;
import com.tydic.fsc.settle.busi.api.PayQryCheckingByDayService;
import com.tydic.fsc.settle.busi.api.bo.PayQryCheckingColReqBO;
import com.tydic.fsc.settle.busi.api.bo.PayQryCheckingColRspBO;
import com.tydic.fsc.settle.busi.api.vo.PayCheckingColVO;
import com.tydic.fsc.settle.busi.impl.PayQryCheckingServiceImpl;
import com.tydic.fsc.settle.dao.AdvanceReceiveMapper;
import com.tydic.fsc.settle.dao.InquiryCheckingMapper;
import com.tydic.fsc.settle.dao.OrgPayConfigMapper;
import com.tydic.fsc.settle.dao.po.CheckingAccRec;
import com.tydic.fsc.settle.dao.po.OrgPayConfigPO;
import com.tydic.fsc.settle.dao.po.PayCheckingRst;
import com.tydic.fsc.settle.dao.vo.PayCheckingRstVO;
import com.tydic.fsc.settle.utils.DatesUtils;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class PayQryCheckingByDayServiceImpl
implements PayQryCheckingByDayService {
    private static final Logger logger = LoggerFactory.getLogger(PayQryCheckingServiceImpl.class);
    @Autowired
    private InquiryCheckingMapper inquiryCheckingMapper;
    @Autowired
    private AdvanceReceiveMapper advanceReceiveMapper;
    @Autowired
    private OrgPayConfigMapper orgPayConfigMapper;
    @Autowired
    private EnumsService enumsService;

    public PayQryCheckingColRspBO<PayCheckingColVO> queryCheckingByDay(PayQryCheckingColReqBO reqBO) {
        if (logger.isDebugEnabled()) {
            logger.debug("\u67e5\u8be2\u5bf9\u8d26\u4fe1\u606f\u670d\u52a1\u5165\u53c2\uff1a" + reqBO);
        }
        if (null == reqBO) {
            throw new BusinessException("0001", "\u5165\u53c2\u4e0d\u80fd\u4e3a\u7a7a!");
        }
        if (null == reqBO.getCompanyId()) {
            throw new BusinessException("0001", "\u5165\u53c2\u4e13\u4e1a\u516c\u53f8Id[companyId]\u4e0d\u80fd\u4e3a\u7a7a!");
        }
        PayCheckingRstVO record = new PayCheckingRstVO();
        record.setCheckType("Day");
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        sdf.setLenient(false);
        if (null != reqBO.getStartDate() && !"".equals(reqBO.getStartDate())) {
            try {
                Date startDate = sdf.parse(reqBO.getStartDate());
                record.setStartDate(startDate);
            }
            catch (Exception e) {
                logger.error("\u5165\u53c2\u8d77\u59cb\u65e5\u671f\u7c7b\u578b\u8f6c\u6362\u9519\u8bef!", (Throwable)e);
                throw new BusinessException("0001", "\u5165\u53c2\u8d77\u59cb\u65e5\u671f\u683c\u5f0f\u9519\u8bef!");
            }
        }
        if (null != reqBO.getEndDate() && !"".equals(reqBO.getEndDate())) {
            try {
                Date endDate = sdf.parse(reqBO.getEndDate());
                record.setEndDate(endDate);
            }
            catch (Exception e) {
                logger.error("\u5165\u53c2\u7ed3\u675f\u65e5\u671f\u7c7b\u578b\u8f6c\u6362\u9519\u8bef!", (Throwable)e);
                throw new BusinessException("0001", "\u5165\u53c2\u7ed3\u675f\u65e5\u671f\u683c\u5f0f\u9519\u8bef!");
            }
        }
        if (null != reqBO.getStartDate() && !"".equals(reqBO.getStartDate()) && null != reqBO.getEndDate() && !"".equals(reqBO.getEndDate()) && record.getStartDate().after(record.getEndDate())) {
            throw new BusinessException("0001", "\u7ed3\u675f\u65e5\u671f\u4e0d\u80fd\u5c0f\u4e8e\u8d77\u59cb\u65e5\u671f!");
        }
        record.setOperUnitNo(reqBO.getCompanyId());
        PayQryCheckingColRspBO payQryCheckingColRspBO = new PayQryCheckingColRspBO();
        LinkedList<PayCheckingColVO> rspBOs = new LinkedList<PayCheckingColVO>();
        Page page = new Page(reqBO.getPageNo(), reqBO.getPageSize());
        List<PayCheckingRst> payCheckingRsts = this.inquiryCheckingMapper.queryListPage(record, (Page<Map<String, Object>>)page);
        if (null != payCheckingRsts && !payCheckingRsts.isEmpty()) {
            for (PayCheckingRst po : payCheckingRsts) {
                PayCheckingColVO vo = new PayCheckingColVO();
                BeanUtils.copyProperties((Object)po, (Object)vo);
                if (vo.getOrderCount().compareTo(vo.getPayCount()) == 0 && vo.getPayCount().compareTo(vo.getOrderPaySameCount()) == 0) {
                    vo.setOrderPayCountRst('Y');
                } else {
                    vo.setOrderPayCountRst('N');
                }
                if (null != vo.getOrderTotalAmt() && null != vo.getPayTotalAmt() && null != vo.getOrderPaySameAmt() && vo.getOrderTotalAmt().compareTo(vo.getPayTotalAmt()) == 0 && vo.getPayTotalAmt().compareTo(vo.getOrderPaySameAmt()) == 0) {
                    vo.setOrderPayTotalAmtRst('Y');
                } else {
                    vo.setOrderPayTotalAmtRst('N');
                }
                CheckingAccRec accRec = this.queryBankRec(reqBO.getCompanyId(), reqBO.getCompanyName(), po.getSettleDate());
                if (null != accRec && null != accRec.getTotalAmt()) {
                    vo.setBankRecAmt(accRec.getTotalAmt());
                    if (null != vo.getBankRecAmt() && null != vo.getPayTotalAmt() && vo.getBankRecAmt().compareTo(vo.getPayTotalAmt()) == 0) {
                        vo.setPayBankAmtResult('Y');
                    } else {
                        vo.setPayBankAmtResult('N');
                    }
                } else {
                    vo.setPayBankAmtResult('N');
                }
                rspBOs.add(vo);
            }
        }
        payQryCheckingColRspBO.setRows(rspBOs);
        payQryCheckingColRspBO.setRecordsTotal(page.getTotalCount());
        payQryCheckingColRspBO.setTotal(page.getTotalPages());
        payQryCheckingColRspBO.setPageNo(page.getPageNo());
        return payQryCheckingColRspBO;
    }

    private CheckingAccRec queryBankRec(Long companyId, String companyName, Date settleDate) {
        Date endD;
        OrgPayConfigPO orgPayConfigPO = this.orgPayConfigMapper.queryConByOrgId(companyId);
        if (orgPayConfigPO == null || orgPayConfigPO.getSubAcctNo() == null) {
            throw new BusinessException("18001", "\u672a\u914d\u7f6e" + companyName + "\u5bf9\u5e94\u7b2c\u4e09\u65b9\u94f6\u884c\u6536\u6b3e\u8d26\u6237\u4fe1\u606f");
        }
        String recSubAcct = orgPayConfigPO.getSubAcctNo();
        CheckingAccRec checkingAccRec = new CheckingAccRec();
        Date startD = DatesUtils.dateBefore(settleDate, 1);
        try {
            endD = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").parse(new SimpleDateFormat("yyyy-MM-dd").format(startD) + " 23:59:59");
        }
        catch (ParseException e) {
            throw new BusinessException("18005", "\u94f6\u884c\u6536\u6b3e\u7ed3\u675f\u65e5\u671f\u8f6c\u6362\u9519\u8bef");
        }
        checkingAccRec.setStartDate(startD);
        checkingAccRec.setEndDate(endD);
        checkingAccRec.setRecSubAcct(recSubAcct);
        checkingAccRec.setTransferAcctName(this.enumsService.queryLikeSupplierPayTransferAcctName());
        return this.advanceReceiveMapper.select4Checking(checkingAccRec);
    }
}

