/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.settle.busi.impl;

import com.ohaotian.plugin.base.exception.BusinessException;
import com.ohaotian.plugin.db.Page;
import com.tydic.fsc.settle.atom.EnumsService;
import com.tydic.fsc.settle.atom.OrganizationInfoService;
import com.tydic.fsc.settle.busi.api.PayQryCheckingService;
import com.tydic.fsc.settle.busi.api.bo.PayQryCheckingReqBO;
import com.tydic.fsc.settle.busi.api.bo.PayQryCheckingRspBO;
import com.tydic.fsc.settle.busi.api.vo.PayCheckingVO;
import com.tydic.fsc.settle.dao.InquiryCheckingMapper;
import com.tydic.fsc.settle.dao.po.PayCheckingRst;
import com.tydic.fsc.settle.dao.vo.PayCheckingRstVO;
import com.tydic.fsc.settle.enums.InquiryPayPass;
import com.tydic.fsc.settle.enums.InquiryPaymentStatus;
import com.tydic.fsc.settle.enums.InquiryTransState;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class PayQryCheckingServiceImpl
implements PayQryCheckingService {
    private static final Logger logger = LoggerFactory.getLogger(PayQryCheckingServiceImpl.class);
    @Autowired
    private InquiryCheckingMapper inquiryCheckingMapper;
    @Autowired
    private OrganizationInfoService organizationInfoService;
    @Autowired
    private EnumsService enumsService;

    public PayQryCheckingRspBO<PayCheckingVO> queryChecking(PayQryCheckingReqBO reqBO) {
        if (logger.isDebugEnabled()) {
            logger.debug("\u67e5\u8be2\u5bf9\u8d26\u4fe1\u606f\u670d\u52a1\u5165\u53c2\uff1a" + reqBO);
        }
        if (null == reqBO) {
            throw new BusinessException("0001", "\u5165\u53c2\u4e0d\u80fd\u4e3a\u7a7a!");
        }
        if (null == reqBO.getCompanyId()) {
            throw new BusinessException("0001", "\u5165\u53c2\u4e13\u4e1a\u516c\u53f8\u7f16\u53f7[companyId]\u4e0d\u80fd\u4e3a\u7a7a!");
        }
        PayCheckingRstVO record = new PayCheckingRstVO();
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        sdf.setLenient(false);
        if (null != reqBO.getStartDate() && !"".equals(reqBO.getStartDate())) {
            try {
                Date startDate = sdf.parse(reqBO.getStartDate());
                record.setStartDate(startDate);
            }
            catch (Exception e) {
                logger.error("\u5165\u53c2\u8d77\u59cb\u65e5\u671f\u7c7b\u578b\u8f6c\u6362\u9519\u8bef!", (Throwable)e);
                throw new BusinessException("0001", "\u5165\u53c2\u8d77\u59cb\u65e5\u671f\u683c\u5f0f\u9519\u8bef!");
            }
        }
        if (null != reqBO.getEndDate() && !"".equals(reqBO.getEndDate())) {
            try {
                Date endDate = sdf.parse(reqBO.getEndDate());
                record.setEndDate(endDate);
            }
            catch (Exception e) {
                logger.error("\u5165\u53c2\u8d77\u59cb\u65e5\u671f\u7c7b\u578b\u8f6c\u6362\u9519\u8bef!", (Throwable)e);
                throw new BusinessException("0001", "\u5165\u53c2\u7ed3\u675f\u65e5\u671f\u683c\u5f0f\u9519\u8bef!");
            }
        }
        if (null != reqBO.getStartDate() && !"".equals(reqBO.getStartDate()) && null != reqBO.getEndDate() && !"".equals(reqBO.getEndDate()) && record.getStartDate().after(record.getEndDate())) {
            throw new BusinessException("0001", "\u7ed3\u675f\u65e5\u671f\u4e0d\u80fd\u5c0f\u4e8e\u8d77\u59cb\u65e5\u671f!");
        }
        record.setOperUnitNo(reqBO.getCompanyId());
        record.setSupplierId(reqBO.getSupplierId());
        record.setInquiryNo(reqBO.getInquiryNo());
        record.setCheckingRst(reqBO.getCheckingRst());
        PayQryCheckingRspBO payQryCheckingRspBO = new PayQryCheckingRspBO();
        LinkedList<PayCheckingVO> rspBOs = new LinkedList<PayCheckingVO>();
        Page page = new Page(reqBO.getPageNo(), reqBO.getPageSize());
        List<PayCheckingRst> payCheckingResultInfos = this.inquiryCheckingMapper.queryListPage(record, (Page<Map<String, Object>>)page);
        for (PayCheckingRst po : payCheckingResultInfos) {
            PayCheckingVO vo = new PayCheckingVO();
            BeanUtils.copyProperties((Object)po, (Object)vo);
            String supplierName = this.organizationInfoService.querySupplierName(po.getSupplierId());
            vo.setSupplierName(supplierName);
            vo.setPayPassDesc(this.enumsService.getDescr(InquiryPayPass.getInstance(po.getPayPass())));
            vo.setPaymentStatusDesc(this.enumsService.getDescr(InquiryPaymentStatus.getInstance(po.getPaymentStatus())));
            vo.setTransStateDesc(this.enumsService.getDescr(InquiryTransState.getInstance(po.getTransState())));
            rspBOs.add(vo);
        }
        payQryCheckingRspBO.setRows(rspBOs);
        payQryCheckingRspBO.setRecordsTotal(page.getTotalCount());
        payQryCheckingRspBO.setTotal(page.getTotalPages());
        payQryCheckingRspBO.setPageNo(page.getPageNo());
        return payQryCheckingRspBO;
    }
}

