/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.settle.busi.impl;

import com.ohaotian.plugin.base.exception.BusinessException;
import com.ohaotian.plugin.db.Page;
import com.tydic.fsc.settle.atom.EnumsService;
import com.tydic.fsc.settle.atom.OrganizationInfoService;
import com.tydic.fsc.settle.busi.api.QueryEntryInfoService;
import com.tydic.fsc.settle.busi.api.bo.BusiEntryInfoRspBO;
import com.tydic.fsc.settle.busi.api.bo.EntryInfoBO;
import com.tydic.fsc.settle.busi.api.bo.PurchaseOrderDetailInfoRspBO;
import com.tydic.fsc.settle.busi.api.bo.QueryEntryInfoReqBO;
import com.tydic.fsc.settle.dao.EntryInfoMapper;
import com.tydic.fsc.settle.dao.PayInvoiceInfoMapper;
import com.tydic.fsc.settle.dao.PayPurchaseOrderInfoMapper;
import com.tydic.fsc.settle.dao.po.EntryInfoPO;
import com.tydic.fsc.settle.dao.po.PayInvoiceInfo;
import com.tydic.fsc.settle.dao.po.PayPurchaseOrderInfo;
import com.tydic.fsc.settle.dao.vo.EntryInfoVO;
import com.tydic.fsc.settle.dao.vo.PayPurchaseOrderInfoVO;
import com.tydic.fsc.settle.enums.BaseEnums;
import com.tydic.fsc.settle.enums.OrderSource;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class QueryEntryInfoServiceImpl
implements QueryEntryInfoService {
    private static final Logger logger = LoggerFactory.getLogger(QueryEntryInfoServiceImpl.class);
    @Autowired
    private EntryInfoMapper entryInfoMapper;
    @Autowired
    private OrganizationInfoService organizationInfoService;
    @Autowired
    private EnumsService enumsService;
    @Autowired
    private PayPurchaseOrderInfoMapper payPurchaseOrderInfoMapper;
    @Autowired
    private PayInvoiceInfoMapper payInvoiceInfoMapper;

    public BusiEntryInfoRspBO<EntryInfoBO> queryListPage(QueryEntryInfoReqBO queryEntryInfoReqBO) {
        if (logger.isDebugEnabled()) {
            logger.debug("\u7535\u5b50\u8d85\u5e02\u5165\u5e93\u5355\u67e5\u8be2\u4e1a\u52a1\u670d\u52a1\u7684\u5b9e\u73b0\u7c7b\u5165\u53c2\uff1a" + queryEntryInfoReqBO.toString());
        }
        if (StringUtils.isEmpty((CharSequence)queryEntryInfoReqBO.getSource())) {
            throw new BusinessException("18000", "\u6765\u6e90\u4e0d\u80fd\u4e3a\u7a7a");
        }
        String orderBy = "t.ENTRY_DATE DESC,t.ENTRY_NO DESC";
        BusiEntryInfoRspBO rspPageBO = new BusiEntryInfoRspBO();
        EntryInfoVO entryInfoVO = new EntryInfoVO();
        BeanUtils.copyProperties((Object)queryEntryInfoReqBO, (Object)entryInfoVO);
        entryInfoVO.setOprCompanyId(queryEntryInfoReqBO.getCompanyId());
        Page page = new Page(queryEntryInfoReqBO.getPageNo(), queryEntryInfoReqBO.getPageSize());
        String notificationNo = entryInfoVO.getNotificationNo();
        if (StringUtils.isNotBlank((CharSequence)notificationNo)) {
            String[] notificationNoArray = notificationNo.split(",");
            List<String> notificationNoList = Arrays.asList(notificationNoArray);
            entryInfoVO.setNotificationNoList(notificationNoList);
        }
        List<EntryInfoPO> entryInfoPOs = this.entryInfoMapper.getListPage(entryInfoVO, (Page<Map<String, Object>>)page, orderBy);
        ArrayList<EntryInfoBO> entryInfoBOs = new ArrayList<EntryInfoBO>();
        for (EntryInfoPO entryInfo : entryInfoPOs) {
            EntryInfoBO entryInfoBO = new EntryInfoBO();
            BeanUtils.copyProperties((Object)entryInfo, (Object)entryInfoBO);
            entryInfoBO.setCompanyId(entryInfo.getOprCompanyId());
            entryInfoBO.setSourceDescr(this.enumsService.getDescr((BaseEnums)OrderSource.getInstance((String)entryInfo.getSource())));
            String purchaseName = this.organizationInfoService.querySupplierName(entryInfoBO.getPurchaseId());
            if ("01".equals(entryInfo.getStatus())) {
                entryInfoBO.setStatusDesc("\u672a\u6c47\u603b");
            } else {
                entryInfoBO.setStatusDesc("\u5df2\u6c47\u603b");
            }
            entryInfoBO.setPurchaseName(purchaseName);
            LinkedList<PurchaseOrderDetailInfoRspBO> purchaseOrderDetailList = new LinkedList<PurchaseOrderDetailInfoRspBO>();
            LinkedList<String> purchaseOrderNameList = new LinkedList<String>();
            LinkedList<String> purchaseProjectNameList = new LinkedList<String>();
            LinkedList<String> invoiceNoList = new LinkedList<String>();
            if (!"0".equals(this.enumsService.queryShowOrderCodeSwitch()) || !OrderSource.ELECTRIC_MARKET.getCode().equals(entryInfo.getSource())) {
                Object payInvoiceInfo;
                if (OrderSource.ELECTRIC_MARKET.getCode().equals(entryInfo.getSource())) {
                    List<PayPurchaseOrderInfo> orders = this.payPurchaseOrderInfoMapper.selectByNotifNo(entryInfo.getNotificationNo());
                    for (PayPurchaseOrderInfo singleOrder : orders) {
                        PurchaseOrderDetailInfoRspBO purchaseOrderInfo = new PurchaseOrderDetailInfoRspBO();
                        purchaseOrderInfo.setPurchaseOrderCode(singleOrder.getPurchaseOrderCode());
                        purchaseOrderInfo.setInspectionId(singleOrder.getInspectionId());
                        purchaseOrderDetailList.add(purchaseOrderInfo);
                        purchaseOrderNameList.add(singleOrder.getPurchaseOrderName());
                        purchaseProjectNameList.add(this.organizationInfoService.queryProjectName(singleOrder.getPurchaseProjectId()).getAccountName());
                    }
                    List<PayInvoiceInfo> invoices = this.payInvoiceInfoMapper.selectByNotifyNo(entryInfo.getNotificationNo());
                    if (!CollectionUtils.isEmpty(invoices) && !StringUtils.isEmpty((CharSequence)((PayInvoiceInfo)(payInvoiceInfo = invoices.get(0))).getInvoiceNo())) {
                        String[] invoiceNoVal = ((PayInvoiceInfo)payInvoiceInfo).getInvoiceNo().split(",");
                        StringBuilder sb = new StringBuilder();
                        for (String invoiceNo : invoiceNoVal) {
                            if (!StringUtils.isEmpty((CharSequence)sb.toString()) && sb.toString().split(",").length >= 5) {
                                invoiceNoList.add(sb.toString().substring(0, sb.length() - 1));
                                sb.delete(0, sb.length());
                                sb.append(invoiceNo).append(",");
                                continue;
                            }
                            sb.append(invoiceNo).append(",");
                        }
                        if (sb.length() >= 1) {
                            invoiceNoList.add(sb.toString().substring(0, sb.length() - 1));
                        }
                    }
                } else {
                    PayPurchaseOrderInfoVO purchaseOrderInfoVO = new PayPurchaseOrderInfoVO();
                    purchaseOrderInfoVO.setNotificationNo(entryInfo.getNotificationNo());
                    List<PayPurchaseOrderInfo> purchaseOrderInfos = this.payPurchaseOrderInfoMapper.getListByItemNotifNo(purchaseOrderInfoVO);
                    PurchaseOrderDetailInfoRspBO detailRspBO = null;
                    payInvoiceInfo = purchaseOrderInfos.iterator();
                    while (payInvoiceInfo.hasNext()) {
                        PayPurchaseOrderInfo purchaseOrder = payInvoiceInfo.next();
                        detailRspBO = new PurchaseOrderDetailInfoRspBO();
                        detailRspBO.setPurchaseOrderCode(purchaseOrder.getPurchaseOrderCode());
                        detailRspBO.setInspectionId(purchaseOrder.getInspectionId());
                        purchaseOrderDetailList.add(detailRspBO);
                        purchaseOrderNameList.add(purchaseOrder.getPurchaseOrderName());
                        purchaseProjectNameList.add(this.organizationInfoService.queryProjectName(purchaseOrder.getPurchaseProjectId()).getAccountName());
                    }
                    List<PayInvoiceInfo> invoices = this.payInvoiceInfoMapper.selectByNotifyNo(entryInfo.getNotificationNo());
                    StringBuilder sb = new StringBuilder();
                    for (PayInvoiceInfo payInvoiceInfo2 : invoices) {
                        if (!StringUtils.isEmpty((CharSequence)sb.toString()) && sb.toString().split(",").length >= 5) {
                            invoiceNoList.add(sb.toString().substring(0, sb.length() - 1));
                            sb.delete(0, sb.length());
                            sb.append(payInvoiceInfo2.getInvoiceNo()).append(",");
                            continue;
                        }
                        sb.append(payInvoiceInfo2.getInvoiceNo()).append(",");
                    }
                    if (sb.length() >= 1) {
                        invoiceNoList.add(sb.toString().substring(0, sb.length() - 1));
                    }
                }
            }
            entryInfoBO.setPurchaseOrderCodeList(purchaseOrderDetailList);
            entryInfoBO.setPurchaseOrderNameList(purchaseOrderNameList);
            entryInfoBO.setPurchaseProjectNameList(purchaseProjectNameList);
            entryInfoBO.setInvoiceNoList(invoiceNoList);
            entryInfoBO.setBranchCompanyName(this.organizationInfoService.queryOrgName(entryInfo.getBranchCompany()));
            entryInfoBOs.add(entryInfoBO);
        }
        rspPageBO.setRows(entryInfoBOs);
        rspPageBO.setRecordsTotal(page.getTotalCount());
        rspPageBO.setTotal(page.getTotalPages());
        rspPageBO.setPageNo(page.getPageNo());
        return rspPageBO;
    }
}

