/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.settle.busi.impl;

import com.ohaotian.plugin.base.exception.BusinessException;
import com.ohaotian.plugin.db.Page;
import com.tydic.fsc.settle.atom.EnumsService;
import com.tydic.fsc.settle.atom.OrderService;
import com.tydic.fsc.settle.atom.OrganizationInfoService;
import com.tydic.fsc.settle.atom.bo.ReceiveDetailBO;
import com.tydic.fsc.settle.atom.bo.SaleOrderBO;
import com.tydic.fsc.settle.bo.FscPageRspBo;
import com.tydic.fsc.settle.busi.api.QueryPayableDetailService;
import com.tydic.fsc.settle.busi.api.bo.PayableDetailBO;
import com.tydic.fsc.settle.busi.api.bo.QueryPayableDetailReqBO;
import com.tydic.fsc.settle.dao.PayableDetailMapper;
import com.tydic.fsc.settle.dao.po.PayableDetailPO;
import com.tydic.fsc.settle.dao.vo.SaleOrderInfoVO;
import com.tydic.fsc.settle.enums.BaseEnums;
import com.tydic.fsc.settle.enums.OrderSource;
import com.tydic.fsc.settle.enums.PayablePayType;
import com.tydic.fsc.settle.enums.PayableStatus;
import com.tydic.fsc.settle.utils.AntiSqlInjectionManage;
import com.tydic.fsc.settle.utils.BusinessUtils;
import com.tydic.fsc.settle.utils.FscStringUtils;
import java.math.BigDecimal;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class QueryPayableDetailServiceImpl
implements QueryPayableDetailService {
    private static final Logger logger = LoggerFactory.getLogger(QueryPayableDetailServiceImpl.class);
    @Autowired
    private PayableDetailMapper payableDetailMapper;
    @Autowired
    private EnumsService enumsService;
    @Autowired
    private OrganizationInfoService organizationInfoService;
    @Autowired
    private OrderService orderService;

    public FscPageRspBo<PayableDetailBO> queryListPage(QueryPayableDetailReqBO reqBO) {
        if (logger.isDebugEnabled()) {
            logger.debug("\u67e5\u8be2\u9884\u4ed8\u5e94\u4ed8\u670d\u52a1\u5165\u53c2\uff1a" + reqBO.toString());
        }
        if (StringUtils.isEmpty((CharSequence)reqBO.getSource()) || reqBO.getSource() == null) {
            throw new BusinessException("18000", "\u5e94\u4ed8\u5217\u8868\u67e5\u8be2\u4e1a\u52a1\u670d\u52a1-\u6765\u6e90[source]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        Long operUnitNo = BusinessUtils.judgeOperUnitNo(reqBO.getOperUnitNo(), reqBO.getCompanyId(), false);
        reqBO.setCompanyId(operUnitNo);
        FscPageRspBo rspPageBO = new FscPageRspBo();
        String orderBy = null;
        if (!StringUtils.isEmpty((CharSequence)reqBO.getSortName()) && !StringUtils.isEmpty((CharSequence)reqBO.getSortOrder())) {
            if (AntiSqlInjectionManage.sqlValidate(reqBO.getSortName()) || AntiSqlInjectionManage.sqlValidate(reqBO.getSortOrder())) {
                logger.error("\u60a8\u53d1\u9001\u8bf7\u6c42\u4e2d\u7684\u53c2\u6570\u4e2d\u542b\u6709\u975e\u6cd5\u5b57\u7b26");
                throw new BusinessException("18000", "\u60a8\u53d1\u9001\u8bf7\u6c42\u4e2d\u7684\u53c2\u6570\u4e2d\u542b\u6709\u975e\u6cd5\u5b57\u7b26");
            }
            orderBy = reqBO.getSortName() + " " + reqBO.getSortOrder();
        } else {
            orderBy = " PAYABLE_NO desc";
        }
        Page page = new Page(reqBO.getPageNo(), reqBO.getPageSize());
        List<PayableDetailPO> payableDetailPOs = this.payableDetailMapper.getListPageByTerms(reqBO, (Page<Map<String, Object>>)page, orderBy);
        LinkedList<PayableDetailBO> payableDetailBOs = new LinkedList<PayableDetailBO>();
        HashSet<Long> purchaseOrderIdsSet = null;
        if (!CollectionUtils.isEmpty(payableDetailPOs)) {
            purchaseOrderIdsSet = new HashSet<Long>();
            for (PayableDetailPO payableDetailPO : payableDetailPOs) {
                String payType = payableDetailPO.getPayType();
                PayableDetailBO singleDetail = new PayableDetailBO();
                BeanUtils.copyProperties((Object)payableDetailPO, (Object)singleDetail);
                singleDetail.setOrderId(FscStringUtils.valueOf(payableDetailPO.getOrderId()));
                if (payableDetailPO.getOrderId() != null) {
                    purchaseOrderIdsSet.add(payableDetailPO.getOrderId());
                }
                PayableStatus payableEnum = PayableStatus.getInstance(singleDetail.getPayableStatus());
                singleDetail.setPayableStatusStr(this.enumsService.getDescr(payableEnum));
                OrderSource orderSourceEnum = OrderSource.getInstance((String)singleDetail.getSource());
                singleDetail.setSourceStr(this.enumsService.getDescr((BaseEnums)orderSourceEnum));
                String supplierStr = this.organizationInfoService.querySupplierName(singleDetail.getSupplierId());
                singleDetail.setSupplierStr(supplierStr);
                String orgNameStr = this.organizationInfoService.queryOrgName(singleDetail.getOperatorId());
                singleDetail.setOperatorStr(orgNameStr);
                PayablePayType payTypeEnum = PayablePayType.getInstance(singleDetail.getPayType());
                singleDetail.setPayTypeStr(this.enumsService.getDescr(payTypeEnum));
                singleDetail.setProfessionalDepartDescr(this.organizationInfoService.queryOrgName(singleDetail.getProfessionalDepartId()));
                singleDetail.setServiceDepartDescr(this.organizationInfoService.queryServiceDepartName(singleDetail.getServiceDepartId()));
                singleDetail.setBranchCompanyName(this.organizationInfoService.queryOrgName(payableDetailPO.getBranchCompany()));
                BigDecimal totAmt = singleDetail.getPayableAmt();
                BigDecimal paidAmt = singleDetail.getPaidAmt().add(singleDetail.getPendingAmt());
                if (totAmt.compareTo(paidAmt) <= 0) {
                    singleDetail.setAllInPaying("Y");
                } else {
                    singleDetail.setAllInPaying("N");
                }
                SaleOrderBO saleOrderBO = this.orderService.obtainSaleOrder(payableDetailPO.getOrderId());
                SaleOrderInfoVO saleOrderInfoVO = new SaleOrderInfoVO();
                saleOrderInfoVO.setSource(payableDetailPO.getSource());
                saleOrderInfoVO.setOrderId(saleOrderBO.getSaleOrderId());
                saleOrderInfoVO.setSaleOrderCode(saleOrderBO.getSaleOrderCode());
                Map<String, ReceiveDetailBO> receiveDetail = this.orderService.obtainReceiveDetail(saleOrderInfoVO);
                payableDetailBOs.add(singleDetail);
            }
        }
        rspPageBO.setRows(payableDetailBOs);
        rspPageBO.setRecordsTotal(page.getTotalCount());
        rspPageBO.setTotal(page.getTotalPages());
        rspPageBO.setPageNo(page.getPageNo());
        return rspPageBO;
    }
}

