/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.settle.utils;

import com.tydic.fsc.settle.enums.BaseEnums;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class EnumUtils {
    private static final Log logger = LogFactory.getLog(EnumUtils.class);

    private EnumUtils() {
    }

    public static <T> List<Map<String, String>> toList(Class<T> type) {
        ArrayList<Map<String, String>> list = new ArrayList<Map<String, String>>();
        for (T constant : type.getEnumConstants()) {
            BaseEnums be;
            if (!(constant instanceof BaseEnums) || null == (be = (BaseEnums)constant).getCodeAsString()) continue;
            HashMap<String, String> map = new HashMap<String, String>(2);
            list.add(map);
            map.put("code", be.getCodeAsString());
            map.put("descr", be.getDescr());
        }
        return list;
    }

    public static <T> List<Map<String, String>> toList(String enumName) {
        ArrayList<Map<String, String>> list = new ArrayList<Map<String, String>>();
        Class<?> cls = null;
        try {
            BaseEnums[] inter;
            cls = Class.forName("com.tydic.fsc.settle.enums." + enumName);
            if (cls == null) {
                return list;
            }
            Method method = cls.getMethod("values", new Class[0]);
            for (BaseEnums be : inter = (BaseEnums[])method.invoke(null, new Object[]{null})) {
                if (null == be.getCodeAsString()) continue;
                HashMap<String, String> map = new HashMap<String, String>(2);
                list.add(map);
                map.put("code", be.getCodeAsString());
                map.put("descr", be.getDescr());
            }
        }
        catch (Exception e) {
            logger.error((Object)"\u679a\u4e3e\u5b57\u5178\u503c\u7ffb\u8bd1\u51fa\u73b0\u5f02\u5e38", (Throwable)e);
        }
        return list;
    }
}

