/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.settle.aop;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.tydic.fsc.settle.bo.FscBaseRspBo;
import java.io.IOException;
import java.io.LineNumberReader;
import java.io.PrintWriter;
import java.io.StringReader;
import java.io.StringWriter;
import java.lang.reflect.Field;
import org.apache.commons.lang3.StringUtils;
import org.aspectj.lang.ProceedingJoinPoint;

class FscAopUtils {
    private static final ObjectMapper MAPPER = new ObjectMapper();
    private static final String SEPARATOR = "|";
    private static final String EXCLUDE_METHODS = "subscribe";
    private static final String CLASS_METHOD_SEPARATOR = ".";
    private static final String START_IDENTIFICATION = "START";
    private static final String END_IDENTIFICATION = "END";
    private static final String ERROR_IDENTIFICATION = "ERROR";

    FscAopUtils() {
    }

    private static String getThrowableStrRep(Throwable throwable) {
        if (throwable == null) {
            return null;
        }
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        throwable.printStackTrace(pw);
        pw.flush();
        StringBuilder sb = new StringBuilder();
        try (LineNumberReader reader = new LineNumberReader(new StringReader(sw.toString()));){
            String line = reader.readLine();
            while (line != null) {
                sb.append(line).append("\r\n");
                line = reader.readLine();
            }
        }
        catch (IOException ex) {
            sb.append(ex.toString());
        }
        return sb.toString();
    }

    static String getLogInfoByStrings(String[] infos) {
        StringBuilder stb = new StringBuilder();
        for (String info : infos) {
            if (StringUtils.isBlank((CharSequence)info)) {
                info = "";
            }
            stb.append(info).append(SEPARATOR);
        }
        if (stb.length() > 1) {
            stb.setLength(stb.length() - 1);
        }
        return stb.toString();
    }

    static void putCodeToRsp(Object object, String code, String desc, boolean fource) throws NoSuchFieldException, SecurityException, IllegalArgumentException, IllegalAccessException {
        if (object instanceof FscBaseRspBo) {
            Field field = FscBaseRspBo.class.getDeclaredField("respCode");
            field.setAccessible(true);
            if (!fource && field.get(object) == null) {
                field.set(object, code);
                field = FscBaseRspBo.class.getDeclaredField("respDesc");
                field.setAccessible(true);
                field.set(object, desc);
            } else if (fource && field.get(object) == null) {
                field.set(object, code);
                field = FscBaseRspBo.class.getDeclaredField("respDesc");
                field.setAccessible(true);
                field.set(object, desc);
            }
        }
    }

    static String[] buildAopStartLog(ProceedingJoinPoint pjp, String traceId) {
        long nowTime = System.currentTimeMillis();
        StringBuilder commonHead = new StringBuilder(traceId + SEPARATOR);
        String className = pjp.getTarget().getClass().getName();
        String methodString = pjp.getSignature().getName();
        if (EXCLUDE_METHODS.equals(methodString)) {
            return null;
        }
        commonHead.append(className);
        commonHead.append(CLASS_METHOD_SEPARATOR);
        commonHead.append(methodString);
        String[] infos = new String[8];
        infos[0] = commonHead.toString();
        infos[1] = START_IDENTIFICATION;
        infos[2] = Long.toString(nowTime);
        infos[3] = "";
        Object[] params = pjp.getArgs();
        if (params != null && params.length > 0) {
            if (params.length == 1) {
                try {
                    infos[4] = MAPPER.writeValueAsString(params[0]);
                }
                catch (JsonProcessingException e) {
                    infos[4] = ("\u8bf7\u6c42\u62a5\u6587\u8f6cjson\u51fa\u9519\uff0c\u6539\u7528toString\u65b9\u6cd5" + params[0]).replace("\r\n", "");
                }
            } else {
                StringBuilder paramsStr = new StringBuilder();
                paramsStr.append("[");
                for (Object obj : params) {
                    String objStr = null;
                    if (obj != null) {
                        try {
                            objStr = MAPPER.writeValueAsString(obj);
                        }
                        catch (JsonProcessingException e) {
                            objStr = null;
                        }
                    }
                    paramsStr.append(objStr);
                    paramsStr.append(",");
                }
                paramsStr.setLength(paramsStr.length() - 1);
                paramsStr.append("]");
            }
        }
        return infos;
    }

    static void buildAopEndLog(String[] infos, Object object) {
        long nowTime = System.currentTimeMillis();
        infos[1] = END_IDENTIFICATION;
        infos[3] = Long.toString(nowTime);
        if (object instanceof FscBaseRspBo) {
            FscBaseRspBo resp = (FscBaseRspBo)object;
            infos[4] = resp.getRespCode();
            infos[5] = resp.getRespDesc();
            infos[6] = "\u7528\u65f6\uff1a" + (Long.parseLong(infos[3]) - Long.parseLong(infos[2])) + "ms";
            infos[7] = object.toString();
        }
    }

    static void buildAopErrorLog(String[] infos, Throwable e) {
        long nowTime = System.currentTimeMillis();
        infos[1] = ERROR_IDENTIFICATION;
        infos[3] = Long.toString(nowTime);
        if (null != FscAopUtils.getThrowableStrRep(e)) {
            infos[5] = FscAopUtils.getThrowableStrRep(e);
        }
    }
}

