/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.settle.atom;

import com.ohaotian.plugin.base.exception.BusinessException;
import com.tydic.fsc.settle.atom.OrganizationInfoService;
import com.tydic.fsc.settle.busi.api.WorkFlowFinishTransferContractService;
import com.tydic.fsc.settle.busi.api.bo.WorkFlowFinishTransferContractReqBO;
import com.tydic.fsc.settle.busi.api.bo.WorkFlowFinishTransferContractRspBO;
import com.tydic.fsc.settle.dao.SupplierInfoMapper;
import com.tydic.fsc.settle.dao.po.FinanceConfig;
import com.tydic.fsc.settle.dao.po.PurchaseUnitInfo;
import com.tydic.fsc.settle.dao.po.SupplierInfo;
import com.tydic.fsc.settle.dao.vo.PayPurchaseOrderInfoVO;
import com.tydic.fsc.settle.dao.vo.SaleOrderInfoVO;
import com.tydic.fsc.settle.enums.OrderSource;
import com.tydic.fsc.settle.utils.SpringApplicationContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

@Service
public class ContractService {
    private static final Logger logger = LoggerFactory.getLogger(ContractService.class);
    @Autowired
    private OrganizationInfoService organizationInfoService;
    @Autowired
    private SupplierInfoMapper supplierInfoMapper;

    public String obtainCghtbh(FinanceConfig financeConfig, PayPurchaseOrderInfoVO purchaseOrderVO) {
        String cghtbh = "";
        String source = purchaseOrderVO.getSource();
        if (OrderSource.ELECTRIC_MARKET.getCode().equals(source)) {
            SupplierInfo supplierInfo = this.supplierInfoMapper.selectByPrimaryKey(purchaseOrderVO.getSupplierNo());
            if (null == supplierInfo) {
                throw new BusinessException("18001", "t_supplier_info\u8868\u4e2d\u672a\u914d\u7f6e\u91c7\u8d2d\u5408\u540c");
            }
            cghtbh = supplierInfo.getEffectContactNo();
        } else if (OrderSource.ELECTRIC_AREA.getCode().equals(source)) {
            Long purchaseProjectId = purchaseOrderVO.getPurchaseProjectId();
            PurchaseUnitInfo purchaseUnitInfo = this.organizationInfoService.queryParentAccount(purchaseProjectId);
            if (purchaseUnitInfo == null) {
                String projectName = this.organizationInfoService.queryProjectName(purchaseProjectId).getAccountName();
                throw new BusinessException("18004", "\u6839\u636e\u8d26\u5957[\u8d26\u5957ID=" + purchaseProjectId + "\uff0c\u8d26\u5957\u540d\u79f0=" + projectName + "]\u67e5\u4e0d\u5230\u5408\u540c\u6216\u5176\u7236\u8d26\u5957\u7684\u5408\u540c\uff0c\u8bf7\u914d\u7f6e");
            }
            cghtbh = purchaseUnitInfo.getPurchaseProjectName();
        } else if (OrderSource.CONSULT_PRICE.getCode().equals(source) || OrderSource.CONSULT_PRICE_FRAME.getCode().equals(source)) {
            WorkFlowFinishTransferContractService transferContractService = SpringApplicationContext.getBean(WorkFlowFinishTransferContractService.class);
            WorkFlowFinishTransferContractReqBO reqBO = new WorkFlowFinishTransferContractReqBO();
            reqBO.setSource(source);
            reqBO.setPurchaseOrderId(purchaseOrderVO.getOrderId());
            WorkFlowFinishTransferContractRspBO rspBO = transferContractService.process(reqBO);
            if (rspBO != null) {
                cghtbh = rspBO.getPurchaseContractCode();
            }
            cghtbh = StringUtils.hasText((String)cghtbh) ? cghtbh : purchaseOrderVO.getPurchaseOrderCode();
        } else if (OrderSource.COAL_AREA.getCode().equals(source)) {
            Long purchaseProjectId = purchaseOrderVO.getPurchaseProjectId();
            PurchaseUnitInfo purchaseUnitInfo = this.organizationInfoService.queryParentAccount(purchaseProjectId);
            if (purchaseUnitInfo == null) {
                String projectName = this.organizationInfoService.queryProjectName(purchaseProjectId).getAccountName();
                throw new BusinessException("18004", "\u6839\u636e\u8d26\u5957[\u8d26\u5957ID=" + purchaseProjectId + "\uff0c\u8d26\u5957\u540d\u79f0=" + projectName + "]\u67e5\u4e0d\u5230\u5408\u540c\u6216\u5176\u7236\u8d26\u5957\u7684\u5408\u540c\uff0c\u8bf7\u914d\u7f6e");
            }
            cghtbh = "\u7164\u70ad\u4e13\u533a|" + financeConfig.getUnitName() + "|" + purchaseUnitInfo.getPurchaseProjectName();
        }
        return cghtbh;
    }

    public String obtainXshtbh(FinanceConfig financeConfig, SaleOrderInfoVO saleOrderVO) {
        String xshtbh = "";
        String source = saleOrderVO.getSource();
        if (OrderSource.ELECTRIC_MARKET.getCode().equals(source)) {
            Long purchaseProjectId = saleOrderVO.getPurchaseProjectId();
            PurchaseUnitInfo purchaseUnitInfo = this.organizationInfoService.queryParentAccount(purchaseProjectId);
            if (purchaseUnitInfo == null) {
                String projectName = this.organizationInfoService.queryProjectName(purchaseProjectId).getAccountName();
                throw new BusinessException("18004", "\u6839\u636e\u8d26\u5957[\u8d26\u5957ID=" + purchaseProjectId + "\uff0c\u8d26\u5957\u540d\u79f0=" + projectName + "]\u67e5\u4e0d\u5230\u5408\u540c\u6216\u5176\u7236\u8d26\u5957\u7684\u5408\u540c\uff0c\u8bf7\u914d\u7f6e");
            }
            xshtbh = purchaseUnitInfo.getSaleContactNo();
        } else if (OrderSource.ELECTRIC_AREA.getCode().equals(source)) {
            Long purchaseProjectId = saleOrderVO.getPurchaseProjectId();
            PurchaseUnitInfo purchaseUnitInfo = this.organizationInfoService.queryParentAccount(purchaseProjectId);
            if (purchaseUnitInfo == null) {
                String projectName = this.organizationInfoService.queryProjectName(purchaseProjectId).getAccountName();
                throw new BusinessException("18004", "\u6839\u636e\u8d26\u5957[\u8d26\u5957ID=" + purchaseProjectId + "\uff0c\u8d26\u5957\u540d\u79f0=" + projectName + "]\u67e5\u4e0d\u5230\u5408\u540c\u6216\u5176\u7236\u8d26\u5957\u7684\u5408\u540c\uff0c\u8bf7\u914d\u7f6e");
            }
            xshtbh = purchaseUnitInfo.getPurchaseProjectName();
        } else if (OrderSource.CONSULT_PRICE.getCode().equals(source) || OrderSource.CONSULT_PRICE_FRAME.getCode().equals(source)) {
            WorkFlowFinishTransferContractService transferContractService = SpringApplicationContext.getBean(WorkFlowFinishTransferContractService.class);
            WorkFlowFinishTransferContractReqBO reqBO = new WorkFlowFinishTransferContractReqBO();
            reqBO.setSource(source);
            reqBO.setSaleOrderId(saleOrderVO.getOrderId());
            WorkFlowFinishTransferContractRspBO rspBO = transferContractService.process(reqBO);
            if (rspBO != null) {
                xshtbh = rspBO.getSaleContractCode();
            }
            xshtbh = StringUtils.hasText((String)xshtbh) ? xshtbh : saleOrderVO.getSaleOrderCode();
        } else if (OrderSource.COAL_AREA.getCode().equals(source)) {
            Long purchaseProjectId = saleOrderVO.getPurchaseProjectId();
            PurchaseUnitInfo purchaseUnitInfo = this.organizationInfoService.queryParentAccount(purchaseProjectId);
            if (purchaseUnitInfo == null) {
                String projectName = this.organizationInfoService.queryProjectName(purchaseProjectId).getAccountName();
                throw new BusinessException("18004", "\u6839\u636e\u8d26\u5957[\u8d26\u5957ID=" + purchaseProjectId + "\uff0c\u8d26\u5957\u540d\u79f0=" + projectName + "]\u67e5\u4e0d\u5230\u5408\u540c\u6216\u5176\u7236\u8d26\u5957\u7684\u5408\u540c\uff0c\u8bf7\u914d\u7f6e");
            }
            xshtbh = "\u7164\u70ad\u4e13\u533a|" + financeConfig.getUnitName() + "|" + purchaseUnitInfo.getPurchaseProjectName();
        }
        return xshtbh;
    }
}

