/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.settle.atom.impl;

import com.ohaotian.plugin.base.exception.BusinessException;
import com.tydic.fsc.settle.atom.BillSNService;
import com.tydic.fsc.settle.atom.CreateEntryInfoService;
import com.tydic.fsc.settle.bo.FscBaseReqBo;
import com.tydic.fsc.settle.dao.BillNotificationInfoMapper;
import com.tydic.fsc.settle.dao.EntryInfoMapper;
import com.tydic.fsc.settle.dao.PayInvoiceInfoMapper;
import com.tydic.fsc.settle.dao.PayItemInfoMapper;
import com.tydic.fsc.settle.dao.ReceiptInfoMapper;
import com.tydic.fsc.settle.dao.StocksDetailMapper;
import com.tydic.fsc.settle.dao.po.BillNotificationInfo;
import com.tydic.fsc.settle.dao.po.EntryInfoPO;
import com.tydic.fsc.settle.dao.po.PayItemInfo;
import com.tydic.fsc.settle.dao.po.ReceiptInfoPO;
import com.tydic.fsc.settle.dao.po.StocksDetail;
import com.tydic.fsc.settle.dao.vo.Statis;
import com.tydic.fsc.settle.enums.BillType;
import java.math.BigDecimal;
import java.util.Date;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

@Service
public class CreateEntryInfoServiceImpl
implements CreateEntryInfoService {
    private static final Logger logger = LoggerFactory.getLogger(CreateEntryInfoServiceImpl.class);
    @Autowired
    private PayItemInfoMapper payItemInfoMapper;
    @Autowired
    private EntryInfoMapper entryInfoMapper;
    @Autowired
    private ReceiptInfoMapper receiptInfoMapper;
    @Autowired
    private BillNotificationInfoMapper billNotificationInfoMapper;
    @Autowired
    private PayInvoiceInfoMapper payInvoiceInfoMapper;
    @Autowired
    private BillSNService billSNService;
    @Autowired
    private StocksDetailMapper stocksDetailMapper;

    @Override
    public String createEntryInfo(FscBaseReqBo reqInfoBO, String notificationNo, int entryType, BigDecimal writeoffAmt) {
        if (logger.isDebugEnabled()) {
            logger.debug("\u751f\u6210\u5165\u5e93\u5355\u539f\u5b50\u670d\u52a1\u6267\u884c");
        }
        if (notificationNo == null && !StringUtils.hasText((String)notificationNo)) {
            throw new BusinessException("0001", "\u5f00\u7968\u901a\u77e5\u7f16\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (entryType != 1 && entryType != 2) {
            throw new BusinessException("0001", "\u5165\u5e93\u7c7b\u578b\u503c\u4e0d\u6b63\u786e");
        }
        if (null == writeoffAmt || writeoffAmt.compareTo(BigDecimal.ZERO) < 0) {
            throw new BusinessException("0001", "\u6838\u9500\u91d1\u989d\u4e0d\u80fd\u4e3a\u7a7a\u6216\u5c0f\u4e8e0");
        }
        List<PayItemInfo> itemList = this.payItemInfoMapper.selectByNotifNo(notificationNo);
        if (null == itemList || itemList.isEmpty()) {
            logger.error("\u627e\u4e0d\u5230\u5f00\u7968\u901a\u77e5\u7f16\u53f7\u5bf9\u5e94\u7684\u5546\u54c1\u4fe1\u606f\u8bb0\u5f55\uff0c\u5f00\u7968\u901a\u77e5\u7f16\u53f7\u4e3a\uff1a" + notificationNo);
            return null;
        }
        BillNotificationInfo billNotificationInfo = this.billNotificationInfoMapper.selectByPrimaryKey(notificationNo);
        if (billNotificationInfo == null) {
            logger.error("\u627e\u4e0d\u5230\u5f00\u7968\u901a\u77e5\u7f16\u53f7\u5bf9\u5e94\u7684\u5f00\u7968\u4fe1\u606f\u8bb0\u5f55\uff0c\u5f00\u7968\u901a\u77e5\u7f16\u53f7\u4e3a\uff1a" + notificationNo);
            return null;
        }
        Statis statis = this.payInvoiceInfoMapper.invoiceStatis(notificationNo);
        Date entryDate = new Date();
        String entryNo = this.billSNService.getSnAsString(BillType.PURCHASE_STORAGE);
        for (PayItemInfo payItemInfo : itemList) {
            ReceiptInfoPO receiptInfoPO = new ReceiptInfoPO();
            BeanUtils.copyProperties((Object)payItemInfo, (Object)receiptInfoPO);
            receiptInfoPO.setOrderNo(payItemInfo.getOrderId());
            receiptInfoPO.setNotTaxAmt(payItemInfo.getUntaxAmt());
            receiptInfoPO.setTaxPercent(payItemInfo.getTaxRate());
            receiptInfoPO.setEntryDate(entryDate);
            receiptInfoPO.setEntryNo(entryNo);
            this.receiptInfoMapper.insert(receiptInfoPO);
            StocksDetail stocksDetail = new StocksDetail();
            BeanUtils.copyProperties((Object)payItemInfo, (Object)stocksDetail);
            stocksDetail.setEntryNo(entryNo);
            stocksDetail.setRemainQuality(payItemInfo.getQuantity());
            stocksDetail.setEntryDate(entryDate);
            this.stocksDetailMapper.insert(stocksDetail);
        }
        EntryInfoPO entryInfoPO = new EntryInfoPO();
        entryInfoPO.setEntryDate(entryDate);
        entryInfoPO.setEntryNo(entryNo);
        entryInfoPO.setEntryType(entryType);
        entryInfoPO.setNotificationNo(notificationNo);
        entryInfoPO.setPurchaseId(billNotificationInfo.getSupplierNo());
        entryInfoPO.setNotTaxAmt(statis.getTotUntaxAmt());
        entryInfoPO.setTax(statis.getTotTaxAmt());
        entryInfoPO.setAmt(statis.getTotAmt());
        entryInfoPO.setStatus("01");
        entryInfoPO.setSource(billNotificationInfo.getSource());
        entryInfoPO.setOprCompanyId(billNotificationInfo.getOperNo());
        entryInfoPO.setWriteoffAmt(writeoffAmt);
        entryInfoPO.setCreateUser(reqInfoBO.getUserId());
        entryInfoPO.setBranchCompany(billNotificationInfo.getBranchCompany());
        this.entryInfoMapper.insert(entryInfoPO);
        return entryNo;
    }
}

