/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.settle.atom.impl;

import com.ohaotian.plugin.base.exception.BusinessException;
import com.tydic.fsc.settle.atom.EnumsService;
import com.tydic.fsc.settle.atom.InvokePaycenterService;
import com.tydic.fsc.settle.atom.OrganizationInfoService;
import com.tydic.fsc.settle.atom.QueryDictKeyValueService;
import com.tydic.fsc.settle.atom.SourceMappingService;
import com.tydic.fsc.settle.atom.UserInfoService;
import com.tydic.fsc.settle.atom.WorkFlowFinishEvent;
import com.tydic.fsc.settle.dao.EntryInfoMapper;
import com.tydic.fsc.settle.dao.EntryTotalInfoMapper;
import com.tydic.fsc.settle.dao.FinanceConfigMapper;
import com.tydic.fsc.settle.dao.PayPurchaseOrderInfoMapper;
import com.tydic.fsc.settle.dao.ReceiptInfoMapper;
import com.tydic.fsc.settle.dao.SupplierInfoMapper;
import com.tydic.fsc.settle.dao.po.EntryInfoPO;
import com.tydic.fsc.settle.dao.po.EntryTotalInfoPO;
import com.tydic.fsc.settle.dao.po.FinanceConfig;
import com.tydic.fsc.settle.dao.po.PayPurchaseOrderInfo;
import com.tydic.fsc.settle.dao.po.PurchaseUnitInfo;
import com.tydic.fsc.settle.dao.po.ReceiptInfoPO;
import com.tydic.fsc.settle.dao.po.SupplierInfo;
import com.tydic.fsc.settle.dao.po.WorkFlowDataInfo;
import com.tydic.fsc.settle.dao.vo.EntryTotalInfoVO;
import com.tydic.fsc.settle.dao.vo.WFEventResult;
import com.tydic.fsc.settle.enums.OrderSource;
import com.tydic.fsc.settle.enums.YuanGuangBillType;
import com.tydic.fsc.settle.enums.YuanGuangType;
import com.tydic.fsc.settle.utils.AmountUtils;
import com.tydic.fsc.settle.utils.ContactUtils;
import com.tydic.fsc.settle.utils.FileUtils;
import com.tydic.fsc.settle.utils.FscStringUtils;
import com.tydic.fsc.supplier.BusiTransferEntryTotalService;
import com.tydic.fsc.supplier.bo.BusiTransferEntryTotalFileVO;
import com.tydic.fsc.supplier.bo.BusiTransferEntryTotalItemVO;
import com.tydic.fsc.supplier.bo.BusiTransferEntryTotalReqBO;
import com.tydic.fsc.supplier.bo.BusiTransferEntryTotalRspBO;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Service(value="entryTotalWorkFlowFinshEventImpl")
public class EntryTotalWorkFlowFinshEventImpl
implements WorkFlowFinishEvent {
    private static final Logger logger = LoggerFactory.getLogger(EntryTotalWorkFlowFinshEventImpl.class);
    private BusiTransferEntryTotalService busiTransferEntryTotalService;
    private EntryTotalInfoMapper entryTotalMapper;
    private EntryInfoMapper entryInfoMapper;
    private SupplierInfoMapper supplierInfoMapper;
    private ReceiptInfoMapper receiptInfoMapper;
    private QueryDictKeyValueService queryDictKeyValueService;
    private FinanceConfigMapper financeConfigMapper;
    private OrganizationInfoService organizationInfoService;
    private SourceMappingService sourceMappingService;
    private EnumsService enumsService;
    private InvokePaycenterService invokePaycenterService;
    private PayPurchaseOrderInfoMapper payPurchaseOrderInfoMapper;
    private UserInfoService userInfoService;

    @Autowired
    private EntryTotalWorkFlowFinshEventImpl(QueryDictKeyValueService queryDictKeyValueService, BusiTransferEntryTotalService busiTransferEntryTotalService, PayPurchaseOrderInfoMapper payPurchaseOrderInfoMapper, UserInfoService userInfoService, EntryTotalInfoMapper entryTotalMapper, EntryInfoMapper entryInfoMapper, SupplierInfoMapper supplierInfoMapper, ReceiptInfoMapper receiptInfoMapper, FinanceConfigMapper financeConfigMapper, OrganizationInfoService organizationInfoService, SourceMappingService sourceMappingService, EnumsService enumsService, InvokePaycenterService invokePaycenterService) {
        this.queryDictKeyValueService = queryDictKeyValueService;
        this.busiTransferEntryTotalService = busiTransferEntryTotalService;
        this.payPurchaseOrderInfoMapper = payPurchaseOrderInfoMapper;
        this.userInfoService = userInfoService;
        this.entryTotalMapper = entryTotalMapper;
        this.entryInfoMapper = entryInfoMapper;
        this.supplierInfoMapper = supplierInfoMapper;
        this.receiptInfoMapper = receiptInfoMapper;
        this.financeConfigMapper = financeConfigMapper;
        this.organizationInfoService = organizationInfoService;
        this.sourceMappingService = sourceMappingService;
        this.enumsService = enumsService;
        this.invokePaycenterService = invokePaycenterService;
    }

    @Override
    public WFEventResult process(WorkFlowDataInfo workFlowDataInfo, String billType, String billNo) {
        if (logger.isDebugEnabled()) {
            logger.debug("\u7269\u8d44\u6c47\u603b\u5355\u5de5\u4f5c\u6d41\u539f\u5b50\u670d\u52a1\u7684\u5b9e\u73b0\u7c7b\u5165\u53c2\uff0cworkFlowDataInfo=" + workFlowDataInfo.toString() + ";billType=" + billType + ";billNo=" + billNo);
        }
        if (!StringUtils.hasText((String)billNo)) {
            logger.error("\u6c47\u603b\u5355\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
            throw new BusinessException("0001", "\u6c47\u603b\u5355\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
        }
        EntryTotalInfoVO entryTotalInfoVO = new EntryTotalInfoVO();
        entryTotalInfoVO.setApplyNo(billNo);
        EntryTotalInfoPO entryTotalPO = this.entryTotalMapper.getModelById(entryTotalInfoVO);
        if (entryTotalPO == null) {
            logger.error("\u6839\u636e\u6c47\u603b\u5355\u53f7\u67e5\u8be2\u6c47\u603b\u5355\u4fe1\u606f\u8fd4\u56de\u4e3a\u7a7a\uff0c\u6c47\u603b\u5355\u53f7\u4e3a\uff1a" + billNo);
            throw new BusinessException("18001", "\u6839\u636e\u6c47\u603b\u5355\u53f7\u67e5\u8be2\u6c47\u603b\u5355\u4fe1\u606f\u8fd4\u56de\u4e3a\u7a7a");
        }
        String source = entryTotalPO.getSource();
        String targetSource = this.sourceMappingService.queryYuanguangTargetSource(source);
        String hjdx = AmountUtils.upper(entryTotalPO.getAmt());
        String documentType = YuanGuangType.ENTRY_MATERIAL_PURCHASE.getCode();
        FinanceConfig financeConfig = new FinanceConfig();
        financeConfig.setSource(targetSource);
        financeConfig.setOperUnitNo(entryTotalPO.getCompanyId());
        financeConfig.setBillType(documentType);
        financeConfig = this.financeConfigMapper.selectByFinanceConfig(financeConfig);
        if (null == financeConfig) {
            logger.error("\u6839\u636e\u6765\u6e90+\u4e13\u4e1a\u516c\u53f8+\u5355\u636e\u7c7b\u578b\u67e5\u8be2\u8d22\u52a1\u914d\u7f6e\u8868\u8fd4\u56de\u4e3a\u7a7a\uff0c\u6765\u6e90\u4e3a\uff1a" + source + ",\u4e13\u4e1a\u516c\u53f8ID\u4e3a\uff1a" + entryTotalPO.getCompanyId() + ",\u5355\u636e\u7c7b\u578b\u4e3a\uff1a" + documentType);
            throw new BusinessException("18001", "\u6839\u636e\u6765\u6e90+\u4e13\u4e1a\u516c\u53f8+\u5355\u636e\u7c7b\u578b\u67e5\u8be2\u8d22\u52a1\u914d\u7f6e\u8868\u8fd4\u56de\u4e3a\u7a7a");
        }
        Map<String, String> keyValue = this.queryDictKeyValueService.queryDictKeyValue(targetSource, documentType, entryTotalPO.getCompanyId());
        BusiTransferEntryTotalReqBO reqBO = new BusiTransferEntryTotalReqBO();
        reqBO.setSeqid("PAY" + YuanGuangType.ENTRY_MATERIAL_PURCHASE.getCode() + billNo);
        reqBO.setFlowid(financeConfig.getProcessId());
        reqBO.setSsdw(financeConfig.getUnitName());
        reqBO.setYhdm(this.userInfoService.queryFinanceUserCodeByUserId(source, financeConfig, entryTotalPO.getDocumentationId()));
        ArrayList<Object> items = new ArrayList<Object>();
        reqBO.setItems(items);
        String supplierName = null;
        EntryInfoPO entryInfo = new EntryInfoPO();
        entryInfo.setApplyNo(billNo);
        List<EntryInfoPO> entryInfoList = this.entryInfoMapper.getList(entryInfo);
        if (entryInfoList == null) {
            logger.error("\u6839\u636e\u6c47\u603b\u5355\u53f7\u67e5\u8be2\u6c47\u603b\u5355\u8be6\u60c5\u8fd4\u56de\u4e3a\u7a7a\uff0c\u6c47\u603b\u5355\u53f7\u4e3a:" + billNo);
            throw new BusinessException("18000", "\u6839\u636e\u6c47\u603b\u5355\u53f7\u67e5\u8be2\u6c47\u603b\u5355\u8be6\u60c5\u8fd4\u56de\u4e3a\u7a7a");
        }
        HashSet<String> purchaseOrderCodes = new HashSet<String>();
        for (EntryInfoPO entryInfoPO : entryInfoList) {
            BusiTransferEntryTotalItemVO item = new BusiTransferEntryTotalItemVO();
            item.setWzfl(keyValue.get("\u7269\u8d44\u5206\u7c7b"));
            item.setSfrk(keyValue.get("\u662f\u5426\u5165\u5e93"));
            item.setCkfl(keyValue.get("\u4ed3\u5e93\u5206\u7c7b"));
            item.setHwzcje(entryInfoPO.getNotTaxAmt());
            item.setHwzcsl(this.enumsService.queryDefaultTaxRate());
            item.setHwzcse(entryInfoPO.getTax());
            item.setHwzcsfdk(keyValue.get("\u8d27\u7269\u652f\u51fa\u662f\u5426\u62b5\u6263"));
            item.setHwzcjshj(entryInfoPO.getAmt());
            item.setYfzcje(BigDecimal.ZERO);
            item.setYfzcsl(BigDecimal.ZERO);
            item.setYfzcse(BigDecimal.ZERO);
            item.setYfzcsf(keyValue.get("\u8fd0\u8d39\u652f\u51fa\u662f\u5426\u62b5\u6263"));
            item.setYfzcjshj(BigDecimal.ZERO);
            item.setGs(BigDecimal.ZERO);
            item.setZf(BigDecimal.ZERO);
            item.setQtfy(BigDecimal.ZERO);
            item.setJexj(entryInfoPO.getAmt());
            item.setHjdx(hjdx);
            HashSet<Long> inspectionIds = new HashSet<Long>();
            Long supplierId = entryInfoPO.getPurchaseId();
            if (OrderSource.ELECTRIC_AREA.getCode().equals(source) || OrderSource.CONSULT_PRICE.getCode().equals(source) || OrderSource.COAL_AREA.getCode().equals(source)) {
                ReceiptInfoPO receiptInfoPO = new ReceiptInfoPO();
                receiptInfoPO.setEntryNo(entryInfoPO.getEntryNo());
                List<ReceiptInfoPO> receiptInfoList = this.receiptInfoMapper.getList(receiptInfoPO);
                if (CollectionUtils.isEmpty(receiptInfoList)) {
                    logger.error("\u6839\u636e\u5165\u5e93\u5355\u53f7\u672a\u627e\u5230\u5165\u5e93\u660e\u7ec6\uff0c\u5165\u5e93\u5355\u53f7=" + entryInfoPO.getEntryNo());
                    throw new BusinessException("18001", "\u6839\u636e\u5165\u5e93\u5355\u53f7\u672a\u627e\u5230\u5165\u5e93\u660e\u7ec6\uff0c\u5165\u5e93\u5355\u53f7=" + entryInfoPO.getEntryNo());
                }
                List<Object> orderInfoList = new ArrayList();
                for (ReceiptInfoPO receiptInfo : receiptInfoList) {
                    Long orderId = receiptInfo.getOrderNo();
                    PayPurchaseOrderInfo payPurchaseOrderInfo = new PayPurchaseOrderInfo();
                    payPurchaseOrderInfo.setOrderId(orderId);
                    orderInfoList = this.payPurchaseOrderInfoMapper.getListByCondition(payPurchaseOrderInfo);
                    if (CollectionUtils.isEmpty(orderInfoList)) {
                        logger.error("\u6839\u636e\u8ba2\u5355ID\u672a\u627e\u5230\u91c7\u8d2d\u8ba2\u5355\uff0c\u8ba2\u5355ID=" + orderId);
                        throw new BusinessException("18001", "\u6839\u636e\u8ba2\u5355ID\u672a\u627e\u5230\u91c7\u8d2d\u8ba2\u5355\uff0c\u8ba2\u5355ID=" + orderId);
                    }
                    for (PayPurchaseOrderInfo payPurchaseOrderInfo2 : orderInfoList) {
                        inspectionIds.add(payPurchaseOrderInfo2.getInspectionId());
                        purchaseOrderCodes.add(payPurchaseOrderInfo2.getPurchaseOrderCode());
                    }
                }
                Long purchaseProjectId = orderInfoList.get(0) == null ? null : ((PayPurchaseOrderInfo)orderInfoList.get(0)).getPurchaseProjectId();
                PurchaseUnitInfo purchaseUnitInfo = this.organizationInfoService.queryParentAccount(purchaseProjectId);
                if (purchaseUnitInfo == null) {
                    String projectName = this.organizationInfoService.queryProjectName(purchaseProjectId).getAccountName();
                    logger.error("\u6839\u636e\u91c7\u8d2d\u5355\u4f4d\u8d26\u5957[\u8d26\u5957ID=" + purchaseProjectId + "\uff0c\u8d26\u5957\u540d\u79f0=" + projectName + "]\u6216\u5176\u7236\u8d26\u5957\u67e5\u4e0d\u5230\u5408\u540c\uff0c\u8bf7\u914d\u7f6e");
                    throw new BusinessException("18004", "\u6839\u636e\u91c7\u8d2d\u5355\u4f4d\u8d26\u5957[\u8d26\u5957ID=" + purchaseProjectId + "\uff0c\u8d26\u5957\u540d\u79f0=" + projectName + "]\u6216\u5176\u7236\u8d26\u5957\u67e5\u4e0d\u5230\u5408\u540c\uff0c\u8bf7\u914d\u7f6e");
                }
                String xshtbh = ContactUtils.obtainXshtbh(financeConfig, purchaseUnitInfo, source);
                item.setCghtbh(xshtbh);
                supplierName = this.organizationInfoService.querySupplierName(entryTotalPO.getPurchaseId());
                item.setGhdw(supplierName);
                item.setBccxyfk(entryInfoPO.getWriteoffAmt());
            } else if (OrderSource.ELECTRIC_MARKET.getCode().equals(source)) {
                SupplierInfo supplierInfo = this.supplierInfoMapper.selectByPrimaryKey(supplierId);
                if (null == supplierInfo) {
                    logger.error("\u6839\u636e\u4f9b\u5e94\u5546Id\u67e5\u8be2\u4f9b\u5e94\u5546\u5f00\u7968\u9650\u989d\u914d\u7f6e\u8868\u8fd4\u56de\u4e3a\u7a7a\uff0c\u4f9b\u5e94\u5546Id\u4e3a\uff1a" + entryInfoPO.getPurchaseId());
                    throw new BusinessException("18001", "\u6839\u636e\u4f9b\u5e94\u5546Id\u67e5\u8be2\u4f9b\u5e94\u5546\u5f00\u7968\u9650\u989d\u914d\u7f6e\u8868\u8fd4\u56de\u4e3a\u7a7a");
                }
                item.setCghtbh(supplierInfo.getEffectContactNo());
                item.setGhdw(supplierInfo.getSupplierName());
                supplierName = supplierInfo.getSupplierName();
                item.setBccxyfk(BigDecimal.ZERO);
            }
            item.setCllb(keyValue.get("\u6750\u6599\u7c7b\u522b"));
            item.setYfkye(BigDecimal.ZERO);
            item.setBcsyyfkye(BigDecimal.ZERO);
            BigDecimal bzjkkje = BigDecimal.ZERO;
            BigDecimal bcyfje = entryInfoPO.getAmt();
            if (OrderSource.ELECTRIC_AREA.getCode().equals(source) || OrderSource.COAL_AREA.getCode().equals(source)) {
                Map<Long, BigDecimal> warrantyAmts = this.invokePaycenterService.obtainWarrantyAmt4PurchaseInspection(new ArrayList<Long>(inspectionIds));
                for (BigDecimal warrantyAmt : warrantyAmts.values()) {
                    bzjkkje = bzjkkje.add(warrantyAmt);
                }
                bcyfje = bcyfje.subtract(bzjkkje);
            }
            item.setBzjkkje(bzjkkje);
            item.setBcyfje(bcyfje);
            item.setBccgje(entryInfoPO.getAmt());
            items.add(item);
        }
        StringBuilder summary = new StringBuilder();
        StringBuilder stringBuilder = new StringBuilder();
        for (String purchaseOrderCode : purchaseOrderCodes) {
            stringBuilder.append(purchaseOrderCode).append(";");
        }
        if (stringBuilder.length() > 0) {
            stringBuilder.deleteCharAt(stringBuilder.lastIndexOf(";"));
        }
        if (OrderSource.ELECTRIC_AREA.getCode().equals(source) || OrderSource.COAL_AREA.getCode().equals(source)) {
            summary.append("\u7ed3\u7b97").append(supplierName).append("\u6750\u6599\u6b3e(").append((CharSequence)stringBuilder).append(")");
        } else {
            if (OrderSource.CONSULT_PRICE.getCode().equals(source)) {
                summary.append("[").append(billNo).append("]");
            }
            summary.append("\u7ed3\u7b97").append(supplierName).append("\u6750\u6599\u6b3e");
            if (OrderSource.CONSULT_PRICE.getCode().equals(source)) {
                summary.append("(").append((CharSequence)stringBuilder).append(")");
            }
        }
        String summaryStr = summary.toString();
        summaryStr = FscStringUtils.cutStringByByte(summaryStr, "UTF-8", 200);
        reqBO.setSummary(summaryStr);
        LinkedList<BusiTransferEntryTotalFileVO> attachItems = new LinkedList<BusiTransferEntryTotalFileVO>();
        if ("1".equals(this.enumsService.querFileTransmitYuanGuangSwitch(source))) {
            BusiTransferEntryTotalFileVO fjxx;
            double bytesTotalLen = 0.0;
            String subUrl = "/rest/download/busiExportEntryTotalInfoController";
            HashMap<String, Object> urlParam = new HashMap<String, Object>();
            urlParam.put("applyNo", billNo);
            urlParam.put("companyId", entryTotalPO.getCompanyId());
            Map<String, Object> fileInfoMap = FileUtils.getTransmitYuanGuangFileInfo(YuanGuangBillType.ENTRY_MATERIAL_PURCHASE.getCode(), billNo, entryTotalPO.getCompanyId(), ".pdf", subUrl, urlParam, bytesTotalLen);
            if (((Boolean)fileInfoMap.get("transmit")).booleanValue()) {
                bytesTotalLen = (Double)fileInfoMap.get("bytesTotalLen");
                fjxx = new BusiTransferEntryTotalFileVO();
                fjxx.setName((String)fileInfoMap.get("name"));
                fjxx.setContent((String)fileInfoMap.get("content"));
                attachItems.add(fjxx);
            }
            subUrl = "/rest/download/busiExportReceiptDetailInfoController";
            urlParam = new HashMap(2);
            urlParam.put("applyNo", billNo);
            fileInfoMap = FileUtils.getTransmitYuanGuangFileInfo(YuanGuangBillType.ENTRY_MATERIAL_PURCHASE_ENTRY.getCode(), billNo, entryTotalPO.getCompanyId(), ".pdf", subUrl, urlParam, bytesTotalLen);
            if (((Boolean)fileInfoMap.get("transmit")).booleanValue()) {
                bytesTotalLen = (Double)fileInfoMap.get("bytesTotalLen");
                fjxx = new BusiTransferEntryTotalFileVO();
                fjxx.setName((String)fileInfoMap.get("name"));
                fjxx.setContent((String)fileInfoMap.get("content"));
                attachItems.add(fjxx);
            }
            subUrl = "/rest/download/busiExportListReceiptInfoController";
            urlParam = new HashMap(2);
            urlParam.put("applyNo", billNo);
            fileInfoMap = FileUtils.getTransmitYuanGuangFileInfo(YuanGuangBillType.ENTRY_MATERIAL_PURCHASE_ENTRY_DETAIL.getCode(), billNo, entryTotalPO.getCompanyId(), ".pdf", subUrl, urlParam, bytesTotalLen);
            if (((Boolean)fileInfoMap.get("transmit")).booleanValue()) {
                bytesTotalLen = (Double)fileInfoMap.get("bytesTotalLen");
                fjxx = new BusiTransferEntryTotalFileVO();
                fjxx.setName((String)fileInfoMap.get("name"));
                fjxx.setContent((String)fileInfoMap.get("content"));
                attachItems.add(fjxx);
            }
            logger.debug("\u4f20\u9001\u6587\u4ef6\u5b57\u8282\u957f\u5ea6:" + bytesTotalLen);
        }
        if (CollectionUtils.isEmpty(attachItems)) {
            BusiTransferEntryTotalFileVO fjxx = new BusiTransferEntryTotalFileVO();
            fjxx.setName("");
            fjxx.setContent("");
            attachItems.add(fjxx);
        }
        reqBO.setAttachItems(attachItems);
        BusiTransferEntryTotalRspBO rspBO = this.busiTransferEntryTotalService.transferEntryTotal(reqBO);
        WFEventResult wfEventResult = new WFEventResult();
        if ("1".equals(rspBO.getResponeCode())) {
            wfEventResult.setSuccess(true);
        } else {
            wfEventResult.setSuccess(false);
        }
        wfEventResult.setRespCode(rspBO.getResponeCode());
        wfEventResult.setSsn(rspBO.getFinanceNo());
        wfEventResult.setRespDesc(rspBO.getRspMsg());
        return wfEventResult;
    }
}

