/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.settle.atom.impl;

import com.ohaotian.plugin.base.exception.BusinessException;
import com.tydic.fsc.settle.atom.QueryDictKeyValueService;
import com.tydic.fsc.settle.atom.impl.EntryTotalWorkFlowFinshEventImpl;
import com.tydic.fsc.settle.dao.FinanceDictionaryMapper;
import com.tydic.fsc.settle.dao.po.FinanceDictionary;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service(value="queryDictKeyValueService")
public class QueryDictKeyValueServiceImpl
implements QueryDictKeyValueService {
    private static final Logger logger = LoggerFactory.getLogger(EntryTotalWorkFlowFinshEventImpl.class);
    @Autowired
    private FinanceDictionaryMapper financeDictionaryMapper;

    @Override
    public Map<String, String> queryDictKeyValue(String source, String billType) {
        return this.queryDictKeyValue(source, billType, null);
    }

    @Override
    public Map<String, String> queryDictKeyValue(String source, String billType, Long operUnitNo) {
        if (logger.isDebugEnabled()) {
            logger.debug("\u67e5\u8be2\u8d22\u52a1\u5b57\u5178\u8868\u952e\u503c\u539f\u5b50\u670d\u52a1\u5b9e\u73b0\u7c7b\u5165\u53c2\uff0csource=" + source + ";billType=" + billType + ";operUnitNo=" + operUnitNo);
        }
        List<FinanceDictionary> financeDictList = null;
        try {
            financeDictList = this.financeDictionaryMapper.selectByConditions(source, billType);
        }
        catch (Exception e) {
            logger.error("\u6839\u636e\u6765\u6e90+\u5355\u636e\u7c7b\u578b\u67e5\u8be2\u8d22\u52a1\u5b57\u5178\u8868\u5931\u8d25\uff0c\u6765\u6e90\u4e3a" + source + ",\u5355\u636e\u7c7b\u578b\u4e3a\uff1a" + billType);
            throw new BusinessException("18000", "\u6839\u636e\u6765\u6e90+\u5355\u636e\u7c7b\u578b\u67e5\u8be2\u8d22\u52a1\u5b57\u5178\u8868\u5931\u8d25");
        }
        if (CollectionUtils.isEmpty(financeDictList)) {
            logger.error("\u6839\u636e\u6765\u6e90+\u5355\u636e\u7c7b\u578b\u67e5\u8be2\u8d22\u52a1\u5b57\u5178\u8868\u8fd4\u56de\u4e3a\u7a7a\uff0c\u6765\u6e90\u4e3a" + source + ",\u5355\u636e\u7c7b\u578b\u4e3a\uff1a" + billType);
            throw new BusinessException("18001", "\u6839\u636e\u6765\u6e90+\u5355\u636e\u7c7b\u578b\u67e5\u8be2\u8d22\u52a1\u5b57\u5178\u8868\u8fd4\u56de\u4e3a\u7a7a");
        }
        HashMap<String, String> keyvalue = new HashMap<String, String>(financeDictList.size() + 1);
        for (FinanceDictionary financeDict : financeDictList) {
            String key = financeDict.getCode();
            String value = financeDict.getValue();
            if (!keyvalue.containsKey(key) && financeDict.getOperUnitNo() == 0L) {
                keyvalue.put(key, value);
            }
            if (operUnitNo == null || !operUnitNo.equals(financeDict.getOperUnitNo())) continue;
            keyvalue.put(key, value);
        }
        return keyvalue;
    }
}

