/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.settle.busi.impl;

import com.ohaotian.plugin.base.exception.BusinessException;
import com.tydic.fsc.settle.atom.BillSNService;
import com.tydic.fsc.settle.bo.FscBaseRspBo;
import com.tydic.fsc.settle.busi.api.BusiAddBillApplyInfoService;
import com.tydic.fsc.settle.busi.api.bo.BusiAddBillApplyInfoReqBO;
import com.tydic.fsc.settle.busi.api.vo.InvoiceHeaderVO;
import com.tydic.fsc.settle.busi.api.vo.InvoiceMailAddrInfoVO;
import com.tydic.fsc.settle.dao.BillApplyInfoMapper;
import com.tydic.fsc.settle.dao.SaleItemInfoMapper;
import com.tydic.fsc.settle.dao.SaleOrderInfoMapper;
import com.tydic.fsc.settle.dao.po.BillApplyInfo;
import com.tydic.fsc.settle.dao.po.SaleItemInfo;
import com.tydic.fsc.settle.dao.po.SaleOrderInfo;
import com.tydic.fsc.settle.dao.vo.SaleItemInfoVO;
import com.tydic.fsc.settle.dao.vo.SaleOrderInfoVO;
import com.tydic.fsc.settle.enums.BillStatus;
import com.tydic.fsc.settle.enums.BillType;
import com.tydic.fsc.settle.enums.InvoiceClasses;
import com.tydic.fsc.settle.enums.OrderSource;
import com.tydic.fsc.settle.enums.OrderStatus;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

@Service
public class BusiAddBillApplyInfoServiceImpl
implements BusiAddBillApplyInfoService {
    private static final Logger logger = LoggerFactory.getLogger(BusiAddBillApplyInfoServiceImpl.class);
    @Autowired
    private BillSNService billSNService;
    @Autowired
    private SaleOrderInfoMapper saleOrderInfoMapper;
    @Autowired
    private SaleItemInfoMapper saleItemInfoMapper;
    @Autowired
    private BillApplyInfoMapper billApplyInfoMapper;

    public FscBaseRspBo add(BusiAddBillApplyInfoReqBO reqBO) {
        List<SaleOrderInfo> orderList;
        if (logger.isDebugEnabled()) {
            logger.debug("\u65b0\u589e\u5f00\u7968\u7533\u8bf7\u670d\u52a1(\u7535\u5b50\u8d85\u5e02)(\u4e13\u4e1a\u516c\u53f8\u548c\u91c7\u8d2d\u5355\u4f4d\u5171\u7528)\u5165\u53c2\uff1a" + reqBO);
        }
        if (reqBO == null) {
            throw new BusinessException("0001", "\u5165\u53c2\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (!StringUtils.hasText((String)reqBO.getIsOperUnit())) {
            throw new BusinessException("0001", "\u5165\u53c2\u662f\u5426\u4e13\u4e1a\u516c\u53f8\u7528\u6237\u3010isOperUnit\u3011\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (reqBO.getPurchaseNo() == null || reqBO.getPurchaseNo() <= 0L) {
            throw new BusinessException("0001", "\u5165\u53c2\u91c7\u8d2d\u5355\u4f4d\u3010purchaseNo\u3011\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (reqBO.getPurchaseProjectId() == null || reqBO.getPurchaseProjectId() <= 0L) {
            throw new BusinessException("0001", "\u5165\u53c2\u91c7\u8d2d\u5355\u4f4d\u8d26\u5957\u3010purchaseProjectId\u3011\u4e0d\u80fd\u4e3a\u7a7a");
        }
        InvoiceHeaderVO invoiceInfo = reqBO.getInvoiceInfo();
        InvoiceMailAddrInfoVO mailAddrInfo = reqBO.getMailAddrInfo();
        if (invoiceInfo == null) {
            throw new BusinessException("0001", "\u53d1\u7968\u4fe1\u606f\u4e0d\u6b63\u786e");
        }
        if (!StringUtils.hasText((String)invoiceInfo.getInvoiceTitle())) {
            throw new BusinessException("0001", "\u53d1\u7968\u4fe1\u606f\u4e2d\u7684\u53d1\u7968\u62ac\u5934\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (mailAddrInfo == null) {
            throw new BusinessException("0001", "\u90ae\u5bc4\u4fe1\u606f\u4e0d\u6b63\u786e");
        }
        if (!StringUtils.hasText((String)mailAddrInfo.getName())) {
            throw new BusinessException("0001", "\u90ae\u5bc4\u4fe1\u606f\u4e0d\u6b63\u786e");
        }
        String saleOrderCode = reqBO.getSaleOrderCode();
        ArrayList<String> saleOrderCodeList = new ArrayList<String>();
        if (StringUtils.hasText((String)saleOrderCode)) {
            try {
                for (String element : saleOrderCode.split(",")) {
                    saleOrderCodeList.add(element);
                }
            }
            catch (Exception e) {
                throw new BusinessException("0001", "\u5165\u53c2\u4e2d\u7684\u8ba2\u5355\u7f16\u53f7\u3010orderId\u3011\u683c\u5f0f\u4e0d\u6b63\u786e");
            }
        }
        SaleOrderInfoVO saleOrderInfoVO = new SaleOrderInfoVO();
        BeanUtils.copyProperties((Object)reqBO, (Object)saleOrderInfoVO);
        if ("1".equals(reqBO.getIsOperUnit())) {
            saleOrderInfoVO.setOperUnitNo(reqBO.getCompanyId());
        }
        saleOrderInfoVO.setSource(OrderSource.ELECTRIC_MARKET.getCode());
        saleOrderInfoVO.setOrderStatus(OrderStatus.NO_APPLY.getCode());
        if (saleOrderInfoVO.getOrderDateEnd() != null) {
            try {
                String orderDateEndString = new SimpleDateFormat("yyyy-MM-dd").format(saleOrderInfoVO.getOrderDateEnd()) + " 23:59:59";
                saleOrderInfoVO.setOrderDateEnd(new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").parse(orderDateEndString));
            }
            catch (ParseException e) {
                throw new BusinessException("18000", "\u683c\u5f0f\u5316\u65e5\u671f\u51fa\u9519");
            }
        }
        if (!saleOrderCodeList.isEmpty()) {
            saleOrderInfoVO.setSaleOrderCodeList(saleOrderCodeList);
        }
        if ((orderList = this.saleOrderInfoMapper.getListJoin(saleOrderInfoVO)).isEmpty()) {
            throw new BusinessException("0001", "\u6ca1\u6709\u6ee1\u8db3\u6761\u4ef6\u7684\u8ba2\u5355");
        }
        ArrayList<BillApplyInfo> billApplyInfoList = new ArrayList<BillApplyInfo>();
        for (SaleOrderInfo order : orderList) {
            String applyNo = this.billSNService.getSnAsString(BillType.INVOICE_APPLICATION);
            saleOrderInfoVO = new SaleOrderInfoVO();
            saleOrderInfoVO.setOrderStatus(OrderStatus.NO_APPLY.getCode());
            saleOrderInfoVO.setInspectionId(order.getInspectionId());
            SaleOrderInfo saleOrderInfo = new SaleOrderInfo();
            saleOrderInfo.setApplyNo(applyNo);
            saleOrderInfo.setOrderStatus(OrderStatus.APPLIED.getCode());
            this.saleOrderInfoMapper.updateByCondition(saleOrderInfoVO, saleOrderInfo);
            SaleItemInfoVO saleItemInfoVO = new SaleItemInfoVO();
            saleItemInfoVO.setItemStatus(OrderStatus.NO_APPLY.getCode());
            saleItemInfoVO.setInspectionId(order.getInspectionId());
            SaleItemInfo saleItemInfo = new SaleItemInfo();
            saleItemInfo.setApplyNo(applyNo);
            saleItemInfo.setItemStatus(OrderStatus.APPLIED.getCode());
            this.saleItemInfoMapper.updateByCondition(saleItemInfoVO, saleItemInfo);
            BillApplyInfo billApplyInfo = new BillApplyInfo();
            billApplyInfo.setInvoiceType(String.valueOf(invoiceInfo.getInvoiceType()));
            billApplyInfo.setInvoceName(invoiceInfo.getInvoiceTitle());
            billApplyInfo.setTaxNo(invoiceInfo.getTaxpayerId());
            billApplyInfo.setAddr(invoiceInfo.getAddress());
            billApplyInfo.setPhone(invoiceInfo.getPhone());
            billApplyInfo.setBankName(invoiceInfo.getBank());
            billApplyInfo.setBankAcctNo(invoiceInfo.getAccount());
            billApplyInfo.setName(mailAddrInfo.getName());
            billApplyInfo.setProvince(mailAddrInfo.getProvince());
            billApplyInfo.setCity(mailAddrInfo.getCity());
            billApplyInfo.setCounty(mailAddrInfo.getCounty());
            billApplyInfo.setTown("0".equals(mailAddrInfo.getTown()) ? null : mailAddrInfo.getTown());
            billApplyInfo.setProvId(mailAddrInfo.getProvId());
            billApplyInfo.setCityId(mailAddrInfo.getCityId());
            billApplyInfo.setCountyId(mailAddrInfo.getCountyId());
            billApplyInfo.setTownId(mailAddrInfo.getTownId());
            billApplyInfo.setAddrDesc(mailAddrInfo.getAddrDesc());
            billApplyInfo.setMobile(mailAddrInfo.getTel());
            billApplyInfo.setTel(mailAddrInfo.getSpecialPlane());
            billApplyInfo.setPostCode(mailAddrInfo.getPostCode());
            billApplyInfo.setApplyNo(applyNo);
            billApplyInfo.setApplyDate(new Date());
            billApplyInfo.setAmt(order.getOrderAmt());
            billApplyInfo.setBillStatus(BillStatus.NO_APPLY.getCode());
            billApplyInfo.setUserId(reqBO.getUserId());
            billApplyInfo.setSource(OrderSource.ELECTRIC_MARKET.getCode());
            billApplyInfo.setPurchaseNo(order.getPurchaseNo());
            billApplyInfo.setPurchaseName(order.getPurchaseName());
            billApplyInfo.setPurchaseProjectId(order.getPurchaseProjectId());
            billApplyInfo.setOperUnitNo(order.getOperUnitNo());
            billApplyInfo.setOperUnitName(order.getOperUnitName());
            billApplyInfo.setSupplierNo(order.getSupplierNo());
            billApplyInfo.setSupplierName(order.getSupplierName());
            billApplyInfo.setInvoiceClasses(InvoiceClasses.PAPER_INVOICE.getCode());
            billApplyInfoList.add(billApplyInfo);
        }
        this.billApplyInfoMapper.insertByBatch(billApplyInfoList);
        return new FscBaseRspBo();
    }
}

