/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.settle.busi.impl;

import com.ohaotian.plugin.base.exception.BusinessException;
import com.tydic.fsc.settle.busi.api.BusiCancelNotificationService;
import com.tydic.fsc.settle.busi.api.bo.BusiCancelNotificationReqBO;
import com.tydic.fsc.settle.busi.api.bo.BusiCancelNotificationRspBO;
import com.tydic.fsc.settle.dao.BillNotificationInfoMapper;
import com.tydic.fsc.settle.dao.PayInvoiceInfoMapper;
import com.tydic.fsc.settle.dao.PayItemInfoMapper;
import com.tydic.fsc.settle.dao.PayPurchaseOrderInfoMapper;
import com.tydic.fsc.settle.dao.po.BillNotificationInfo;
import com.tydic.fsc.settle.dao.po.PayItemInfo;
import com.tydic.fsc.settle.dao.po.PayPurchaseOrderInfo;
import com.tydic.fsc.settle.dao.vo.PayInvoiceInfoVO;
import com.tydic.fsc.settle.dao.vo.PayItemInfoVO;
import com.tydic.fsc.settle.enums.NotificationInvoiceStatus;
import com.tydic.fsc.settle.enums.OrderSource;
import com.tydic.fsc.supplier.BusiGetInvoiceDataService;
import com.tydic.fsc.supplier.bo.BusiGetInvoiceDataRspVO;
import com.tydic.fsc.supplier.bo.BusiGetInvoiceDataServiceReqBO;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Service
public class BusiCancelNotificationServiceImpl
implements BusiCancelNotificationService {
    private PayItemInfoMapper payItemInfoMapper;
    private BillNotificationInfoMapper billNotificationInfoMapper;
    private PayPurchaseOrderInfoMapper payPurchaseOrderInfoMapper;
    private BusiGetInvoiceDataService apiGetInvoiceDataService;
    private PayInvoiceInfoMapper payInvoiceInfoMapper;

    @Autowired
    private BusiCancelNotificationServiceImpl(PayItemInfoMapper payItemInfoMapper, BillNotificationInfoMapper billNotificationInfoMapper, PayPurchaseOrderInfoMapper payPurchaseOrderInfoMapper, BusiGetInvoiceDataService apiGetInvoiceDataService, PayInvoiceInfoMapper payInvoiceInfoMapper) {
        this.payItemInfoMapper = payItemInfoMapper;
        this.billNotificationInfoMapper = billNotificationInfoMapper;
        this.payPurchaseOrderInfoMapper = payPurchaseOrderInfoMapper;
        this.apiGetInvoiceDataService = apiGetInvoiceDataService;
        this.payInvoiceInfoMapper = payInvoiceInfoMapper;
    }

    public BusiCancelNotificationRspBO cancelNotification(BusiCancelNotificationReqBO reqBO) {
        String notificationNo = reqBO.getNotificationNo();
        Long companyId = reqBO.getCompanyId();
        if (!StringUtils.hasText((String)notificationNo)) {
            throw new BusinessException("0001", "\u53d6\u6d88\u5f00\u7968\u901a\u77e5\u5355\u670d\u52a1-\u5f00\u7968\u901a\u77e5\u5355\u53f7[notificationNo]\u5fc5\u987b\u8f93\u5165");
        }
        if (null == reqBO.getConfirmFlag()) {
            throw new BusinessException("0001", "\u53d6\u6d88\u5f00\u7968\u901a\u77e5\u5355\u670d\u52a1-\u786e\u8ba4\u6807\u8bc6[confirmFlag]\u5fc5\u987b\u8f93\u5165");
        }
        if (null == companyId) {
            throw new BusinessException("0001", "\u53d6\u6d88\u5f00\u7968\u901a\u77e5\u5355\u670d\u52a1-\u5728\u8bf7\u6c42\u6570\u636e\u4e2d\u65e0\u6cd5\u786e\u5b9a\u4e13\u4e1a\u516c\u53f8");
        }
        BillNotificationInfo bill = this.billNotificationInfoMapper.selectByPrimaryAndCompany(notificationNo, companyId);
        if (null == bill) {
            throw new BusinessException("0001", "\u901a\u77e5\u5355\u4e0d\u5b58\u5728");
        }
        String source = bill.getSource();
        if (NotificationInvoiceStatus.RECEIVED.getCode().equals(bill.getInvoiceStatus()) || NotificationInvoiceStatus.RETURN_BACK.getCode().equals(bill.getInvoiceStatus()) || NotificationInvoiceStatus.HAS_CANCEL.getCode().equals(bill.getInvoiceStatus())) {
            throw new BusinessException("0001", "\u5f53\u524d\u72b6\u6001\u4e0d\u5141\u8bb8\u53d6\u6d88");
        }
        if (NotificationInvoiceStatus.SUBMITED_FAIL.getCode().equals(bill.getInvoiceStatus())) {
            reqBO.setConfirmFlag(Boolean.valueOf(true));
        }
        BusiCancelNotificationRspBO rsp = new BusiCancelNotificationRspBO();
        String alertMsg = null;
        if (reqBO.getConfirmFlag().booleanValue()) {
            PayInvoiceInfoVO payInvoiceInfoVO = new PayInvoiceInfoVO();
            payInvoiceInfoVO.setNotificationNo(notificationNo);
            int count = this.payInvoiceInfoMapper.selectCount(payInvoiceInfoVO);
            if (count > 0) {
                throw new BusinessException("18000", "\u5df2\u6709\u53d1\u7968\uff0c\u4e0d\u5141\u8bb8\u53d6\u6d88");
            }
            BillNotificationInfo updBill = new BillNotificationInfo();
            updBill.setNotificationNo(notificationNo);
            updBill.setInvoiceStatus(NotificationInvoiceStatus.HAS_CANCEL.getCode());
            int update = this.billNotificationInfoMapper.updateByPrimaryKeySelective(updBill);
            if (update < 1) {
                throw new BusinessException("18000", "\u6570\u636e\u5e93\u66f4\u65b0\u4fe1\u606f\u5f02\u5e38");
            }
            if (OrderSource.ELECTRIC_MARKET.getCode().equals(source)) {
                List<PayPurchaseOrderInfo> orders = this.payPurchaseOrderInfoMapper.selectByNotifNo(notificationNo);
                for (PayPurchaseOrderInfo singleOrder : orders) {
                    int update1 = this.payPurchaseOrderInfoMapper.updateByReset(singleOrder);
                    if (update1 < 1) {
                        throw new BusinessException("18000", "\u6570\u636e\u5e93\u66f4\u65b0\u4fe1\u606f\u5f02\u5e38");
                    }
                    PayItemInfo item = new PayItemInfo();
                    item.setOrderId(singleOrder.getOrderId());
                    item.setInspectionId(singleOrder.getInspectionId());
                    int update2 = this.payItemInfoMapper.updateByReset(item);
                    if (update2 >= 1) continue;
                    throw new BusinessException("18000", "\u6570\u636e\u5e93\u66f4\u65b0\u4fe1\u606f\u5f02\u5e38");
                }
            } else {
                List<PayItemInfo> items = this.payItemInfoMapper.selectByNotifNo(notificationNo);
                HashSet<Long> inspectionIdSet = new HashSet<Long>();
                ArrayList<Long> seqList = new ArrayList<Long>();
                for (PayItemInfo singleItem : items) {
                    inspectionIdSet.add(singleItem.getInspectionId());
                    seqList.add(singleItem.getSeq());
                }
                PayItemInfoVO payItemInfoVO = new PayItemInfoVO();
                payItemInfoVO.setSeqList(seqList);
                int update1 = this.payItemInfoMapper.updateByResetDlzq(payItemInfoVO);
                if (update1 < 1) {
                    throw new BusinessException("18000", "\u6570\u636e\u5e93\u66f4\u65b0\u4fe1\u606f\u5f02\u5e38");
                }
                for (Long inspectionId : inspectionIdSet) {
                    PayPurchaseOrderInfo payPurchaseOrderInfo = new PayPurchaseOrderInfo();
                    payPurchaseOrderInfo.setInspectionId(inspectionId);
                    int update2 = this.payPurchaseOrderInfoMapper.updateByResetDlzq(payPurchaseOrderInfo);
                    if (update2 >= 1) continue;
                    throw new BusinessException("18000", "\u6570\u636e\u5e93\u66f4\u65b0\u4fe1\u606f\u5f02\u5e38");
                }
            }
        } else if (OrderSource.ELECTRIC_MARKET.getCode().equals(source)) {
            HashMap<String, String> dataMap = new HashMap<String, String>(2);
            String markId = bill.getNotificationNo();
            String id = String.valueOf(bill.getSupplierNo());
            dataMap.put(markId, id);
            BusiGetInvoiceDataServiceReqBO getInvoiceDataReqBO = new BusiGetInvoiceDataServiceReqBO();
            getInvoiceDataReqBO.setIdMap(dataMap);
            List invoiceDataList = this.apiGetInvoiceDataService.getInvoiceData(getInvoiceDataReqBO).getDataList();
            alertMsg = CollectionUtils.isEmpty((Collection)invoiceDataList) ? "\u7b2c\u4e09\u65b9\u63a5\u53e3\u83b7\u53d6\u5f00\u7968\u6570\u636e\u8fd4\u56de\u7684\u6570\u636e\u4e3a\u7a7a" : "\u901a\u77e5\u5355\u7684\u5f00\u7968\u72b6\u51b5\uff1a" + ((BusiGetInvoiceDataRspVO)invoiceDataList.get(0)).getResultMsg();
        } else {
            alertMsg = "\u786e\u5b9a\u8981\u53d6\u6d88\u5f53\u524d\u5f00\u7968\u901a\u77e5\u5355\u5417?";
        }
        rsp.setAlertMsg(alertMsg);
        rsp.setRespCode("0000");
        rsp.setRespDesc("\u53d6\u6d88\u5f00\u7968\u901a\u77e5\u5355\u6210\u529f");
        return rsp;
    }
}

