/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.settle.busi.impl;

import com.ohaotian.plugin.base.exception.BusinessException;
import com.tydic.fsc.settle.atom.EnumsService;
import com.tydic.fsc.settle.atom.OrganizationInfoService;
import com.tydic.fsc.settle.atom.UserInfoService;
import com.tydic.fsc.settle.busi.api.BusiExportApplyPayInfoService;
import com.tydic.fsc.settle.busi.api.FscQryAuditDetailBusiService;
import com.tydic.fsc.settle.busi.api.bo.AuditLogDetailBO;
import com.tydic.fsc.settle.busi.api.bo.BusiExportApplyPayInfo4DlzqItemRspBO;
import com.tydic.fsc.settle.busi.api.bo.BusiExportApplyPayInfo4DlzqRspBO;
import com.tydic.fsc.settle.busi.api.bo.BusiExportApplyPayInfo4DzcsRspBO;
import com.tydic.fsc.settle.busi.api.bo.BusiExportApplyPayInfoReqBO;
import com.tydic.fsc.settle.busi.api.bo.BusiExportApplyPayInfoRspBO;
import com.tydic.fsc.settle.busi.api.bo.FscQryAuditDetailBusiReqBO;
import com.tydic.fsc.settle.busi.api.bo.FscQryAuditDetailBusiRspBO;
import com.tydic.fsc.settle.dao.ApplyDetailMapper;
import com.tydic.fsc.settle.dao.ApplyPayInfoMapper;
import com.tydic.fsc.settle.dao.BillNotificationInfoMapper;
import com.tydic.fsc.settle.dao.PayableDetailMapper;
import com.tydic.fsc.settle.dao.SupplierInfoMapper;
import com.tydic.fsc.settle.dao.WorkFlowDataMapper;
import com.tydic.fsc.settle.dao.po.ApplyDetail;
import com.tydic.fsc.settle.dao.po.ApplyPayInfoPO;
import com.tydic.fsc.settle.dao.po.BillNotificationInfo;
import com.tydic.fsc.settle.dao.po.PayableDetailPO;
import com.tydic.fsc.settle.dao.po.SupplierInfo;
import com.tydic.fsc.settle.dao.po.WorkFlowDataInfo;
import com.tydic.fsc.settle.dao.vo.ApplyDetailVO;
import com.tydic.fsc.settle.enums.OrderSource;
import com.tydic.fsc.settle.enums.PayType;
import com.tydic.fsc.settle.enums.PayablePayType;
import com.tydic.fsc.settle.utils.AmountUtils;
import com.tydic.fsc.settle.utils.BeanUtils;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Service
public class BusiExportApplyPayInfoServiceImpl
implements BusiExportApplyPayInfoService {
    private static final Logger logger = LoggerFactory.getLogger(BusiExportApplyPayInfoServiceImpl.class);
    @Autowired
    private ApplyPayInfoMapper applyPayInfoMapper;
    @Autowired
    private ApplyDetailMapper applyDetailMapper;
    @Autowired
    private PayableDetailMapper payableDetailMapper;
    @Autowired
    private BillNotificationInfoMapper billNotificationInfoMapper;
    @Autowired
    private OrganizationInfoService organizationInfoService;
    @Autowired
    private SupplierInfoMapper supplierInfoMapper;
    @Autowired
    private UserInfoService userInfoService;
    @Autowired
    private EnumsService enumService;
    @Autowired
    private WorkFlowDataMapper workFlowDataMapper;
    @Autowired
    private FscQryAuditDetailBusiService fscQryAuditDetailBusiService;

    public BusiExportApplyPayInfoRspBO queryForExport(BusiExportApplyPayInfoReqBO reqBO) {
        if (logger.isDebugEnabled()) {
            logger.debug("\u4ed8\u6b3e\u7533\u8bf7\u6253\u5370\u6570\u636e\u67e5\u8be2\u5165\u53c2\uff1a" + reqBO);
        }
        if (reqBO.getId() == null) {
            throw new BusinessException("0001", "\u4ed8\u6b3e\u7533\u8bf7\u5355\u53f7[id]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        BusiExportApplyPayInfoRspBO rspBO = new BusiExportApplyPayInfoRspBO();
        ApplyPayInfoPO applyPayInfoReqBO = new ApplyPayInfoPO();
        applyPayInfoReqBO.setPayno(reqBO.getId());
        ApplyPayInfoPO applyPayInfoPO = this.applyPayInfoMapper.getModelBy(applyPayInfoReqBO);
        if (applyPayInfoPO == null) {
            throw new BusinessException("18001", "\u672a\u627e\u5230\u4ed8\u6b3e\u7533\u8bf7\u5355\uff0c\u4ed8\u6b3e\u7533\u8bf7\u5355\u53f7\uff1a" + reqBO.getId());
        }
        String source = applyPayInfoPO.getSource();
        rspBO.setSource(source);
        if (OrderSource.ELECTRIC_AREA.getCode().equals(source) || OrderSource.COAL_AREA.getCode().equals(source) || OrderSource.CONSULT_PRICE.getCode().equals(source)) {
            BusiExportApplyPayInfo4DlzqRspBO dlzqRspBO = new BusiExportApplyPayInfo4DlzqRspBO();
            rspBO.setDlzqRspBO(dlzqRspBO);
            dlzqRspBO.setRecAcctNo(applyPayInfoPO.getReceiptAcctNo());
            SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            try {
                dlzqRspBO.setApplyDate(dateFormat.format(applyPayInfoPO.getApplyDate()));
            }
            catch (Exception e) {
                logger.error("\u65e5\u671f\u683c\u5f0f\u5316\u5931\u8d25", (Throwable)e);
            }
            dlzqRspBO.setPayNo(applyPayInfoPO.getPayno());
            String operName = this.userInfoService.queryUserNameByUserId(applyPayInfoPO.getOperatorId());
            dlzqRspBO.setOperName(operName);
            dlzqRspBO.setRecOpenBankName(applyPayInfoPO.getOpenBankName());
            String companyName = this.organizationInfoService.queryOrgName(applyPayInfoPO.getCompanyId());
            dlzqRspBO.setCompanyName(companyName);
            String supplierName = this.organizationInfoService.querySupplierName(applyPayInfoPO.getSupplierId());
            dlzqRspBO.setSupplierName(supplierName);
            dlzqRspBO.setCurrency("\u4eba\u6c11\u5e01");
            dlzqRspBO.setRemark(applyPayInfoPO.getRemark());
            BigDecimal settleAmtTotal = BigDecimal.ZERO;
            BigDecimal payableAmtTotal = BigDecimal.ZERO;
            BigDecimal paidAmtTotal = BigDecimal.ZERO;
            BigDecimal amtTotal = BigDecimal.ZERO;
            ArrayList<BusiExportApplyPayInfo4DlzqItemRspBO> items = new ArrayList<BusiExportApplyPayInfo4DlzqItemRspBO>();
            dlzqRspBO.setItems(items);
            ApplyDetailVO applyDetailVO = new ApplyDetailVO();
            applyDetailVO.setApplyNo(applyPayInfoPO.getPayno());
            applyDetailVO.setOrderBy("b.APPLY_NO, a.ORDER_ID, a.PAY_TYPE");
            List<ApplyDetail> applyDetails = this.applyDetailMapper.selectList(applyDetailVO);
            for (ApplyDetail applyDetail : applyDetails) {
                BillNotificationInfo billNotificationInfo;
                BusiExportApplyPayInfo4DlzqItemRspBO item = new BusiExportApplyPayInfo4DlzqItemRspBO();
                items.add(item);
                PayableDetailPO payableDetailPO = this.payableDetailMapper.getModelById(applyDetail.getPayableNo());
                if (payableDetailPO == null) {
                    throw new BusinessException("18001", "\u6ca1\u6709\u67e5\u8be2\u5230\u5e94\u4ed8\u8bb0\u5f55\uff0c\u5e94\u4ed8\u7f16\u53f7\uff1a" + applyDetail.getPayableNo());
                }
                org.springframework.beans.BeanUtils.copyProperties((Object)payableDetailPO, (Object)item);
                item.setPurchaseOrderId(payableDetailPO.getOrderId());
                item.setPlaAgreementName(null);
                item.setPayTypeName(PayablePayType.getInstance(payableDetailPO.getPayType()).getDescr());
                BigDecimal settleAmt = BigDecimal.ZERO;
                if (StringUtils.hasText((String)payableDetailPO.getNotificationNo()) && null != (billNotificationInfo = this.billNotificationInfoMapper.selectByPrimaryKey(payableDetailPO.getNotificationNo()))) {
                    settleAmt = billNotificationInfo.getAmt();
                }
                item.setSettleAmt(AmountUtils.format(settleAmt));
                settleAmtTotal = settleAmtTotal.add(settleAmt);
                item.setPayableAmt(AmountUtils.format(payableDetailPO.getPayableAmt()));
                payableAmtTotal = payableAmtTotal.add(payableDetailPO.getPayableAmt());
                item.setPaidAmt(AmountUtils.format(payableDetailPO.getPaidAmt()));
                paidAmtTotal = paidAmtTotal.add(payableDetailPO.getPaidAmt());
                item.setAmt(AmountUtils.format(applyDetail.getAmt()));
                amtTotal = amtTotal.add(applyDetail.getAmt());
                BeanUtils.null2DefaultValue(item);
            }
            if (!CollectionUtils.isEmpty((Collection)dlzqRspBO.getItems())) {
                dlzqRspBO.setPayTypeName(((BusiExportApplyPayInfo4DlzqItemRspBO)dlzqRspBO.getItems().get(0)).getPayTypeName());
            }
            dlzqRspBO.setSettleAmt(AmountUtils.format(settleAmtTotal));
            dlzqRspBO.setPayableAmt(AmountUtils.format(payableAmtTotal));
            dlzqRspBO.setPaidAmt(AmountUtils.format(paidAmtTotal));
            dlzqRspBO.setAmt(AmountUtils.format(amtTotal));
            BeanUtils.null2DefaultValue(dlzqRspBO);
        } else {
            BusiExportApplyPayInfo4DzcsRspBO dzcsRspBO = new BusiExportApplyPayInfo4DzcsRspBO();
            rspBO.setDzcsRspBO(dzcsRspBO);
            SupplierInfo supplierInfo = this.supplierInfoMapper.selectByPrimaryKey(applyPayInfoPO.getSupplierId());
            if (supplierInfo != null) {
                dzcsRspBO.setContractNo(supplierInfo.getEffectContactNo());
            }
            dzcsRspBO.setRecAcctNo(applyPayInfoPO.getReceiptAcctNo());
            dzcsRspBO.setApplyAmt(applyPayInfoPO.getPayAmt());
            dzcsRspBO.setAmt(applyPayInfoPO.getPayAmt());
            dzcsRspBO.setAmtUpper(AmountUtils.upper(applyPayInfoPO.getPayAmt()));
            dzcsRspBO.setApplyDate(applyPayInfoPO.getApplyDate());
            dzcsRspBO.setPayNo(applyPayInfoPO.getPayno());
            String operName = this.userInfoService.queryUserNameByUserId(applyPayInfoPO.getOperatorId());
            dzcsRspBO.setOperName(operName);
            dzcsRspBO.setRecOpenBankName(applyPayInfoPO.getOpenBankName());
            String orgName = this.organizationInfoService.queryOrgName(reqBO.getOrgId());
            dzcsRspBO.setOrgName(orgName);
            String companyName = this.organizationInfoService.queryOrgName(applyPayInfoPO.getCompanyId());
            dzcsRspBO.setCompanyName(companyName);
            String supplierName = this.organizationInfoService.querySupplierName(applyPayInfoPO.getSupplierId());
            dzcsRspBO.setSupplierName(supplierName);
            dzcsRspBO.setReciever(applyPayInfoPO.getRecAcctName());
            dzcsRspBO.setRemark(applyPayInfoPO.getRemark());
            String payMethodIn = applyPayInfoPO.getPayMathod();
            String payMethodStr = this.enumService.getDescr(PayType.getInstance(payMethodIn));
            if ("02".equals(payMethodIn)) {
                payMethodStr = "\u627f\u5151\u6c47\u7968";
            }
            dzcsRspBO.setPayMethod(payMethodStr);
            List<ApplyDetail> applyDetails = this.applyDetailMapper.selectPayableList(reqBO.getId());
            if (applyDetails.isEmpty()) {
                throw new BusinessException("18001", "\u672a\u67e5\u8be2\u5230\u5e94\u4ed8\u660e\u7ec6\uff0c\u4ed8\u6b3e\u7533\u8bf7\u5355\u53f7\uff1a" + reqBO.getId());
            }
            PayableDetailPO singlePayable = this.payableDetailMapper.getModelById(applyDetails.get(0).getPayableNo());
            if (singlePayable == null) {
                throw new BusinessException("18001", "\u672a\u67e5\u8be2\u5230\u5e94\u4ed8\u8bb0\u5f55\uff0c\u5e94\u4ed8\u7f16\u53f7\uff1a" + applyDetails.get(0).getPayableNo());
            }
            BillNotificationInfo singleNotify = this.billNotificationInfoMapper.selectByPrimaryKey(singlePayable.getNotificationNo());
            if (null != singleNotify) {
                dzcsRspBO.setRecInvoiceAmt(singleNotify.getAmt());
            }
            dzcsRspBO.setExpectPaidDate(singlePayable.getPaidDate());
            WorkFlowDataInfo workFlowDataInfo1 = new WorkFlowDataInfo();
            workFlowDataInfo1.setBillNo(String.valueOf(reqBO.getId()));
            WorkFlowDataInfo workFlowDataInfo = this.workFlowDataMapper.getModelBy(workFlowDataInfo1);
            FscQryAuditDetailBusiReqBO qryAuditDetailBusiReqBO = new FscQryAuditDetailBusiReqBO();
            qryAuditDetailBusiReqBO.setProcInstId(workFlowDataInfo.getProcInstId());
            FscQryAuditDetailBusiRspBO qryAuditDetailBusiRspBO = this.fscQryAuditDetailBusiService.qryAuditDetail(qryAuditDetailBusiReqBO);
            List detailBOS = qryAuditDetailBusiRspBO.getRows();
            if (detailBOS == null || detailBOS.isEmpty()) {
                throw new BusinessException("18005", "\u672a\u5ba1\u6279\u5b8c\u6210\uff0c\u65e0\u6cd5\u67e5\u8be2\u5230\u5ba1\u6279\u4eba");
            }
            dzcsRspBO.setProjectManagerName(detailBOS.size() < 2 || detailBOS.get(1) == null ? "" : ((AuditLogDetailBO)detailBOS.get(1)).getOperName());
            dzcsRspBO.setOperatorManagerName(detailBOS.size() < 3 || detailBOS.get(2) == null ? "" : ((AuditLogDetailBO)detailBOS.get(2)).getOperName());
            BeanUtils.null2DefaultValue(dzcsRspBO);
        }
        return rspBO;
    }
}

