/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.settle.busi.impl;

import com.ohaotian.plugin.base.exception.BusinessException;
import com.ohaotian.plugin.db.Page;
import com.tydic.fsc.settle.atom.EnumsService;
import com.tydic.fsc.settle.atom.OrganizationInfoService;
import com.tydic.fsc.settle.busi.api.BusiQryNotificationDetailDlzqService;
import com.tydic.fsc.settle.busi.api.bo.BusiQryNotificationDetailReqBO;
import com.tydic.fsc.settle.busi.api.bo.BusiQryNtfDetailPart1RspBO;
import com.tydic.fsc.settle.busi.api.bo.BusiQryNtfDetailPart2DlzqRspBO;
import com.tydic.fsc.settle.busi.api.vo.InvoiceDetailVO;
import com.tydic.fsc.settle.busi.api.vo.InvoiceInfoVO;
import com.tydic.fsc.settle.busi.api.vo.OrderInfoVO;
import com.tydic.fsc.settle.busi.api.vo.OrderItemVO;
import com.tydic.fsc.settle.dao.BillNotificationInfoMapper;
import com.tydic.fsc.settle.dao.PayInvoiceDetailMapper;
import com.tydic.fsc.settle.dao.PayInvoiceInfoMapper;
import com.tydic.fsc.settle.dao.PayItemInfoMapper;
import com.tydic.fsc.settle.dao.PayPurchaseOrderInfoMapper;
import com.tydic.fsc.settle.dao.po.BillNotificationInfo;
import com.tydic.fsc.settle.dao.po.PayInvoiceDetail;
import com.tydic.fsc.settle.dao.po.PayInvoiceInfo;
import com.tydic.fsc.settle.dao.po.PayItemInfo;
import com.tydic.fsc.settle.dao.po.PayPurchaseOrderInfo;
import com.tydic.fsc.settle.enums.InvoiceType;
import com.tydic.fsc.settle.enums.OrderSource;
import com.tydic.fsc.settle.enums.OrderStatus;
import com.tydic.fsc.settle.utils.AntiSqlInjectionManage;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class BusiQryNotificationDetailDlzqServiceImpl
implements BusiQryNotificationDetailDlzqService {
    private static final Logger logger = LoggerFactory.getLogger(BusiQryNotificationDetailDlzqServiceImpl.class);
    @Autowired
    private PayItemInfoMapper payItemInfoMapper;
    @Autowired
    private BillNotificationInfoMapper billNotificationInfoMapper;
    @Autowired
    private PayPurchaseOrderInfoMapper payPurchaseOrderInfoMapper;
    @Autowired
    private PayInvoiceInfoMapper payInvoiceInfoMapper;
    @Autowired
    private PayInvoiceDetailMapper payInvoiceDetailMapper;
    @Autowired
    private OrganizationInfoService organizationInfoService;
    @Autowired
    private EnumsService enumsService;

    public BusiQryNtfDetailPart1RspBO qryNotifyDetailPart1Dlzq(BusiQryNotificationDetailReqBO reqBO) {
        if (logger.isDebugEnabled()) {
            logger.debug("\u67e5\u8be2\u5f00\u7968\u901a\u77e5\u8be6\u60c5\u4e1a\u52a1\u670d\u52a1\u7b2c\u4e00\u90e8\u5206\u5165\u53c2\uff1a" + reqBO.toString());
        }
        if (null == reqBO.getNotificationNo()) {
            throw new BusinessException("0001", "\u67e5\u8be2\u5f00\u7968\u901a\u77e5\u8be6\u60c5\u4e1a\u52a1\u670d\u52a1-\u5f00\u7968\u901a\u77e5\u5355\u53f7[notificationNo]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        BillNotificationInfo notification = new BillNotificationInfo();
        try {
            notification = this.billNotificationInfoMapper.selectByPrimaryKey(reqBO.getNotificationNo());
        }
        catch (Exception e) {
            logger.error("\u67e5\u8be2\u5f00\u7968\u901a\u77e5\u5355\u5217\u8868-\u901a\u77e5\u5355\u53f7\u5165\u53c2\uff1a" + reqBO.getNotificationNo(), (Throwable)e);
            throw new BusinessException("18000", "\u67e5\u8be2\u5f00\u7968\u901a\u77e5\u5217\u8868-\u6570\u636e\u5e93\u64cd\u4f5c\u9519\u8bef");
        }
        if (null == notification) {
            logger.info("billNotificationInfoMapper.selectByPrimaryKey\u67e5\u8be2\u8fd4\u56de\u4e3a\u7a7a,\u5165\u53c2\uff1a" + reqBO.getNotificationNo());
            throw new BusinessException("18001", "\u5f00\u7968\u901a\u77e5\u5355\u53f7\uff1a" + reqBO.getNotificationNo() + "\u6ca1\u6709\u901a\u77e5\u5355\u8bb0\u5f55");
        }
        String orderBy = null;
        if (!StringUtils.isEmpty((CharSequence)reqBO.getSortName()) && !StringUtils.isEmpty((CharSequence)reqBO.getSortOrder())) {
            if (AntiSqlInjectionManage.sqlValidate(reqBO.getSortName()) || AntiSqlInjectionManage.sqlValidate(reqBO.getSortOrder())) {
                logger.error("\u60a8\u53d1\u9001\u8bf7\u6c42\u4e2d\u7684\u53c2\u6570\u4e2d\u542b\u6709\u975e\u6cd5\u5b57\u7b26");
                throw new BusinessException("18000", "\u60a8\u53d1\u9001\u8bf7\u6c42\u4e2d\u7684\u53c2\u6570\u4e2d\u542b\u6709\u975e\u6cd5\u5b57\u7b26");
            }
            orderBy = reqBO.getSortName() + " " + reqBO.getSortOrder();
        }
        Page page = new Page(reqBO.getPageNo(), reqBO.getPageSize());
        List<Object> orderInfos = new LinkedList();
        try {
            orderInfos = this.payPurchaseOrderInfoMapper.getListPageByItemNotifNo(reqBO.getNotificationNo(), (Page<Map<String, Object>>)page, orderBy);
        }
        catch (Exception e) {
            logger.info("payPurchaseOrderInfoMapper.getListPageByNotifNo\u67e5\u8be2\u8fd4\u56de\u4e3a\u7a7a,\u5165\u53c2\uff1a" + reqBO.getNotificationNo(), (Throwable)e);
            throw new BusinessException("18001", "\u5f00\u7968\u901a\u77e5\u5355\u53f7\uff0c\u67e5\u8be2\u8ba2\u5355\u4fe1\u606f\uff0c\u6570\u636e\u5e93\u64cd\u4f5c\u5931\u8d25");
        }
        if (orderInfos.isEmpty()) {
            logger.info("payPurchaseOrderInfoMapper.selectByNotifNo\u67e5\u8be2\u8fd4\u56de\u4e3a\u7a7a,\u5165\u53c2\uff1a" + reqBO.getNotificationNo());
            throw new BusinessException("18001", "\u5f00\u7968\u901a\u77e5\u5355\u53f7\uff1a" + reqBO.getNotificationNo() + "\u6ca1\u6709\u8ba2\u5355\u8bb0\u5f55");
        }
        BusiQryNtfDetailPart1RspBO rspBO = new BusiQryNtfDetailPart1RspBO();
        rspBO.setNotificationNo(notification.getNotificationNo());
        rspBO.setApplyDate(notification.getApplyDate());
        rspBO.setApplyAmt(notification.getAmt());
        rspBO.setOrderNum(Integer.valueOf(orderInfos.size()));
        rspBO.setApplyBranch(notification.getOperNo());
        String orgNameStr = this.organizationInfoService.queryOrgName(rspBO.getApplyBranch());
        rspBO.setApplyBranchName(orgNameStr);
        rspBO.setInvoiceTitle(notification.getInvoceName());
        rspBO.setInvoiceType(notification.getInvoceType());
        rspBO.setTaxId(notification.getTaxNo());
        rspBO.setCompanyAddr(notification.getAddr());
        rspBO.setPhone(notification.getPhone());
        rspBO.setOpenBankName(notification.getBankName());
        rspBO.setBankAcctNo(notification.getBankAccNo());
        rspBO.setMailAddr(notification.getAddrDesc());
        if (OrderSource.CONSULT_PRICE.getCode().equals(notification.getSource()) || OrderSource.CONSULT_PRICE_FRAME.getCode().equals(notification.getSource())) {
            rspBO.setMailPhone(notification.getTel());
        } else {
            rspBO.setMailPhone(notification.getMobile());
        }
        rspBO.setMailReciever(notification.getName());
        rspBO.setRows(this.moveOrderInfosToVO(orderInfos, reqBO.getNotificationNo()));
        rspBO.setRecordsTotal(page.getTotalCount());
        rspBO.setTotal(page.getTotalPages());
        rspBO.setPageNo(page.getPageNo());
        return rspBO;
    }

    public BusiQryNtfDetailPart2DlzqRspBO qryNotifyDetailPart2Dlzq(BusiQryNotificationDetailReqBO reqBO) {
        if (logger.isDebugEnabled()) {
            logger.debug("\u67e5\u8be2\u5f00\u7968\u901a\u77e5\u8be6\u60c5\u4e1a\u52a1\u670d\u52a1\u7b2c\u4e8c\u90e8\u5206-\u7535\u529b\u4e13\u533a\u5165\u53c2\uff1a" + reqBO.toString());
        }
        if (null == reqBO.getNotificationNo()) {
            throw new BusinessException("0001", "\u67e5\u8be2\u5f00\u7968\u901a\u77e5\u8be6\u60c5\u4e1a\u52a1\u670d\u52a1-\u5f00\u7968\u901a\u77e5\u5355\u53f7[notificationNo]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        BillNotificationInfo notification = new BillNotificationInfo();
        try {
            notification = this.billNotificationInfoMapper.selectByPrimaryKey(reqBO.getNotificationNo());
        }
        catch (Exception e) {
            logger.error("\u67e5\u8be2\u5f00\u7968\u901a\u77e5\u5355\u5217\u8868-\u901a\u77e5\u5355\u53f7\u5165\u53c2\uff1a" + reqBO.getNotificationNo(), (Throwable)e);
            throw new BusinessException("18000", "\u67e5\u8be2\u5f00\u7968\u901a\u77e5\u5217\u8868-\u6570\u636e\u5e93\u64cd\u4f5c\u9519\u8bef");
        }
        if (null == notification) {
            logger.info("billNotificationInfoMapper.selectByPrimaryKey\u67e5\u8be2\u8fd4\u56de\u4e3a\u7a7a,\u5165\u53c2\uff1a" + reqBO.getNotificationNo());
            throw new BusinessException("18001", "\u5f00\u7968\u901a\u77e5\u5355\u53f7\uff1a" + reqBO.getNotificationNo() + "\u6ca1\u6709\u901a\u77e5\u5355\u8bb0\u5f55");
        }
        String orderBy = null;
        if (!StringUtils.isEmpty((CharSequence)reqBO.getSortName()) && !StringUtils.isEmpty((CharSequence)reqBO.getSortOrder())) {
            if (AntiSqlInjectionManage.sqlValidate(reqBO.getSortName()) || AntiSqlInjectionManage.sqlValidate(reqBO.getSortOrder())) {
                logger.error("\u60a8\u53d1\u9001\u8bf7\u6c42\u4e2d\u7684\u53c2\u6570\u4e2d\u542b\u6709\u975e\u6cd5\u5b57\u7b26");
                throw new BusinessException("18000", "\u60a8\u53d1\u9001\u8bf7\u6c42\u4e2d\u7684\u53c2\u6570\u4e2d\u542b\u6709\u975e\u6cd5\u5b57\u7b26");
            }
            orderBy = reqBO.getSortName() + " " + reqBO.getSortOrder();
        }
        Page page = new Page(reqBO.getPageNo(), reqBO.getPageSize());
        List<Object> invoiceList = new LinkedList();
        try {
            invoiceList = this.payInvoiceInfoMapper.getListPageByNotifNo(reqBO.getNotificationNo(), (Page<Map<String, Object>>)page, orderBy);
        }
        catch (Exception e) {
            logger.info("payInvoiceInfoMapper.selectByNotifyNo\u67e5\u8be2\u8fd4\u56de\u4e3a\u7a7a,\u5165\u53c2\uff1a" + reqBO.getNotificationNo(), (Throwable)e);
            throw new BusinessException("18001", "\u5f00\u7968\u901a\u77e5\u5355\u53f7\uff0c\u67e5\u8be2\u53d1\u7968\u4fe1\u606f\uff0c\u6570\u636e\u5e93\u64cd\u4f5c\u5931\u8d25");
        }
        BusiQryNtfDetailPart2DlzqRspBO rspBO = new BusiQryNtfDetailPart2DlzqRspBO();
        if (invoiceList.isEmpty()) {
            logger.info("payInvoiceInfoMapper.selectByNotifyNo\u67e5\u8be2\u8fd4\u56de\u4e3a\u7a7a,\u5165\u53c2\uff1a" + reqBO.getNotificationNo());
            return rspBO;
        }
        LinkedList<InvoiceInfoVO> invoices = new LinkedList<InvoiceInfoVO>();
        for (PayInvoiceInfo payInvoiceInfo : invoiceList) {
            InvoiceInfoVO invoiceInfo = new InvoiceInfoVO();
            BeanUtils.copyProperties((Object)payInvoiceInfo, (Object)invoiceInfo);
            InvoiceType invoiceTypeEnum = InvoiceType.getInstance(invoiceInfo.getInvoiceType());
            invoiceInfo.setInvoiceTypeStr(this.enumsService.getDescr(invoiceTypeEnum));
            List<Object> invoiceDetails = new LinkedList();
            try {
                invoiceDetails = this.payInvoiceDetailMapper.selectByInvoiceListPK(invoiceInfo.getInvoiceCode(), invoiceInfo.getInvoiceNo(), invoiceInfo.getInvoiceDate());
            }
            catch (Exception e) {
                logger.info("payInvoiceDetailMapper.getPageByInvoiceListPK\u67e5\u8be2\u51fa\u9519,\u5165\u53c2\uff1a" + payInvoiceInfo.getInvoiceCode() + "," + payInvoiceInfo.getInvoiceNo() + "," + payInvoiceInfo.getInvoiceDate(), (Throwable)e);
                throw new BusinessException("18001", "\u5f00\u7968\u901a\u77e5\u5355\u53f7\uff0c\u67e5\u8be2\u53d1\u7968\u8be6\u60c5\u4fe1\u606f\uff0c\u6570\u636e\u5e93\u64cd\u4f5c\u5931\u8d25");
            }
            if (invoiceDetails.isEmpty()) {
                logger.info("payInvoiceInfoMapper.selectByNotifyNo\u67e5\u8be2\u8fd4\u56de\u4e3a\u7a7a,\u5165\u53c2\uff1a" + payInvoiceInfo.getInvoiceCode() + "," + payInvoiceInfo.getInvoiceNo() + "," + payInvoiceInfo.getInvoiceDate());
                return rspBO;
            }
            LinkedList<InvoiceDetailVO> detailsOut = new LinkedList<InvoiceDetailVO>();
            for (PayInvoiceDetail payInvoiceDetail : invoiceDetails) {
                InvoiceDetailVO invoiceDetailOut = new InvoiceDetailVO();
                BeanUtils.copyProperties((Object)payInvoiceDetail, (Object)invoiceDetailOut);
                detailsOut.add(invoiceDetailOut);
            }
            invoiceInfo.setInvoiceDetails(detailsOut);
            invoices.add(invoiceInfo);
        }
        rspBO.setRows(invoices);
        rspBO.setRecordsTotal(page.getTotalCount());
        rspBO.setTotal(page.getTotalPages());
        rspBO.setPageNo(page.getPageNo());
        return rspBO;
    }

    private List<OrderInfoVO> moveOrderInfosToVO(List<PayPurchaseOrderInfo> orderInfos, String notificationNo) {
        LinkedList<OrderInfoVO> infos = new LinkedList<OrderInfoVO>();
        for (PayPurchaseOrderInfo singleInfo : orderInfos) {
            OrderInfoVO singleVO = new OrderInfoVO();
            singleVO.setSupplierNo(singleInfo.getSupplierNo());
            String supplierStr = this.organizationInfoService.querySupplierName(singleVO.getSupplierNo());
            singleVO.setSupplierName(supplierStr);
            singleVO.setConfirmDate(singleInfo.getRecvDate());
            singleVO.setInspectionId(String.valueOf(singleInfo.getInspectionId()));
            singleVO.setLastConfirmDate(singleInfo.getRecvDate());
            singleVO.setOrderAmt(singleInfo.getOrderAmt());
            singleVO.setOrderCreateDate(singleInfo.getOrderDate());
            singleVO.setOrderCreator(singleInfo.getPurchaserName());
            singleVO.setOrderId(String.valueOf(singleInfo.getOrderId()));
            singleVO.setPurchaseOrderCode(singleInfo.getPurchaseOrderCode());
            singleVO.setPurchaseOrderName(singleInfo.getPurchaseOrderName());
            singleVO.setOrderStatus(singleInfo.getOrderStatus());
            OrderStatus orderStatusEnum = OrderStatus.getInstance(singleVO.getOrderStatus());
            singleVO.setOrderStatusStr(this.enumsService.getDescr(orderStatusEnum));
            singleVO.setOrderType(singleInfo.getOrderType());
            singleVO.setPurchaseNo(singleInfo.getPurchaseNo());
            String purchaserName = this.organizationInfoService.queryOrgName(singleVO.getPurchaseNo());
            singleVO.setPurchaserName(purchaserName);
            List<Object> itemInfos = new LinkedList();
            try {
                itemInfos = this.payItemInfoMapper.selectByNtfNoAndOrderIdAndInspId(notificationNo, singleInfo.getOrderId(), singleInfo.getInspectionId());
            }
            catch (Exception e) {
                throw new BusinessException("18000", "\u67e5\u8be2\u5f00\u7968\u901a\u77e5\u8be6\u60c5\u4e1a\u52a1\u670d\u52a1-\u91c7\u8d2d\u5546\u54c1\u8868 \u6570\u636e\u5e93\u64cd\u4f5c\u9519\u8bef", (Throwable)e);
            }
            if (itemInfos.isEmpty()) {
                throw new BusinessException("18000", "\u901a\u77e5\u5355\u53f7\uff1a" + notificationNo + ",\u8ba2\u5355\u7f16\u53f7\uff1a" + singleInfo.getOrderId() + ",\u67e5\u8be2\u5f00\u7968\u901a\u77e5\u8be6\u60c5\u4e1a\u52a1\u670d\u52a1-\u91c7\u8d2d\u5546\u54c1\u8868 \u67e5\u8be2\u8fd4\u56de\u7ed3\u679c\u4e3a\u7a7a");
            }
            LinkedList<OrderItemVO> itemVOs = new LinkedList<OrderItemVO>();
            for (PayItemInfo payItemInfo : itemInfos) {
                OrderItemVO vo = new OrderItemVO();
                vo.setItemName(payItemInfo.getItemName());
                vo.setSpec(payItemInfo.getSpec());
                vo.setModel(payItemInfo.getModel());
                vo.setUnit(payItemInfo.getUnitName());
                vo.setUnitId(payItemInfo.getUnitId());
                vo.setQuantity(payItemInfo.getQuantity());
                vo.setSalePrice(payItemInfo.getPurchaseUnitPrice());
                vo.setSumTaxPrice(payItemInfo.getUntaxAmt().add(payItemInfo.getTaxAmt()));
                vo.setTotalAmt(payItemInfo.getAmount());
                vo.setSkuId(payItemInfo.getSkuId());
                itemVOs.add(vo);
            }
            singleVO.setItemList(itemVOs);
            infos.add(singleVO);
        }
        return infos;
    }
}

