/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.settle.busi.impl;

import com.ohaotian.plugin.base.exception.BusinessException;
import com.ohaotian.plugin.db.Page;
import com.tydic.fsc.settle.atom.EnumsService;
import com.tydic.fsc.settle.atom.OrganizationInfoService;
import com.tydic.fsc.settle.busi.api.BusiQueryDetailDistributeRecAmtConfirmService;
import com.tydic.fsc.settle.busi.api.bo.BusiQueryDetailDistributeRecAmtConfirmReqBO;
import com.tydic.fsc.settle.busi.api.bo.BusiQueryDetailDistributeRecAmtConfirmRspBO;
import com.tydic.fsc.settle.busi.api.bo.BusiQueryDetailHeadDistributeRecAmtConfirmRspBO;
import com.tydic.fsc.settle.busi.api.bo.BusiQueryDetailListDistributeRecAmtConfirmRspBO;
import com.tydic.fsc.settle.dao.AdvanceReceiveMapper;
import com.tydic.fsc.settle.dao.RecAmtConfirmMapper;
import com.tydic.fsc.settle.dao.RecvAmtDetailMapper;
import com.tydic.fsc.settle.dao.SaleOrderInfoMapper;
import com.tydic.fsc.settle.dao.po.AdvanceReceive;
import com.tydic.fsc.settle.dao.po.RecAmtConfirm;
import com.tydic.fsc.settle.dao.po.RecvAmtDetail;
import com.tydic.fsc.settle.dao.po.SaleOrderInfo;
import com.tydic.fsc.settle.dao.vo.AdvanceReceiveVO;
import com.tydic.fsc.settle.dao.vo.RecvAmtDetailVO;
import com.tydic.fsc.settle.enums.AdvanceReceiveStatus;
import com.tydic.fsc.settle.enums.BaseEnums;
import com.tydic.fsc.settle.enums.OrderSource;
import com.tydic.fsc.settle.enums.ReceiveType;
import com.tydic.fsc.settle.utils.FileUtils;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

@Service
public class BusiQueryDetailDistributeRecAmtConfirmServiceImpl
implements BusiQueryDetailDistributeRecAmtConfirmService {
    private static final Logger logger = LoggerFactory.getLogger(BusiQueryDetailDistributeRecAmtConfirmServiceImpl.class);
    @Autowired
    private OrganizationInfoService organizationInfoService;
    @Autowired
    private EnumsService enumsService;
    @Autowired
    private RecAmtConfirmMapper recAmtConfirmMapper;
    @Autowired
    private AdvanceReceiveMapper advanceReceiveMapper;
    @Autowired
    private RecvAmtDetailMapper recvAmtDetailMapper;
    @Autowired
    private SaleOrderInfoMapper saleOrderInfoMapper;

    public BusiQueryDetailDistributeRecAmtConfirmRspBO queryDetailDistributeRecAmtConfirm(BusiQueryDetailDistributeRecAmtConfirmReqBO reqBO) {
        if (logger.isDebugEnabled()) {
            logger.debug("\u67e5\u8be2\u914d\u9001\u4e1a\u52a1\u6536\u6b3e\u786e\u8ba4\u5355\u8be6\u60c5\u670d\u52a1\u5165\u53c2\uff1a" + reqBO);
        }
        if (reqBO == null) {
            throw new BusinessException("0001", "\u5165\u53c2\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (reqBO.getDocNum() == null) {
            throw new BusinessException("0001", "\u5355\u636e\u7f16\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
        }
        RecAmtConfirm recAmtConfirm = this.recAmtConfirmMapper.selectByPrimaryKey(reqBO.getDocNum());
        AdvanceReceiveVO advanceReceiveVO = new AdvanceReceiveVO();
        BeanUtils.copyProperties((Object)reqBO, (Object)advanceReceiveVO);
        advanceReceiveVO.setOrderBy("tt.SEQ desc");
        Page page = new Page(reqBO.getPageNo(), reqBO.getPageSize());
        List<AdvanceReceive> rows = this.advanceReceiveMapper.selectListPageDlzq(advanceReceiveVO, (Page<Map<String, Object>>)page);
        BusiQueryDetailDistributeRecAmtConfirmRspBO rspBO = new BusiQueryDetailDistributeRecAmtConfirmRspBO();
        BusiQueryDetailHeadDistributeRecAmtConfirmRspBO head = new BusiQueryDetailHeadDistributeRecAmtConfirmRspBO();
        rspBO.setHead(head);
        ArrayList<BusiQueryDetailListDistributeRecAmtConfirmRspBO> detailRows = new ArrayList<BusiQueryDetailListDistributeRecAmtConfirmRspBO>();
        rspBO.setRows(detailRows);
        rspBO.setRecordsTotal(page.getTotalCount());
        rspBO.setTotal(page.getTotalPages());
        rspBO.setPageNo(page.getPageNo());
        BeanUtils.copyProperties((Object)recAmtConfirm, (Object)head);
        head.setDocNum(String.valueOf(recAmtConfirm.getDocNum()));
        String orgName = this.organizationInfoService.queryOrgName(recAmtConfirm.getOrgId());
        head.setOrgName(orgName);
        for (AdvanceReceive row : rows) {
            BusiQueryDetailListDistributeRecAmtConfirmRspBO detail = new BusiQueryDetailListDistributeRecAmtConfirmRspBO();
            BeanUtils.copyProperties((Object)row, (Object)detail);
            detail.setPayOrgName(this.organizationInfoService.obtainOrgNameByAdvanceReceive(row));
            orgName = this.organizationInfoService.queryOrgName(row.getRecOrgId());
            detail.setRecOrgName(orgName);
            detail.setRecTypeDescr(this.enumsService.getDescr(ReceiveType.getInstance(row.getRecType())));
            detail.setStatusDescr(this.enumsService.getDescr(AdvanceReceiveStatus.getInstance(row.getStatus())));
            detail.setSourceName(this.enumsService.getDescr((BaseEnums)OrderSource.getInstance((String)row.getSource())));
            detail.setToReceiveAmt(detail.getTranAmt().subtract(detail.getWriteoffAmt()));
            RecvAmtDetailVO recvAmtDetailVO = new RecvAmtDetailVO();
            recvAmtDetailVO.setDocNum(recAmtConfirm.getDocNum());
            recvAmtDetailVO.setAdvRecvSeq(row.getSeq());
            RecvAmtDetailVO queryAmtDetailVO = this.recvAmtDetailMapper.selectSum2(recvAmtDetailVO);
            detail.setAllTheAmount(queryAmtDetailVO.getAmount());
            List<RecvAmtDetail> recvAmtDetailList = this.recvAmtDetailMapper.getList(recvAmtDetailVO);
            StringBuffer allSaleOrderCode = new StringBuffer();
            StringBuffer allSaleOrderName = new StringBuffer();
            StringBuffer allOrderDate = new StringBuffer();
            StringBuffer allSupplierName = new StringBuffer();
            StringBuffer allOrderAmt = new StringBuffer();
            StringBuffer allPurchaseName = new StringBuffer();
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            for (RecvAmtDetail recvAmtDetail : recvAmtDetailList) {
                SaleOrderInfo saleOrder = this.saleOrderInfoMapper.getModelByPrimaryKey(recvAmtDetail.getOrderId(), recvAmtDetail.getInspectionId());
                if (saleOrder == null) {
                    throw new BusinessException("0001", "\u901a\u8fc7\u9a8c\u6536\u5355\u53f7[" + recvAmtDetail.getInspectionId() + "]\u548c\u9500\u552e\u8ba2\u5355ID[" + recvAmtDetail.getOrderId() + "]\u627e\u4e0d\u5230\u9500\u552e\u8ba2\u5355");
                }
                if (StringUtils.hasText((String)saleOrder.getSaleOrderCode())) {
                    allSaleOrderCode.append(saleOrder.getSaleOrderCode()).append(",");
                }
                if (StringUtils.hasText((String)saleOrder.getSaleOrderName())) {
                    allSaleOrderName.append(saleOrder.getSaleOrderName()).append(",");
                }
                if (null != saleOrder.getOrderDate()) {
                    try {
                        String orderDateStr = sdf.format(saleOrder.getOrderDate());
                        allOrderDate.append(orderDateStr).append(",");
                    }
                    catch (Exception e) {
                        logger.error("\u65e5\u671f\u8f6c\u6362\u5f02\u5e38", (Throwable)e);
                    }
                }
                if (StringUtils.hasText((String)saleOrder.getSupplierName())) {
                    allSupplierName.append(saleOrder.getSupplierName()).append(",");
                }
                if (null != saleOrder.getOrderAmt()) {
                    allOrderAmt.append(saleOrder.getOrderAmt()).append(",");
                }
                if (!StringUtils.hasText((String)saleOrder.getPurchaseName())) continue;
                allPurchaseName.append(saleOrder.getPurchaseName()).append(",");
            }
            detail.setAllSaleOrderCode(this.getProcessVal(allSaleOrderCode));
            detail.setAllSaleOrderName(this.getProcessVal(allSaleOrderName));
            detail.setAllOrderDate(this.getProcessVal(allOrderDate));
            detail.setAllSupplierName(this.getProcessVal(allSupplierName));
            detail.setAllOrderAmt(this.getProcessVal(allOrderAmt));
            detail.setAllPurchaseName(this.getProcessVal(allPurchaseName));
            detail.setReceiptUrl(FileUtils.obtainOSSUrl(detail.getReceipt()));
            detail.setAllWriteoffAmt(row.getWriteoffAmt());
            detail.setAllToWriteoffAmt(row.getTranAmt().subtract(row.getWriteoffAmt()));
            detailRows.add(detail);
        }
        return rspBO;
    }

    private String getProcessVal(StringBuffer sb) {
        String val = "";
        if (null != sb) {
            val = sb.length() >= 1 ? sb.toString().substring(0, sb.length() - 1) : "";
        }
        return val;
    }
}

