/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.settle.busi.impl;

import com.ohaotian.plugin.base.exception.BusinessException;
import com.tydic.fsc.settle.busi.api.DzcsInvoiceReturnSumUpService;
import com.tydic.fsc.settle.busi.api.bo.DzcsInvoiceReturnSumUpReqBO;
import com.tydic.fsc.settle.busi.api.bo.DzcsInvoiceReturnSumUpRspBO;
import com.tydic.fsc.settle.dao.InvoiceReturnDetailMapper;
import com.tydic.fsc.settle.dao.InvoiceReturnMapper;
import com.tydic.fsc.settle.dao.SaleInvoiceInfoMapper;
import com.tydic.fsc.settle.dao.po.InvoiceReturn;
import com.tydic.fsc.settle.dao.po.InvoiceReturnDetail;
import com.tydic.fsc.settle.dao.po.SaleInvoiceInfo;
import com.tydic.fsc.settle.dao.vo.InvoiceReturnDetailVO;
import com.tydic.fsc.settle.dao.vo.SaleInvoiceInfoVO;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

@Service
public class DzcsInvoiceReturnSumUpServiceImpl
implements DzcsInvoiceReturnSumUpService {
    private static final Logger logger = LoggerFactory.getLogger(DzcsInvoiceReturnSumUpServiceImpl.class);
    @Autowired
    private InvoiceReturnMapper invoiceReturnMapper;
    @Autowired
    private InvoiceReturnDetailMapper invoiceReturnDetailMapper;
    @Autowired
    private SaleInvoiceInfoMapper saleInvoiceInfoMapper;

    public DzcsInvoiceReturnSumUpRspBO query(DzcsInvoiceReturnSumUpReqBO reqBO) {
        String billNo;
        if (logger.isDebugEnabled()) {
            logger.debug("\u5408\u8ba1\u91d1\u989d\u670d\u52a1\uff08\u7535\u5b50\u8d85\u5e02\u9000\u7968\uff09\u5165\u53c2\uff1a" + reqBO);
        }
        if (!StringUtils.hasText((String)(billNo = reqBO.getBillNo()))) {
            throw new BusinessException("0001", "\u9000\u7968\u7533\u8bf7\u5355\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
        }
        InvoiceReturn invoiceReturn = this.invoiceReturnMapper.selectByPrimaryKey(billNo);
        InvoiceReturnDetailVO vo = new InvoiceReturnDetailVO();
        vo.setBillNo(billNo);
        List<InvoiceReturnDetail> details = this.invoiceReturnDetailMapper.selectList(vo);
        ArrayList<String> invoiceNo1s = new ArrayList<String>();
        for (InvoiceReturnDetail detail : details) {
            invoiceNo1s.add(detail.getInvoiceNo1());
        }
        SaleInvoiceInfoVO saleInvoiceInfoVO = new SaleInvoiceInfoVO();
        saleInvoiceInfoVO.setInvoiceNoList(invoiceNo1s);
        List<SaleInvoiceInfo> invoices = this.saleInvoiceInfoMapper.selectBy(saleInvoiceInfoVO);
        BigDecimal totalAmt = BigDecimal.ZERO;
        for (SaleInvoiceInfo invoice : invoices) {
            totalAmt = totalAmt.add(invoice.getAmt());
        }
        DzcsInvoiceReturnSumUpRspBO rspBO = new DzcsInvoiceReturnSumUpRspBO();
        rspBO.setAccountId(invoiceReturn.getPurchaseProjectId());
        rspBO.setRecordsTotal(Integer.valueOf(invoices.size()));
        rspBO.setTotalAmt(totalAmt);
        return rspBO;
    }
}

