/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.settle.busi.impl;

import com.ohaotian.plugin.base.exception.BusinessException;
import com.tydic.fsc.settle.atom.OrganizationInfoService;
import com.tydic.fsc.settle.busi.api.PayLoadTradeServiceFeeInfoService;
import com.tydic.fsc.settle.busi.api.bo.PayLoadTradeServiceFeeInfoReqBO;
import com.tydic.fsc.settle.busi.api.bo.PayLoadTradeServiceFeeInfoRspBO;
import com.tydic.fsc.settle.dao.InquiryPayOrderMapper;
import com.tydic.fsc.settle.dao.po.InquiryPayOrder;
import com.tydic.fsc.settle.dao.po.InquiryPayOrderExt;
import com.tydic.fsc.settle.enums.InquiryB2BBANK;
import com.tydic.fsc.settle.enums.InquiryB2CBANK;
import com.tydic.fsc.settle.enums.InquiryCriticalValue;
import com.tydic.fsc.settle.enums.InquiryPayFeeType;
import com.tydic.fsc.settle.enums.InquiryPayPass;
import com.tydic.fsc.settle.enums.InquiryPaymentStatus;
import java.math.BigDecimal;
import java.util.LinkedList;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class PayLoadTradeServiceFeeInfoServiceImpl
implements PayLoadTradeServiceFeeInfoService {
    @Autowired
    private InquiryPayOrderMapper inquiryPayOrderMapper;
    @Autowired
    private OrganizationInfoService organizationInfoService;

    public PayLoadTradeServiceFeeInfoRspBO loadTradeServiceFeeInfo(PayLoadTradeServiceFeeInfoReqBO reqBO) {
        PayLoadTradeServiceFeeInfoRspBO rspBO = new PayLoadTradeServiceFeeInfoRspBO();
        if (null == reqBO.getPayOrderNo()) {
            throw new BusinessException("0001", "\u7f34\u8d39\u8ba2\u5355\u53f7[payOrderNo]\u4e3a\u7a7a");
        }
        InquiryPayOrderExt payOrderInfoExt = new InquiryPayOrderExt();
        payOrderInfoExt.setPayFeeType(InquiryPayFeeType.TRADE_SERVICE_FEE.getCode());
        payOrderInfoExt.setPayOrderNo(reqBO.getPayOrderNo());
        InquiryPayOrder payOrderInfo = this.inquiryPayOrderMapper.selectByPrimaryKey(payOrderInfoExt);
        if (null == payOrderInfo || InquiryPaymentStatus.ALREADY_PAID.getCode().equals(payOrderInfo.getPaymentStatus()) || InquiryPaymentStatus.TERMINATED.getCode().equals(payOrderInfo.getPaymentStatus()) || InquiryPaymentStatus.REC_CONFIRMED.getCode().equals(payOrderInfo.getPaymentStatus()) || InquiryPaymentStatus.OFFLINE_PAID.getCode().equals(payOrderInfo.getPaymentStatus())) {
            throw new BusinessException("18000", "\u6240\u9009\u8ba2\u5355\u4e0d\u53ef\u8fdb\u884c\u7f34\u8d39\u64cd\u4f5c");
        }
        if (BigDecimal.ZERO.equals(payOrderInfo.getPayMoney())) {
            throw new BusinessException("18000", "\u8ba2\u5355\u9700\u7f34\u8d39\u91d1\u989d\u4e3a0\uff0c\u65e0\u9700\u7f34\u8d39");
        }
        rspBO.setInquiryNo(payOrderInfo.getInquiryNo());
        rspBO.setPayMoney(payOrderInfo.getPayMoney());
        String supplierName = this.organizationInfoService.querySupplierName(payOrderInfo.getSupplierId());
        rspBO.setSupplierName(supplierName);
        rspBO.setOrderTotalMoney(payOrderInfo.getOrderTotalMoney());
        rspBO.setPayFlag(payOrderInfo.getPayFlag());
        rspBO.setPaymentStatus(payOrderInfo.getPaymentStatus());
        double money = Double.parseDouble(InquiryCriticalValue.CRITICAL_MONEY.getCode());
        double payMoney = rspBO.getPayMoney().doubleValue();
        if (money >= payMoney) {
            rspBO.setDefaultPass(InquiryPayPass.B2CBANK.getCode());
        } else {
            rspBO.setDefaultPass(InquiryPayPass.B2BBANK.getCode());
        }
        LinkedList<String> b2cBankList = new LinkedList<String>();
        for (InquiryB2CBANK e : InquiryB2CBANK.values()) {
            b2cBankList.add(e.toString());
        }
        rspBO.setB2cBankList(b2cBankList);
        LinkedList<String> b2bBankList = new LinkedList<String>();
        for (InquiryB2BBANK e : InquiryB2BBANK.values()) {
            b2bBankList.add(e.toString());
        }
        rspBO.setB2bBankList(b2bBankList);
        return rspBO;
    }
}

