/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.supplier.impl;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.ohaotian.plugin.base.exception.BusinessException;
import com.tydic.fsc.supplier.BusiGetInvoiceDataService;
import com.tydic.fsc.supplier.bo.BusiGetInvoiceDataRspVO;
import com.tydic.fsc.supplier.bo.BusiGetInvoiceDataServiceReqBO;
import com.tydic.fsc.supplier.bo.BusiGetInvoiceDataServiceRspBO;
import com.tydic.fsc.supplier.utils.ESBParamUtil;
import com.tydic.fsc.supplier.utils.http.HSHttpHelper;
import com.tydic.fsc.supplier.utils.http.HSNHttpHeader;
import com.tydic.fsc.supplier.utils.http.HttpRetBean;
import java.net.URI;
import java.util.ArrayList;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

@Service
public class BusiGetInvoiceDataServiceImpl
implements BusiGetInvoiceDataService {
    private static final Log log = LogFactory.getLog(BusiGetInvoiceDataServiceImpl.class);
    @Autowired
    @Qualifier(value="fscSupplierPropertyConfigurer")
    private Properties prop;

    public BusiGetInvoiceDataServiceRspBO getInvoiceData(BusiGetInvoiceDataServiceReqBO reqBO) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("\u83b7\u53d6\u53d1\u7968\u6570\u636e\u4e1a\u52a1\u670d\u52a1\u7684\u5b9e\u73b0\u5165\u53c2\uff1a" + reqBO.toString()));
        }
        if (null == reqBO.getIdMap() || reqBO.getIdMap().isEmpty()) {
            log.error((Object)"\u7b2c\u4e09\u65b9\u63a5\u53e3\u83b7\u53d6\u5f00\u7968\u6570\u636e\u63a5\u53e3\u4e1a\u52a1\u670d\u52a1---->\u53d1\u7968\u552f\u4e00\u6807\u5fd7Id\u548c\u4f9b\u5e94\u5546Id\u6784\u6210\u7684Map\u4e0d\u80fd\u4e3a\u7a7a");
        }
        BusiGetInvoiceDataServiceRspBO rspBO = new BusiGetInvoiceDataServiceRspBO();
        ArrayList list = new ArrayList();
        rspBO.setDataList(list);
        Map dataMap = reqBO.getIdMap();
        for (Map.Entry entry : dataMap.entrySet()) {
            HttpRetBean httpRetBean;
            String markId = (String)entry.getKey();
            String suppliedId = (String)entry.getValue();
            String reqStr = this.initReqStr(markId);
            String hsn = this.prop.getProperty("SUPPLIER_ID_" + suppliedId);
            String reqEsbStr = ESBParamUtil.getEsbReqStr(reqStr, hsn, "BUSINESS_PAY");
            log.info((Object)("\u7b2c\u4e09\u65b9\u63a5\u53e3\u83b7\u53d6\u5f00\u7968\u6570\u636e\u63a5\u53e3\u4e1a\u52a1\u670d\u52a1--->\u83b7\u53d6\u53d1\u7968\u6570\u636e\u670d\u52a1\u5b9e\u73b0\u7c7b--\u8bf7\u6c42\u80fd\u529b\u5e73\u53f0\u62a5\u6587:" + reqEsbStr));
            try {
                httpRetBean = HSHttpHelper.doUrlPostRequest(new URI(this.prop.getProperty("ESB_INVOICE_QUERY_JD_URL")), HSNHttpHeader.getRequestHeaders("json"), reqEsbStr.toString().getBytes("UTF-8"), "UTF-8", false);
            }
            catch (Exception e) {
                log.error((Object)("\u7b2c\u4e09\u65b9\u63a5\u53e3\u83b7\u53d6\u5f00\u7968\u6570\u636e\u63a5\u53e3\u4e1a\u52a1\u670d\u52a1--->\u8c03\u7528\u83b7\u53d6\u53d1\u7968\u6570\u636e\u63a5\u53e3\u5931\u8d25,\u5f00\u7968\u901a\u77e5\u7f16\u53f7\u4e3a" + markId + "\u4f9b\u5e94\u5546Id\u4e3a\uff1a" + suppliedId), (Throwable)e);
                throw new BusinessException("RSP_CODE_CALL_THIRD_SERVICE", "\u8c03\u7528\u83b7\u53d6\u53d1\u7968\u6570\u636e\u63a5\u53e3\u5931\u8d25");
            }
            if (httpRetBean.getStatus() != 200) {
                log.error((Object)("\u8c03\u7528\u83b7\u53d6\u53d1\u7968\u6570\u636e\u63a5\u53e3\u4e0b\u53d1\u7cfb\u7edf\u5931\u8d25[http_status=" + httpRetBean.getStatus() + "], [http_url=" + this.prop.getProperty("ESB_INVOICE_APPLY_JD_URL") + "]"));
                throw new RuntimeException("\u8c03\u7528\u83b7\u53d6\u53d1\u7968\u6570\u636e\u63a5\u53e3\u4e0b\u53d1\u7cfb\u7edf\u5931\u8d25");
            }
            log.info((Object)("\u8c03\u7528\u83b7\u53d6\u53d1\u7968\u6570\u636e\u63a5\u53e3\u4e0b\u53d1\u7cfb\u7edf\u54cd\u5e94\u62a5\u6587\uff1a" + httpRetBean.getStr()));
            String returnString = httpRetBean.getStr();
            if (StringUtils.isEmpty((Object)returnString)) {
                log.info((Object)"\u8c03\u7528\u83b7\u53d6\u53d1\u7968\u6570\u636e\u63a5\u53e3\u4e0b\u53d1\u7cfb\u7edf\u54cd\u5e94\u62a5\u6587\u4e3a\u7a7a\uff01");
                throw new RuntimeException("\u8c03\u7528\u83b7\u53d6\u53d1\u7968\u6570\u636e\u63a5\u53e3\u4e0b\u53d1\u7cfb\u7edf\u54cd\u5e94\u62a5\u6587\u4e3a\u7a7a\uff01");
            }
            BusiGetInvoiceDataRspVO rspVO = new BusiGetInvoiceDataRspVO();
            rspVO.setNotificationNo(markId);
            rspVO.setSupplierNo(suppliedId);
            rspVO.setSupplierCode(hsn);
            this.resolveRsp(returnString, rspBO, rspVO);
        }
        return rspBO;
    }

    private String initReqStr(String markId) {
        StringBuffer sb = new StringBuffer();
        sb.append("{").append("\"markId\":").append("\"" + markId + "\"").append("}");
        return sb.toString();
    }

    private void resolveRsp(String returnString, BusiGetInvoiceDataServiceRspBO rspBO, BusiGetInvoiceDataRspVO rspVO) {
        JSONObject rspJsonObject;
        String supInfo = rspVO.getSupplierNo() + "(" + rspVO.getSupplierCode() + ")";
        log.debug((Object)("--\u63a5\u53e3\u8fd4\u56de\u7684\u62a5\u6587:" + returnString));
        try {
            rspJsonObject = JSONObject.parseObject((String)returnString);
        }
        catch (Exception e) {
            log.error((Object)("\u7b2c\u4e09\u65b9\u63a5\u53e3\u83b7\u53d6\u5f00\u7968\u6570\u636e\u63a5\u53e3---->\u89e3\u6790\u54cd\u5e94\u62a5\u6587\u51fa\u9519,sup=" + supInfo + " json:" + returnString), (Throwable)e);
            throw new BusinessException("RSP_CODE_BUSI_SERVICE_ERROR", "\u89e3\u6790\u54cd\u5e94\u62a5\u6587\u51fa\u9519");
        }
        String resultCode = (String)rspJsonObject.get((Object)"resultCode");
        if (null == resultCode) {
            log.error((Object)("\u7b2c\u4e09\u65b9\u63a5\u53e3\u83b7\u53d6\u5f00\u7968\u6570\u636e\u63a5\u53e3\u4e1a\u52a1\u670d\u52a1---->\u8fd4\u56de\u54cd\u5e94\u62a5\u6587\u51fa\u9519,\u7f3a\u5c11resultCode,sup=" + supInfo));
            throw new BusinessException("RSP_CODE_BUSI_SERVICE_ERROR", "\u7b2c\u4e09\u65b9\u63a5\u53e3\u83b7\u53d6\u5f00\u7968\u6570\u636e\u63a5\u53e3\u4e1a\u52a1\u670d\u52a1---->\u8fd4\u56de\u54cd\u5e94\u62a5\u6587\u51fa\u9519,\u7f3a\u5c11resultCode");
        }
        if (resultCode.equals("0004") || resultCode.equals("0005")) {
            JSONArray resultArray = null;
            try {
                resultArray = JSONObject.parseArray((String)rspJsonObject.getString("result"));
            }
            catch (Exception e) {
                log.error((Object)("\u7b2c\u4e09\u65b9\u63a5\u53e3\u83b7\u53d6\u5f00\u7968\u6570\u636e\u63a5\u53e3\u4e1a\u52a1\u670d\u52a1---->\u89e3\u6790\u54cd\u5e94\u62a5\u6587\u83b7\u53d6\u8fd4\u56de\u5f00\u7968\u4fe1\u606f\u9519\u8bef,sup=" + supInfo), (Throwable)e);
                throw new BusinessException("RSP_CODE_BUSI_SERVICE_ERROR", "\u83b7\u53d6\u5f00\u7968\u6570\u636e\u63a5\u53e3---->\u89e3\u6790\u54cd\u5e94\u62a5\u6587\u83b7\u53d6\u8fd4\u56de\u5f00\u7968\u4fe1\u606f\u9519\u8bef");
            }
            for (int i = 0; i < resultArray.size(); ++i) {
                JSONObject jsonObject = resultArray.getJSONObject(i);
                String invoiceNo = jsonObject.getString("invoiceNo");
                if (!StringUtils.hasText((String)invoiceNo)) {
                    invoiceNo = jsonObject.getString("invoiceId");
                }
                if (!StringUtils.hasText((String)invoiceNo)) {
                    log.error((Object)("\u7b2c\u4e09\u65b9\u63a5\u53e3\u83b7\u53d6\u5f00\u7968\u6570\u636e\u63a5\u53e3\u4e1a\u52a1\u670d\u52a1---->\u65e0\u6cd5\u62ff\u5230\u6709\u6548\u7684\u53d1\u7968\u53f7\u7801," + returnString));
                }
                rspVO.setInvoiceNo(invoiceNo);
                rspVO.setInvoiceCode(jsonObject.getString("invoiceCode"));
                rspVO.setInvoiceDate(jsonObject.getDate("invoiceDate"));
                rspVO.setAmt(jsonObject.getBigDecimal("invoiceAmount"));
                rspVO.setNotTaxAmt(jsonObject.getBigDecimal("invoiceNakedAmount"));
                rspVO.setTaxAmt(jsonObject.getBigDecimal("invoiceTaxAmount"));
                rspVO.setName(jsonObject.getString("title"));
                rspVO.setTaxNo(jsonObject.getString("enterpriseTaxpayer"));
                rspVO.setAddress(jsonObject.getString("address"));
                rspVO.setPhone(jsonObject.getString("tel"));
                rspVO.setBankName(jsonObject.getString("bank"));
                rspVO.setBankAcNo(jsonObject.getString("account"));
                rspVO.setInvoiceType(jsonObject.getInteger("invoiceType"));
                rspVO.setResultCode(rspJsonObject.getString("resultCode"));
                rspVO.setResultMsg(rspJsonObject.getString("resultMessage"));
                rspBO.getDataList().add(rspVO);
            }
        } else {
            rspVO.setResultCode(rspJsonObject.getString("resultCode"));
            rspVO.setResultMsg(rspJsonObject.getString("resultMessage"));
            rspBO.getDataList().add(rspVO);
        }
    }
}

