/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.supplier.impl;

import com.alibaba.fastjson.JSONObject;
import com.ohaotian.plugin.base.exception.BusinessException;
import com.tydic.fsc.supplier.BusiTransferRecAmtConfirmService;
import com.tydic.fsc.supplier.bo.BusiTransferRecAmtConfirmReqBO;
import com.tydic.fsc.supplier.bo.BusiTransferRecAmtConfirmRspBO;
import com.tydic.fsc.supplier.utils.JsonUtils;
import com.tydic.fsc.supplier.utils.http.HSHttpHelper;
import com.tydic.fsc.supplier.utils.http.HSNHttpHeader;
import com.tydic.fsc.supplier.utils.http.HttpRetBean;
import java.net.URI;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

@Service
public class BusiTransferRecAmtConfirmServiceImpl
implements BusiTransferRecAmtConfirmService {
    private static final Log log = LogFactory.getLog(BusiTransferRecAmtConfirmServiceImpl.class);
    @Autowired
    @Qualifier(value="fscSupplierPropertyConfigurer")
    private Properties prop;

    public BusiTransferRecAmtConfirmRspBO transfer(BusiTransferRecAmtConfirmReqBO reqBO) {
        HttpRetBean httpRetBean;
        String seqid;
        if (log.isInfoEnabled()) {
            log.info((Object)("\u6536\u6b3e\u786e\u8ba4\u5355\u4f20\u9001\u8fdc\u5149\u8d22\u52a1\u7cfb\u7edf\u670d\u52a1\u5165\u53c2\uff1a" + reqBO));
        }
        if (!StringUtils.hasText((String)(seqid = reqBO.getSeqid()))) {
            log.error((Object)("\u552f\u4e00\u6807\u793a[seqid]\u4e0d\u80fd\u4e3a\u7a7a,reqBO=" + reqBO));
            throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u552f\u4e00\u6807\u793a[seqid]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (!StringUtils.hasText((String)reqBO.getSsdw())) {
            log.error((Object)("\u6240\u5c5e\u5355\u4f4d[ssdw]\u4e0d\u80fd\u4e3a\u7a7a,reqBO=" + reqBO));
            throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u6240\u5c5e\u5355\u4f4d[ssdw]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (!StringUtils.hasText((String)reqBO.getYhdm())) {
            log.error((Object)("\u7528\u6237\u4ee3\u7801[yhdm]\u4e0d\u80fd\u4e3a\u7a7a,reqBO=" + reqBO));
            throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u7528\u6237\u4ee3\u7801[yhdm]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (!StringUtils.hasText((String)reqBO.getFlowid())) {
            log.error((Object)("\u6d41\u7a0bID[flowid]\u4e0d\u80fd\u4e3a\u7a7a,reqBO=" + reqBO));
            throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u6d41\u7a0bID[flowid]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (reqBO.getItems() == null || reqBO.getItems().isEmpty()) {
            log.error((Object)("\u660e\u7ec6[items]\u4e0d\u80fd\u4e3a\u7a7a,reqBO=" + reqBO));
            throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u660e\u7ec6[items]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        String reqStr = JsonUtils.objectBeanToJsonString(reqBO);
        log.info((Object)("\u8bf7\u6c42\u62a5\u6587\uff1a" + reqStr));
        try {
            httpRetBean = HSHttpHelper.doUrlPostRequest(new URI(this.prop.getProperty("ESB_RECAMTCONFIRM_SEND_YUANGUANG_URL")), HSNHttpHeader.getRequestHeaders("json"), reqStr.toString().getBytes("UTF-8"), "UTF-8", false);
        }
        catch (Exception e) {
            log.error((Object)("\u6536\u6b3e\u786e\u8ba4\u5355\u4f20\u9001\u8fdc\u5149\u8d22\u52a1\u7cfb\u7edf\u5931\u8d25,seqid=" + seqid), (Throwable)e);
            throw new BusinessException("RSP_CODE_CALL_THIRD_SERVICE", "\u6536\u6b3e\u786e\u8ba4\u5355\u4f20\u9001\u8fdc\u5149\u8d22\u52a1\u7cfb\u7edf\u5931\u8d25,seqid=" + seqid);
        }
        if (httpRetBean.getStatus() != 200) {
            log.error((Object)("\u6536\u6b3e\u786e\u8ba4\u5355\u4f20\u9001\u8fdc\u5149\u8d22\u52a1\u7cfb\u7edf\u5931\u8d25,http_status=" + httpRetBean.getStatus() + ",seqid=" + seqid));
            throw new BusinessException("RSP_CODE_CALL_THIRD_SERVICE", "\u6536\u6b3e\u786e\u8ba4\u5355\u4f20\u9001\u8fdc\u5149\u8d22\u52a1\u7cfb\u7edf\u5931\u8d25,http_status=" + httpRetBean.getStatus() + ",seqid=" + seqid);
        }
        String returnString = httpRetBean.getStr();
        log.info((Object)("\u54cd\u5e94\u62a5\u6587\uff1a" + returnString));
        if (!StringUtils.hasText((String)returnString)) {
            log.error((Object)"\u6536\u6b3e\u786e\u8ba4\u5355\u4f20\u9001\u8fdc\u5149\u8d22\u52a1\u7cfb\u7edf\u5931\u8d25,\u54cd\u5e94\u62a5\u6587\u4e3a\u7a7a");
            throw new BusinessException("RSP_CODE_CALL_THIRD_SERVICE", "\u6536\u6b3e\u786e\u8ba4\u5355\u4f20\u9001\u8fdc\u5149\u8d22\u52a1\u7cfb\u7edf\u5931\u8d25,\u54cd\u5e94\u62a5\u6587\u4e3a\u7a7a");
        }
        BusiTransferRecAmtConfirmRspBO rspBO = new BusiTransferRecAmtConfirmRspBO();
        JSONObject rspJsonObject = JSONObject.parseObject((String)returnString);
        rspBO.setSeqid(rspJsonObject.getString("seqid"));
        rspBO.setCwdjid(rspJsonObject.getString("cwdjid"));
        rspBO.setRspcode(rspJsonObject.getString("rspcode"));
        rspBO.setRspmsg(rspJsonObject.getString("rspmsg"));
        return rspBO;
    }
}

