/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fscext.mock.impl;

import com.ohaotian.plugin.base.exception.BusinessException;
import com.tydic.fsc.settle.dao.BillApplyInfoMapper;
import com.tydic.fsc.settle.dao.SaleItemInfoMapper;
import com.tydic.fsc.settle.dao.po.BillApplyInfo;
import com.tydic.fsc.settle.dao.po.SaleItemInfo;
import com.tydic.fsc.settle.dao.vo.SaleItemInfoVO;
import com.tydic.fsc.settle.enums.BillStatus;
import com.tydic.fsc.settle.enums.SaleInvoiceInfoInvoiceStatus;
import com.tydic.fsc.settle.enums.SaleItemApplyInfoStatus;
import com.tydic.fsc.settle.utils.FscStringUtils;
import com.tydic.fscext.mock.FscMockBackInvoiceService;
import com.tydic.fscext.mock.bo.FscMockBackInvoiceBO;
import com.tydic.fscext.mock.bo.FscMockBackInvoiceDetailBO;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Service
public class FscMockBackInvoiceServiceImpl
implements FscMockBackInvoiceService {
    private static final Logger LOGGER = LoggerFactory.getLogger(FscMockBackInvoiceServiceImpl.class);
    @Autowired
    private BillApplyInfoMapper billApplyInfoMapper;
    @Autowired
    private SaleItemInfoMapper saleItemInfoMapper;

    public FscMockBackInvoiceBO mockBackData(String billNo) {
        FscMockBackInvoiceBO reqBO = new FscMockBackInvoiceBO();
        ArrayList<FscMockBackInvoiceDetailBO> detail = new ArrayList<FscMockBackInvoiceDetailBO>();
        FscMockBackInvoiceDetailBO mockBackInvoiceDetailBO = new FscMockBackInvoiceDetailBO();
        BillApplyInfo billApplyInfo = this.billApplyInfoMapper.selectByPrimaryKey(billNo);
        if (billApplyInfo == null) {
            LOGGER.error("\u67e5\u4e0d\u5230\u5f00\u7968\u7533\u8bf7\u8bb0\u5f55[\u5f00\u7968\u7533\u8bf7\u5355\u53f7=" + billNo + "]");
            throw new BusinessException("18001", "\u67e5\u4e0d\u5230\u5f00\u7968\u7533\u8bf7\u8bb0\u5f55[\u5f00\u7968\u7533\u8bf7\u5355\u53f7=" + billNo + "]");
        }
        if (!BillStatus.APPLIED.getCode().equals(billApplyInfo.getBillStatus())) {
            LOGGER.error("\u5f00\u7968\u7533\u8bf7\u8bb0\u5f55[\u5f00\u7968\u7533\u8bf7\u5355\u53f7=" + billNo + "]\u7684\u72b6\u6001\u4e0d\u6b63\u786e");
            throw new BusinessException("18003", "\u5f00\u7968\u7533\u8bf7\u8bb0\u5f55[\u5f00\u7968\u7533\u8bf7\u5355\u53f7=" + billNo + "]\u7684\u72b6\u6001\u4e0d\u6b63\u786e");
        }
        SaleItemInfoVO saleItemInfoVO = new SaleItemInfoVO();
        saleItemInfoVO.setApplyNo(billNo);
        saleItemInfoVO.setSaleItemApplyInfoStatus(SaleItemApplyInfoStatus.VALID.getCode());
        List saleItemInfoList = this.saleItemInfoMapper.getListJoinSaleItemApplyInfo(saleItemInfoVO);
        BigDecimal invoiceAmount = BigDecimal.ZERO;
        BigDecimal invoiceTax = BigDecimal.ZERO;
        if (!CollectionUtils.isEmpty((Collection)saleItemInfoList)) {
            for (SaleItemInfo saleItemInfo : saleItemInfoList) {
                mockBackInvoiceDetailBO.setOrder_no(saleItemInfo.getInspectionId() == null ? "" : String.valueOf(saleItemInfo.getInspectionId()));
                mockBackInvoiceDetailBO.setLines_number(saleItemInfo.getItemNo());
                mockBackInvoiceDetailBO.setMateriel_unit(saleItemInfo.getUnitName());
                mockBackInvoiceDetailBO.setQuantity(saleItemInfo.getQuantity());
                if (saleItemInfo.getTaxCatCode() != null && saleItemInfo.getTaxCatCode() > 0L) {
                    mockBackInvoiceDetailBO.setTax_class_code(saleItemInfo.getTaxCatCode().toString());
                } else {
                    mockBackInvoiceDetailBO.setTax_class_code("123456");
                }
                BigDecimal taxRate = saleItemInfo.getTaxRate() == null ? new BigDecimal("0.17") : saleItemInfo.getTaxRate();
                BigDecimal tax = saleItemInfo.getAmount().divide(BigDecimal.ONE.add(taxRate), 4, 4).multiply(taxRate).setScale(2, 4);
                invoiceTax = invoiceTax.add(tax);
                invoiceAmount = invoiceAmount.add(saleItemInfo.getAmount().subtract(invoiceTax)).setScale(2, 4);
                mockBackInvoiceDetailBO.setAmount(invoiceAmount);
                mockBackInvoiceDetailBO.setTax(tax);
                mockBackInvoiceDetailBO.setTax_rate(saleItemInfo.getTaxRate());
                String materiel_name = saleItemInfo.getSkuName() == null ? "" : saleItemInfo.getSkuName().replaceAll("\n", " ");
                materiel_name = FscStringUtils.cutStringByByte((String)materiel_name, (String)"GBK", (int)35);
                mockBackInvoiceDetailBO.setMateriel_name(materiel_name);
                String materiel_standard = saleItemInfo.getSpec() == null ? "" : (saleItemInfo.getSpec() + saleItemInfo.getModel() == null ? "" : (saleItemInfo.getModel() + saleItemInfo.getFigureNo() == null ? "" : saleItemInfo.getFigureNo()));
                materiel_standard = FscStringUtils.cutStringByByte((String)materiel_standard, (String)"GBK", (int)30);
                mockBackInvoiceDetailBO.setMateriel_standard(StringUtils.hasText((String)materiel_standard) ? materiel_standard : "\u65e0");
                detail.add(mockBackInvoiceDetailBO);
            }
        }
        reqBO.setBill_no(billNo);
        reqBO.setDetail(detail);
        reqBO.setInvoice_amount(invoiceAmount.toPlainString());
        reqBO.setInvoice_tax(invoiceTax.toPlainString());
        reqBO.setInvoice_state(Integer.valueOf(SaleInvoiceInfoInvoiceStatus.SEND_BILL.getCode()));
        reqBO.setInvoice_date(new SimpleDateFormat("yyyy-MM-dd").format(new Date()));
        reqBO.setInvoice_code(String.valueOf(System.currentTimeMillis()));
        reqBO.setInvoice_num(String.valueOf(System.currentTimeMillis()));
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("\u6a21\u62df\u540e\u7684\u7a0e\u63a7\u56de\u4f20\u5f00\u7968\u4fe1\u606f\u670d\u52a1\u5165\u53c2\uff1a" + reqBO);
        }
        return reqBO;
    }
}

