/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.gemini.enums;

import java.util.ArrayList;
import java.util.List;
import org.springframework.util.StringUtils;

public class GeminiEnums {

    public static enum SmsEnum {
        SMS_CODE("20"),
        ALIBABA_MESSAGE("21"),
        TENCENT_MESSAGE("22"),
        HUAWEI_MESSAGE("23"),
        CRC_SMS("52"),
        HTTP_MESSAGE("24");

        private final String smsCode;

        private SmsEnum(String smsCode) {
            this.smsCode = smsCode;
        }

        public String getSmsCode() {
            return this.smsCode;
        }

        public static Boolean contain(String codeStr) {
            if (StringUtils.isEmpty((Object)codeStr)) {
                return false;
            }
            for (SmsEnum sms : SmsEnum.values()) {
                if (!sms.smsCode.equals(codeStr)) continue;
                return true;
            }
            return false;
        }

        public static List<String> allSmsCode() {
            ArrayList<String> smsCodeList = new ArrayList<String>();
            for (SmsEnum sms : SmsEnum.values()) {
                smsCodeList.add(sms.smsCode);
            }
            return smsCodeList;
        }
    }

    public static enum HasTemplateEnum {
        SMS_CODE("20"),
        ALIBABA_MESSAGE("21"),
        TENCENT_MESSAGE("22"),
        HUAWEI_MESSAGE("23"),
        CRC_SMS("52"),
        HTTP_MESSAGE("24"),
        HTTP_EMAIL("32");

        private final String smsCode;

        private HasTemplateEnum(String smsCode) {
            this.smsCode = smsCode;
        }

        public String getSmsCode() {
            return this.smsCode;
        }

        public static Boolean contain(String codeStr) {
            if (StringUtils.isEmpty((Object)codeStr)) {
                return false;
            }
            for (HasTemplateEnum sms : HasTemplateEnum.values()) {
                if (!sms.smsCode.equals(codeStr)) continue;
                return true;
            }
            return false;
        }

        public static List<String> allSmsCode() {
            ArrayList<String> smsCodeList = new ArrayList<String>();
            for (HasTemplateEnum sms : HasTemplateEnum.values()) {
                smsCodeList.add(sms.smsCode);
            }
            return smsCodeList;
        }
    }

    public static enum MessageAble {
        INNER_MESSAGE(11L, "\u7ad9\u5185\u4fe1", SendTypeGroup.INNER_MESSAGE),
        POP_UPS(12L, "\u5f39\u7a97", SendTypeGroup.POPUP_MESSAGE),
        ALIBABA_MESSAGE(21L, "\u963f\u91cc\u4e91\u77ed\u4fe1", SendTypeGroup.SHORT_MESSAGE),
        TENCENT_MESSAGE(22L, "\u817e\u8baf\u4e91\u77ed\u4fe1", SendTypeGroup.SHORT_MESSAGE),
        HUAWEI_MESSAGE(23L, "\u534e\u4e3a\u4e91\u77ed\u4fe1", SendTypeGroup.SHORT_MESSAGE),
        HTTP_MESSAGE(24L, "\u7edf\u4e00\u77ed\u4fe1", SendTypeGroup.SHORT_MESSAGE),
        EMAIL(31L, "\u90ae\u7bb1", SendTypeGroup.MAIL_MESSAGE),
        HTTP_EMAIL(32L, "\u90ae\u7bb1", SendTypeGroup.MAIL_MESSAGE),
        WECHAT(41L, "\u5fae\u4fe1\u901a\u77e5", SendTypeGroup.WECHAT),
        CRC_EMAIL(51L, "\u534e\u6da6\u90ae\u4ef6", SendTypeGroup.MAIL_MESSAGE),
        CRC_SMS(52L, "\u534e\u6da6\u77ed\u4fe1", SendTypeGroup.SHORT_MESSAGE),
        DINGTALK(61L, "\u9489\u9489", SendTypeGroup.DING_TALK);

        private final Long ableId;
        private final String ableName;
        private final SendTypeGroup group;

        private MessageAble(Long ableId, String ableName, SendTypeGroup group) {
            this.ableId = ableId;
            this.ableName = ableName;
            this.group = group;
        }

        public Long getAbleId() {
            return this.ableId;
        }

        public String getAbleName() {
            return this.ableName;
        }

        public SendTypeGroup getGroup() {
            return this.group;
        }

        public static MessageAble getMessageAble(Long ableId) {
            if (null == ableId) {
                return null;
            }
            for (MessageAble messageAble : MessageAble.values()) {
                if (!messageAble.ableId.equals(ableId)) continue;
                return messageAble;
            }
            return null;
        }
    }

    public static enum SendTypeGroup {
        INNER_MESSAGE("INNER_MESSAGE", "\u7ad9\u5185\u4fe1", 1),
        POPUP_MESSAGE("POPUP_MESSAGE", "\u5f39\u7a97", 2),
        SHORT_MESSAGE("SHORT_MESSAGE", "\u77ed\u4fe1", 3),
        MAIL_MESSAGE("MAIL_MESSAGE", "\u90ae\u4ef6", 4),
        WECHAT("WECHAT", "\u5fae\u4fe1\u516c\u4f17\u53f7", 5),
        DING_TALK("DING_TALK", "\u9489\u9489", 6);

        private String groupCode;
        private String typeName;
        private int sort;

        private SendTypeGroup(String groupCode, String typeName, int sort) {
            this.groupCode = groupCode;
            this.typeName = typeName;
            this.sort = sort;
        }

        public String getGroupCode() {
            return this.groupCode;
        }

        public String getTypeName() {
            return this.typeName;
        }

        public int getSort() {
            return this.sort;
        }

        public static SendTypeGroup getByCode(String code) {
            if (null == code) {
                return null;
            }
            for (SendTypeGroup item : SendTypeGroup.values()) {
                if (!item.getGroupCode().equals(code)) continue;
                return item;
            }
            return null;
        }
    }
}

