/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.gemini.external.impl;

import cn.hutool.http.HttpUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.tydic.gemini.constants.GeminiConstants;
import com.tydic.gemini.exception.GeminiBusinessException;
import com.tydic.gemini.external.api.GeminiUmcUserInfoService;
import com.tydic.gemini.external.api.bo.GeminiExternalReceiverBO;
import com.tydic.gemini.external.api.bo.GeminiUmcUserInfoReqBO;
import com.tydic.gemini.external.api.bo.GeminiUmcUserInfoRspBO;
import com.tydic.gemini.external.api.bo.GeminiUserInfoDataBO;
import com.tydic.gemini.external.api.bo.HttpResponseData;
import com.tydic.gemini.external.api.bo.PageableResponse;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Service(value="geminiUmcUserInfoService")
public class GeminiUmcUserInfoServiceImpl
implements GeminiUmcUserInfoService {
    private static final Logger log = LoggerFactory.getLogger(GeminiUmcUserInfoServiceImpl.class);
    @Value(value="${umc.user.info.url:none}")
    private String umcUserInfoUrl;
    @Value(value="${umc.user.page.size:100}")
    private int umcPageSize;

    @Override
    public GeminiUmcUserInfoRspBO getUserInfo(GeminiUmcUserInfoReqBO reqBo) {
        GeminiUmcUserInfoRspBO retBo = new GeminiUmcUserInfoRspBO();
        String requestParams = reqBo.getUmcParam();
        if (StringUtils.isEmpty((Object)requestParams)) {
            requestParams = JSON.toJSONString((Object)reqBo);
        }
        log.info("\u8c03\u7528\u4f1a\u5458\u4e2d\u5fc3\u7528\u6237\u4fe1\u606f\u67e5\u8be2\u63a5\u53e3\u5165\u53c2\uff1a{}", (Object)requestParams);
        JSONObject reqJsonObject = JSON.parseObject((String)requestParams);
        reqJsonObject.put("pageNo", (Object)GeminiConstants.UmcConstant.PAGE_NO_DEFAULT);
        reqJsonObject.put("pageSize", (Object)this.umcPageSize);
        HttpResponseData<JSONObject> data = this.doGetUserInfo(reqJsonObject.toJSONString());
        ArrayList<GeminiExternalReceiverBO> userInfos = new ArrayList<GeminiExternalReceiverBO>();
        retBo.setUserInfos(userInfos);
        if (StringUtils.isEmpty((Object)data.getTotal())) {
            reqJsonObject.put("pageNo", (Object)GeminiConstants.UmcConstant.NO_PAGE);
            reqJsonObject.put("pageSize", (Object)GeminiConstants.UmcConstant.NO_PAGE);
            data = this.doGetUserInfo(reqJsonObject.toJSONString());
            this.parseUmcDataToRetBo(userInfos, data);
            return retBo;
        }
        if (GeminiConstants.UmcConstant.PAGE_NO_DEFAULT.equals(data.getTotal())) {
            this.parseUmcDataToRetBo(userInfos, data);
        }
        if (GeminiConstants.UmcConstant.PAGE_NO_DEFAULT < data.getTotal()) {
            for (int i = 2; i <= data.getTotal(); ++i) {
                reqJsonObject.put("pageNo", (Object)i);
                this.parseUmcDataToRetBo(userInfos, this.doGetUserInfo(reqJsonObject.toJSONString()));
            }
        }
        return retBo;
    }

    private void parseUmcDataToRetBo(List<GeminiExternalReceiverBO> userInfos, HttpResponseData<JSONObject> data) {
        List rows = JSONArray.parseArray((String)JSON.toJSONString(data.getRows()), GeminiUserInfoDataBO.class);
        if (CollectionUtils.isEmpty((Collection)rows)) {
            log.info("\u8c03\u7528\u4f1a\u5458\u4e2d\u5fc3\u63a5\u53e3\u8fd4\u56de\u6570\u636e\u96c6\u4e3a\u7a7a");
            return;
        }
        HashSet<GeminiExternalReceiverBO> userInfoSet = new HashSet<GeminiExternalReceiverBO>(16);
        for (GeminiUserInfoDataBO item : rows) {
            GeminiExternalReceiverBO receiverBo = new GeminiExternalReceiverBO();
            receiverBo.setReceiverId(item.getMemId().toString());
            receiverBo.setReceiverName(item.getMemName2());
            receiverBo.setMobileNumber(item.getRegMobile());
            receiverBo.setEMail(item.getRegEmail());
            item.getUmcThirdBindBOList().forEach(thirdItem -> {
                if (GeminiConstants.UmcConstant.WE_CHAT_APP_ID_TYPE.equals(thirdItem.getAuthType())) {
                    receiverBo.setOpenId(thirdItem.getAuthId());
                }
            });
            userInfoSet.add(receiverBo);
        }
        userInfos.addAll(userInfoSet);
    }

    private HttpResponseData<JSONObject> doGetUserInfo(String requestParams) {
        log.info("\u8bf7\u6c42\u4f1a\u5458\u4e2d\u5fc3\u63a5\u53e3\u5165\u53c2\uff1a{}", (Object)requestParams);
        String result = HttpUtil.post((String)this.umcUserInfoUrl, (String)requestParams);
        log.info("\u4f1a\u5458\u4e2d\u5fc3\u8fd4\u56de\u6570\u636e\uff1a{}", (Object)result);
        if (StringUtils.isEmpty((Object)result)) {
            log.error("\u8c03\u7528\u4f1a\u5458\u4e2d\u5fc3\u67e5\u8be2\u7528\u6237\u4fe1\u606f\u8fd4\u56de\u7a7a");
            throw new GeminiBusinessException("8003", "\u8c03\u7528\u4f1a\u5458\u4e2d\u5fc3\u63a5\u53e3\u8fd4\u56de\u7a7a");
        }
        PageableResponse response = (PageableResponse)JSON.parseObject((String)result, PageableResponse.class);
        if (!"0".equals(response.getCode())) {
            log.error("\u8c03\u7528\u4f1a\u5458\u4e2d\u5fc3\u67e5\u8be2\u7528\u6237\u4fe1\u606f\u5931\u8d25\uff1a{}", (Object)response.getMessage());
            throw new GeminiBusinessException("8003", "\u8c03\u7528\u4f1a\u5458\u4e2d\u5fc3\u63a5\u53e3\u5931\u8d25\uff1a" + response.getMessage());
        }
        return response.getData();
    }
}

