/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.gemini.utils;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.CollectionUtils;

public class GeminiTranslationUtil {
    private static final Logger log = LoggerFactory.getLogger(GeminiTranslationUtil.class);
    private static final Pattern PLACEHOLDER_PATTERN = Pattern.compile("(\\*\\{)([\\w]+)(})");
    private static final Pattern POUND_SIGN_PATTERN = Pattern.compile("(@\\{)([\\w]+)(})");

    private GeminiTranslationUtil() {
    }

    public static String nameReplacementId(String templateContent, Map<String, String> valueMap) {
        return GeminiTranslationUtil.placeholderSubstitution(templateContent, valueMap);
    }

    public static String codeReplacementId(String templateContent, Map<String, String> codeMap) {
        GeminiTranslationUtil.conversionMap(codeMap);
        return GeminiTranslationUtil.placeholderSubstitution(templateContent, codeMap);
    }

    public static String valueReplacementId(String templateContent, Map<String, String> codeMap, Map<String, String> valueMap) {
        GeminiTranslationUtil.completionMap(codeMap);
        String codeTemplateContent = GeminiTranslationUtil.placeholderSubstitution(templateContent, codeMap);
        return GeminiTranslationUtil.variableSubstitution(codeTemplateContent, valueMap);
    }

    public static List<Long> getPlaceholderList(String templateContent) {
        Matcher matcher = PLACEHOLDER_PATTERN.matcher(templateContent);
        ArrayList<Long> variableIdList = new ArrayList<Long>();
        while (matcher.find()) {
            String param = matcher.group();
            variableIdList.add(Long.valueOf(param.replace("*", "").replace("{", "").replace("}", "")));
        }
        log.info("\u6a21\u677f\u4e2d\u7684\u53d8\u91cfId\uff1a{}", variableIdList);
        return variableIdList;
    }

    public static String placeholderSubstitution(String templateContent, Map<String, String> valueMap) {
        Matcher matcher = PLACEHOLDER_PATTERN.matcher(templateContent);
        return GeminiTranslationUtil.directReplacement(matcher, valueMap);
    }

    public static String variableSubstitution(String templateContent, Map<String, String> valueMap) {
        Matcher matcher = POUND_SIGN_PATTERN.matcher(templateContent);
        return GeminiTranslationUtil.directReplacement(matcher, valueMap);
    }

    private static String directReplacement(Matcher matcher, Map<String, String> valueMap) {
        StringBuffer rspTemplate = new StringBuffer();
        while (matcher.find()) {
            String param = matcher.group();
            String value = valueMap.get(param.replace("*", "").replace("@", "").replace("{", "").replace("}", ""));
            matcher.appendReplacement(rspTemplate, value == null ? "" : value.toString());
        }
        matcher.appendTail(rspTemplate);
        if (log.isDebugEnabled()) {
            log.debug("\u8f6c\u6362\u540e\u7684\u5185\u5bb9\uff1a{}", (Object)rspTemplate);
        }
        return rspTemplate.toString();
    }

    public static void completionMap(Map<String, String> codeMap) {
        if (CollectionUtils.isEmpty(codeMap)) {
            return;
        }
        for (Map.Entry<String, String> entry : codeMap.entrySet()) {
            String key = entry.getKey();
            String value = entry.getValue();
            if (value.startsWith("@{") || value.endsWith("}")) continue;
            codeMap.put(key, "@{" + value + "}");
        }
    }

    public static void conversionMap(Map<String, String> codeMap) {
        if (CollectionUtils.isEmpty(codeMap)) {
            return;
        }
        for (Map.Entry<String, String> entry : codeMap.entrySet()) {
            String key = entry.getKey();
            String value = entry.getValue();
            if (value.startsWith("*{") || value.endsWith("}")) continue;
            codeMap.put(key, "*{" + value + "}");
        }
    }
}

