/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.gemini.ability.impl;

import com.tydic.gemini.api.GeminiInnerMessageEditService;
import com.tydic.gemini.api.bo.GeminiInnerMessageEditStatusReqBO;
import com.tydic.gemini.api.bo.GeminiInnerMessageEditStatusRspBO;
import com.tydic.gemini.constants.GeminiConstants;
import com.tydic.gemini.dao.GeminiInnerMessageMapper;
import com.tydic.gemini.exception.GeminiBusinessException;
import java.util.Collection;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"GEMINI_GROUP/1.0.0/com.tydic.gemini.api.GeminiInnerMessageEditService"})
public class GeminiInnerMessageEditServiceImpl
implements GeminiInnerMessageEditService {
    private final GeminiInnerMessageMapper geminiInnerMessageMapper;

    public GeminiInnerMessageEditServiceImpl(GeminiInnerMessageMapper geminiInnerMessageMapper) {
        this.geminiInnerMessageMapper = geminiInnerMessageMapper;
    }

    @PostMapping(value={"editInnerMessageStatus"})
    public GeminiInnerMessageEditStatusRspBO editInnerMessageStatus(@RequestBody GeminiInnerMessageEditStatusReqBO reqBO) {
        GeminiInnerMessageEditStatusRspBO rspBO = new GeminiInnerMessageEditStatusRspBO();
        this.validate(reqBO);
        if (GeminiConstants.StatusConstants.OPERATION_WAY_READ.equals(reqBO.getOperationWay())) {
            this.geminiInnerMessageMapper.haveRead(reqBO.getMessageIds(), reqBO.getReceiverId());
        }
        if (GeminiConstants.StatusConstants.OPERATION_WAY_DELETE.equals(reqBO.getOperationWay())) {
            this.geminiInnerMessageMapper.deleteByMessageIds(reqBO.getMessageIds(), reqBO.getReceiverId());
        }
        if (GeminiConstants.StatusConstants.OPERATION_WAY_READ_ALL.equals(reqBO.getOperationWay())) {
            this.geminiInnerMessageMapper.allHaveRead(reqBO.getReceiverId());
        }
        return rspBO;
    }

    public void validate(GeminiInnerMessageEditStatusReqBO reqBO) {
        if (StringUtils.isEmpty((Object)reqBO.getUserId()) && StringUtils.isEmpty((Object)reqBO.getReceiverId())) {
            throw new GeminiBusinessException("1002", "\u5165\u53c2\u5bf9\u8c61[GeminiInnerMessageEditStatusReqBO]\u5c5e\u6027[userId]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isEmpty((Object)reqBO.getReceiverId())) {
            reqBO.setReceiverId(reqBO.getUserId());
        }
        if (StringUtils.isEmpty((Object)reqBO.getOperationWay())) {
            throw new GeminiBusinessException("1002", "\u5165\u53c2\u5bf9\u8c61[GeminiInnerMessageEditStatusReqBO]\u5c5e\u6027[operationWay]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (!GeminiConstants.StatusConstants.OPERATION_WAY_READ_ALL.equals(reqBO.getOperationWay()) && CollectionUtils.isEmpty((Collection)reqBO.getMessageIds())) {
            throw new GeminiBusinessException("1002", "\u5165\u53c2\u5bf9\u8c61[GeminiInnerMessageEditStatusReqBO]\u5c5e\u6027[messageIds]\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }
}

