/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.gemini.ability.impl;

import com.alibaba.fastjson.JSON;
import com.tydic.gemini.api.GeminiTaskAddService;
import com.tydic.gemini.api.bo.GeminiReceiverDataBO;
import com.tydic.gemini.api.bo.GeminiTaskAddReqBO;
import com.tydic.gemini.api.bo.GeminiTaskAddRspBO;
import com.tydic.gemini.api.bo.GeminiTaskDuplicateReqBO;
import com.tydic.gemini.api.bo.GeminiTaskDuplicateRspBO;
import com.tydic.gemini.api.bo.GeminiTaskReceiverDataBO;
import com.tydic.gemini.atom.api.GeminiReceiverAtomService;
import com.tydic.gemini.atom.api.GeminiTaskAtomService;
import com.tydic.gemini.atom.api.bo.GeminiReceiverListQryAtomReqBO;
import com.tydic.gemini.atom.api.bo.GeminiReceiverListQryAtomRspBO;
import com.tydic.gemini.atom.api.bo.GeminiTaskAtomReqBO;
import com.tydic.gemini.atom.api.bo.GeminiTaskDetailsAtomRspBO;
import com.tydic.gemini.busi.api.GeminiDealTaskBusiService;
import com.tydic.gemini.busi.api.bo.GeminiTaskAddBusiReqBO;
import com.tydic.gemini.busi.api.bo.GeminiTaskAddBusiRspBO;
import com.tydic.gemini.constants.GeminiConstants;
import com.tydic.gemini.exception.GeminiBusinessException;
import com.tydic.utils.generatedoc.util.ArgValidator;
import java.util.List;
import org.springframework.beans.BeanUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"GEMINI_GROUP/1.0.0/com.tydic.gemini.api.GeminiTaskAddService"})
public class GeminiTaskAddServiceImpl
implements GeminiTaskAddService {
    private GeminiDealTaskBusiService geminiDealTaskBusiService;
    private GeminiTaskAtomService geminiTaskAtomService;
    private GeminiReceiverAtomService geminiReceiverAtomService;

    public GeminiTaskAddServiceImpl(GeminiDealTaskBusiService geminiDealTaskBusiService, GeminiTaskAtomService geminiTaskAtomService, GeminiReceiverAtomService geminiReceiverAtomService) {
        this.geminiDealTaskBusiService = geminiDealTaskBusiService;
        this.geminiTaskAtomService = geminiTaskAtomService;
        this.geminiReceiverAtomService = geminiReceiverAtomService;
    }

    @PostMapping(value={"addTask"})
    public GeminiTaskAddRspBO addTask(@RequestBody GeminiTaskAddReqBO reqBO) {
        GeminiTaskAddRspBO rspBO = new GeminiTaskAddRspBO();
        String validateStr = this.validate(reqBO);
        if (!StringUtils.isEmpty((Object)validateStr)) {
            throw new GeminiBusinessException("1002", validateStr);
        }
        GeminiTaskAddBusiReqBO busiReqBO = new GeminiTaskAddBusiReqBO();
        BeanUtils.copyProperties((Object)reqBO, (Object)((Object)busiReqBO));
        GeminiTaskAddBusiRspBO busiRspBO = this.geminiDealTaskBusiService.addTaskInfo(busiReqBO);
        if (!"0000".equals(busiRspBO.getRespCode())) {
            throw new GeminiBusinessException(busiRspBO.getRespCode(), busiRspBO.getRespDesc());
        }
        return rspBO;
    }

    @PostMapping(value={"duplicateTask"})
    public GeminiTaskDuplicateRspBO duplicateTask(@RequestBody GeminiTaskDuplicateReqBO reqBO) {
        GeminiTaskDuplicateRspBO rspBO = new GeminiTaskDuplicateRspBO();
        if (StringUtils.isEmpty((Object)reqBO.getTaskId())) {
            throw new GeminiBusinessException("1002", "\u590d\u5236\u4efb\u52a1\u65f6\uff0c\u5165\u53c2\u5bf9\u8c61[GeminiTaskDuplicateReqBO]\u5c5e\u6027[taskId:\u4efb\u52a1id]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        GeminiTaskAtomReqBO taskAtomReqBO = new GeminiTaskAtomReqBO();
        taskAtomReqBO.setTaskId(reqBO.getTaskId());
        GeminiTaskDetailsAtomRspBO taskAtomRspBO = this.geminiTaskAtomService.qryTaskDetails(taskAtomReqBO);
        if (!GeminiConstants.StatusConstants.TASK_SUSPENDED_STATUS.equals(taskAtomRspBO.getStatus())) {
            throw new GeminiBusinessException("1006", "\u8be5\u4efb\u52a1\u72b6\u6001\u4e0b\u4e0d\u53ef\u6267\u884c\u590d\u5236\u64cd\u4f5c\uff01");
        }
        GeminiTaskAddReqBO geminiTaskAddReqBO = new GeminiTaskAddReqBO();
        BeanUtils.copyProperties((Object)reqBO, (Object)geminiTaskAddReqBO);
        geminiTaskAddReqBO.setStatus(GeminiConstants.StatusConstants.TASK_DRAFT_STATUS);
        GeminiReceiverListQryAtomReqBO receiverListQryAtomReqBO = new GeminiReceiverListQryAtomReqBO();
        GeminiReceiverDataBO receiverDataBO = new GeminiReceiverDataBO();
        receiverDataBO.setTaskId(reqBO.getTaskId());
        receiverDataBO.setStatus(GeminiConstants.StatusConstants.EFFECTIVE_STATUS);
        receiverListQryAtomReqBO.setReceiverData(receiverDataBO);
        GeminiReceiverListQryAtomRspBO receiverListQryAtomRspBO = this.geminiReceiverAtomService.qryReceiverList(receiverListQryAtomReqBO);
        List taskReceiverList = JSON.parseArray((String)JSON.toJSONString(receiverListQryAtomRspBO.getReceiverDetailsAtomRspBOList()), GeminiTaskReceiverDataBO.class);
        geminiTaskAddReqBO.setTaskReceiverList(taskReceiverList);
        this.addTask(geminiTaskAddReqBO);
        return rspBO;
    }

    public String validate(GeminiTaskAddReqBO reqBO) {
        String validateStr = ArgValidator.validateArg((Object)reqBO);
        if (!StringUtils.isEmpty((Object)validateStr)) {
            return validateStr;
        }
        if (StringUtils.isEmpty((Object)reqBO.getTemplateId())) {
            if (StringUtils.isEmpty((Object)reqBO.getMessageTitle())) {
                return "\u65b0\u5efa\u6d88\u606f\u65f6\uff0c\u5165\u53c2\u5bf9\u8c61[GeminiTaskAddReqBO]\u5c5e\u6027[messageTitle:\u6a21\u677f-\u6d88\u606f\u6807\u9898]\u4e0d\u80fd\u4e3a\u7a7a";
            }
            if (StringUtils.isEmpty((Object)reqBO.getMessageContent())) {
                return "\u65b0\u5efa\u6d88\u606f\u65f6\uff0c\u5165\u53c2\u5bf9\u8c61[GeminiTaskAddReqBO]\u5c5e\u6027[messageContent:\u6a21\u677f-\u6d88\u606f\u5185\u5bb9]\u4e0d\u80fd\u4e3a\u7a7a";
            }
        }
        if (GeminiConstants.JudgmentWayConstants.MANUAL_EXECUTION.equals(reqBO.getExecuteWay()) && StringUtils.isEmpty((Object)reqBO.getIsSingle())) {
            return "\u624b\u52a8\u6267\u884c\u65f6\uff0c\u5165\u53c2\u5bf9\u8c61[GeminiTaskAddReqBO]\u5c5e\u6027[isSingle:\u662f\u5426\u5355\u6b21\u6267\u884c]\u4e0d\u80fd\u4e3a\u7a7a";
        }
        return null;
    }
}

