/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.gemini.ability.impl;

import com.tydic.gemini.api.GeminiTaskEditService;
import com.tydic.gemini.api.bo.GeminiTaskEditReqBO;
import com.tydic.gemini.api.bo.GeminiTaskEditRspBO;
import com.tydic.gemini.api.bo.GeminiTaskEditStatusReqBO;
import com.tydic.gemini.api.bo.GeminiTaskEditStatusRspBO;
import com.tydic.gemini.atom.api.GeminiTaskAtomService;
import com.tydic.gemini.atom.api.bo.GeminiTaskAtomReqBO;
import com.tydic.gemini.atom.api.bo.GeminiTaskDetailsAtomRspBO;
import com.tydic.gemini.busi.api.GeminiDealTaskBusiService;
import com.tydic.gemini.busi.api.bo.GeminiTaskEditBusiReqBO;
import com.tydic.gemini.busi.api.bo.GeminiTaskEditBusiRspBO;
import com.tydic.gemini.busi.api.bo.GeminiTaskEditStatusBusiReqBO;
import com.tydic.gemini.busi.api.bo.GeminiTaskEditStatusBusiRspBO;
import com.tydic.gemini.constants.GeminiConstants;
import com.tydic.gemini.exception.GeminiBusinessException;
import com.tydic.utils.generatedoc.util.ArgValidator;
import org.springframework.beans.BeanUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"GEMINI_GROUP/1.0.0/com.tydic.gemini.api.GeminiTaskEditService"})
public class GeminiTaskEditServiceImpl
implements GeminiTaskEditService {
    private GeminiDealTaskBusiService geminiDealTaskBusiService;
    private GeminiTaskAtomService geminiTaskAtomService;

    public GeminiTaskEditServiceImpl(GeminiDealTaskBusiService geminiDealTaskBusiService, GeminiTaskAtomService geminiTaskAtomService) {
        this.geminiDealTaskBusiService = geminiDealTaskBusiService;
        this.geminiTaskAtomService = geminiTaskAtomService;
    }

    @PostMapping(value={"editTaskInfo"})
    public GeminiTaskEditRspBO editTaskInfo(@RequestBody GeminiTaskEditReqBO reqBO) {
        GeminiTaskEditRspBO rspBO = new GeminiTaskEditRspBO();
        String validateStr = this.validate(reqBO);
        if (!StringUtils.isEmpty((Object)validateStr)) {
            throw new GeminiBusinessException("1002", validateStr);
        }
        GeminiTaskEditBusiReqBO busiReqBO = new GeminiTaskEditBusiReqBO();
        BeanUtils.copyProperties((Object)reqBO, (Object)((Object)busiReqBO));
        GeminiTaskEditBusiRspBO busiRspBO = this.geminiDealTaskBusiService.editTaskInfo(busiReqBO);
        if (!"0000".equals(busiRspBO.getRespCode())) {
            throw new GeminiBusinessException(busiRspBO.getRespCode(), busiRspBO.getRespDesc());
        }
        return rspBO;
    }

    @PostMapping(value={"editTaskStatus"})
    public GeminiTaskEditStatusRspBO editTaskStatus(@RequestBody GeminiTaskEditStatusReqBO reqBO) {
        GeminiTaskEditStatusRspBO rspBO = new GeminiTaskEditStatusRspBO();
        String validateStr = ArgValidator.validateArg((Object)reqBO);
        if (!StringUtils.isEmpty((Object)validateStr)) {
            throw new GeminiBusinessException("1002", validateStr);
        }
        GeminiTaskAtomReqBO taskAtomReqBO = new GeminiTaskAtomReqBO();
        taskAtomReqBO.setTaskId(reqBO.getTaskId());
        GeminiTaskDetailsAtomRspBO taskAtomRspBO = this.geminiTaskAtomService.qryTaskDetails(taskAtomReqBO);
        if (!"0000".equals(taskAtomRspBO.getRespCode())) {
            throw new GeminiBusinessException(taskAtomRspBO.getRespCode(), taskAtomRspBO.getRespDesc());
        }
        Integer nowStatus = taskAtomRspBO.getStatus();
        validateStr = this.validateStatus(reqBO, nowStatus);
        if (!StringUtils.isEmpty((Object)validateStr)) {
            throw new GeminiBusinessException("1006", validateStr);
        }
        GeminiTaskEditStatusBusiReqBO taskBusiReqBO = new GeminiTaskEditStatusBusiReqBO();
        BeanUtils.copyProperties((Object)reqBO, (Object)((Object)taskBusiReqBO));
        GeminiTaskEditStatusBusiRspBO taskBusiRspBO = this.geminiDealTaskBusiService.editTaskStatus(taskBusiReqBO);
        BeanUtils.copyProperties((Object)((Object)taskBusiRspBO), (Object)rspBO);
        return rspBO;
    }

    public String validate(GeminiTaskEditReqBO reqBO) {
        String validateStr = ArgValidator.validateArg((Object)reqBO);
        if (!StringUtils.isEmpty((Object)validateStr)) {
            return validateStr;
        }
        if (StringUtils.isEmpty((Object)reqBO.getTemplateId())) {
            if (StringUtils.isEmpty((Object)reqBO.getMessageTitle())) {
                return "\u65b0\u5efa\u6d88\u606f\u65f6\uff0c\u5165\u53c2\u5bf9\u8c61[GeminiTaskAddReqBO]\u5c5e\u6027[messageTitle:\u6a21\u677f-\u6d88\u606f\u6807\u9898]\u4e0d\u80fd\u4e3a\u7a7a";
            }
            if (StringUtils.isEmpty((Object)reqBO.getMessageContent())) {
                return "\u65b0\u5efa\u6d88\u606f\u65f6\uff0c\u5165\u53c2\u5bf9\u8c61[GeminiTaskAddReqBO]\u5c5e\u6027[messageContent:\u6a21\u677f-\u6d88\u606f\u5185\u5bb9]\u4e0d\u80fd\u4e3a\u7a7a";
            }
        }
        if (GeminiConstants.JudgmentWayConstants.MANUAL_EXECUTION.equals(reqBO.getExecuteWay()) && StringUtils.isEmpty((Object)reqBO.getIsSingle())) {
            return "\u624b\u52a8\u6267\u884c\u65f6\uff0c\u5165\u53c2\u5bf9\u8c61[GeminiTaskAddReqBO]\u5c5e\u6027[isSingle:\u662f\u5426\u5355\u6b21\u6267\u884c]\u4e0d\u80fd\u4e3a\u7a7a";
        }
        return null;
    }

    public String validateStatus(GeminiTaskEditStatusReqBO reqBO, Integer nowStatus) {
        if ("1".equals(reqBO.getCallWay()) && !GeminiConstants.StatusConstants.TASK_SUSPENDED_STATUS.equals(reqBO.getStatus()) && !GeminiConstants.StatusConstants.TASK_OPEN_STATUS.equals(reqBO.getStatus()) && !GeminiConstants.StatusConstants.TASK_DRAFT_STATUS.equals(reqBO.getStatus())) {
            return "\u65e0\u6cd5\u8bc6\u522b\u5f53\u524d\u9700\u8981\u8f6c\u6362\u7684\u72b6\u6001\uff01";
        }
        if (GeminiConstants.StatusConstants.TASK_SUSPENDED_STATUS.equals(reqBO.getStatus()) && !GeminiConstants.StatusConstants.TASK_OPEN_STATUS.equals(nowStatus)) {
            return "\u5f53\u524d\u4efb\u52a1\u72b6\u6001\u4e0d\u53ef\u6267\u884c\u6682\u505c\u64cd\u4f5c\uff01";
        }
        if (GeminiConstants.StatusConstants.TASK_OPEN_STATUS.equals(reqBO.getStatus()) && !GeminiConstants.StatusConstants.TASK_SUSPENDED_STATUS.equals(nowStatus) && !GeminiConstants.StatusConstants.TASK_DRAFT_STATUS.equals(nowStatus)) {
            return "\u5f53\u524d\u4efb\u52a1\u72b6\u6001\u4e0d\u53ef\u6267\u884c\u5f00\u542f\u64cd\u4f5c\uff01";
        }
        if (GeminiConstants.StatusConstants.TASK_DELETE_STATUS.equals(reqBO.getStatus()) && !GeminiConstants.StatusConstants.TASK_SUSPENDED_STATUS.equals(nowStatus) && !GeminiConstants.StatusConstants.TASK_COMPLETE_STATUS.equals(nowStatus) && !GeminiConstants.StatusConstants.TASK_DRAFT_STATUS.equals(nowStatus)) {
            return "\u5f53\u524d\u4efb\u52a1\u72b6\u6001\u4e0d\u53ef\u6267\u884c\u5220\u9664\u64cd\u4f5c\uff01";
        }
        return null;
    }
}

