/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.gemini.ability.impl;

import com.tydic.gemini.api.GeminiTemplateAddService;
import com.tydic.gemini.api.bo.GeminiTemplateAddReqBO;
import com.tydic.gemini.api.bo.GeminiTemplateAddRspBO;
import com.tydic.gemini.atom.api.GeminiTemplateAtomService;
import com.tydic.gemini.atom.api.bo.GeminiTemplateAtomReqBO;
import com.tydic.gemini.busi.api.GeminiDealTemplateBusiService;
import com.tydic.gemini.busi.api.bo.GeminiTemplateAddBusiReqBO;
import com.tydic.gemini.busi.api.bo.GeminiTemplateAddBusiRspBO;
import com.tydic.gemini.exception.GeminiBusinessException;
import com.tydic.utils.generatedoc.util.ArgValidator;
import org.springframework.beans.BeanUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"GEMINI_GROUP/1.0.0/com.tydic.gemini.api.GeminiTemplateAddService"})
public class GeminiTemplateAddServiceImpl
implements GeminiTemplateAddService {
    private GeminiDealTemplateBusiService geminiDealTemplateBusiService;
    private GeminiTemplateAtomService geminiTemplateAtomService;

    public GeminiTemplateAddServiceImpl(GeminiDealTemplateBusiService geminiDealTemplateBusiService, GeminiTemplateAtomService geminiTemplateAtomService) {
        this.geminiDealTemplateBusiService = geminiDealTemplateBusiService;
        this.geminiTemplateAtomService = geminiTemplateAtomService;
    }

    @PostMapping(value={"addTemplate"})
    public GeminiTemplateAddRspBO addTemplate(@RequestBody GeminiTemplateAddReqBO reqBO) {
        this.validate(reqBO);
        GeminiTemplateAddRspBO rspBO = new GeminiTemplateAddRspBO();
        GeminiTemplateAddBusiReqBO busiReqBO = new GeminiTemplateAddBusiReqBO();
        BeanUtils.copyProperties((Object)reqBO, (Object)((Object)busiReqBO));
        GeminiTemplateAddBusiRspBO busiRspBO = this.geminiDealTemplateBusiService.addTemplateInfo(busiReqBO);
        if (!"0000".equals(busiRspBO.getRespCode())) {
            throw new GeminiBusinessException(busiRspBO.getRespCode(), busiRspBO.getRespDesc());
        }
        return rspBO;
    }

    void validate(GeminiTemplateAddReqBO reqBO) {
        String validateStr = ArgValidator.validateArg((Object)reqBO);
        if (!StringUtils.isEmpty((Object)validateStr)) {
            throw new GeminiBusinessException("1002", validateStr);
        }
        GeminiTemplateAtomReqBO templateAtomReqBO = new GeminiTemplateAtomReqBO();
        templateAtomReqBO.setTemplateName(reqBO.getTemplateName());
        templateAtomReqBO.setModuleCode(reqBO.getModuleCode());
        int quantity = this.geminiTemplateAtomService.qryTemplateNum(templateAtomReqBO);
        if (quantity > 0) {
            throw new GeminiBusinessException("1003", "\u6a21\u677f\u540d\u79f0\u91cd\u590d\u4e86\uff01");
        }
    }
}

