/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.gemini.ability.impl;

import com.tydic.gemini.api.GeminiTemplateEditService;
import com.tydic.gemini.api.bo.GeminiTaskDataBO;
import com.tydic.gemini.api.bo.GeminiTemplateEditReqBO;
import com.tydic.gemini.api.bo.GeminiTemplateEditRspBO;
import com.tydic.gemini.api.bo.GeminiTemplateEditStatusReqBO;
import com.tydic.gemini.api.bo.GeminiTemplateEditStatusRspBO;
import com.tydic.gemini.atom.api.GeminiTaskAtomService;
import com.tydic.gemini.atom.api.GeminiTemplateAtomService;
import com.tydic.gemini.atom.api.bo.GeminiTaskAtomReqBO;
import com.tydic.gemini.atom.api.bo.GeminiTaskListQryAtomRspBO;
import com.tydic.gemini.atom.api.bo.GeminiTemplateAtomReqBO;
import com.tydic.gemini.atom.api.bo.GeminiTemplateDetailsAtomRspBO;
import com.tydic.gemini.busi.api.GeminiDealTemplateBusiService;
import com.tydic.gemini.busi.api.bo.GeminiTemplateEditBusiReqBO;
import com.tydic.gemini.busi.api.bo.GeminiTemplateEditBusiRspBO;
import com.tydic.gemini.busi.api.bo.GeminiTemplateEditStatusBusiReqBO;
import com.tydic.gemini.busi.api.bo.GeminiTemplateEditStatusBusiRspBO;
import com.tydic.gemini.constants.GeminiConstants;
import com.tydic.gemini.exception.GeminiBusinessException;
import com.tydic.utils.generatedoc.util.ArgValidator;
import org.springframework.beans.BeanUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"GEMINI_GROUP/1.0.0/com.tydic.gemini.api.GeminiTemplateEditService"})
public class GeminiTemplateEditServiceImpl
implements GeminiTemplateEditService {
    private GeminiTemplateAtomService geminiTemplateAtomService;
    private GeminiDealTemplateBusiService geminiDealTemplateBusiService;
    private GeminiTaskAtomService geminiTaskAtomService;

    public GeminiTemplateEditServiceImpl(GeminiTemplateAtomService geminiTemplateAtomService, GeminiDealTemplateBusiService geminiDealTemplateBusiService, GeminiTaskAtomService geminiTaskAtomService) {
        this.geminiTemplateAtomService = geminiTemplateAtomService;
        this.geminiDealTemplateBusiService = geminiDealTemplateBusiService;
        this.geminiTaskAtomService = geminiTaskAtomService;
    }

    @PostMapping(value={"editTemplateStatus"})
    public GeminiTemplateEditStatusRspBO editTemplateStatus(@RequestBody GeminiTemplateEditStatusReqBO reqBO) {
        GeminiTemplateEditStatusRspBO rspBO = new GeminiTemplateEditStatusRspBO();
        String validateStr = ArgValidator.validateArg((Object)reqBO);
        if (!StringUtils.isEmpty((Object)validateStr)) {
            throw new GeminiBusinessException("1002", validateStr);
        }
        GeminiTemplateAtomReqBO templateAtomReqBO = new GeminiTemplateAtomReqBO();
        templateAtomReqBO.setTemplateId(reqBO.getTemplateId());
        GeminiTemplateDetailsAtomRspBO templateAtomRspBO = this.geminiTemplateAtomService.qryTemplateDetails(templateAtomReqBO);
        if (!"0000".equals(templateAtomRspBO.getRespCode())) {
            throw new GeminiBusinessException(templateAtomRspBO.getRespCode(), templateAtomRspBO.getRespDesc());
        }
        Integer nowStatus = templateAtomRspBO.getStatus();
        validateStr = this.validateStatus(reqBO, nowStatus);
        if (!StringUtils.isEmpty((Object)validateStr)) {
            throw new GeminiBusinessException("1006", validateStr);
        }
        GeminiTemplateEditStatusBusiReqBO busiReqBO = new GeminiTemplateEditStatusBusiReqBO();
        BeanUtils.copyProperties((Object)reqBO, (Object)((Object)busiReqBO));
        GeminiTemplateEditStatusBusiRspBO busiRspBO = this.geminiDealTemplateBusiService.editTemplateStatus(busiReqBO);
        BeanUtils.copyProperties((Object)((Object)busiRspBO), (Object)rspBO);
        return rspBO;
    }

    @PostMapping(value={"editTemplateInfo"})
    public GeminiTemplateEditRspBO editTemplateInfo(@RequestBody GeminiTemplateEditReqBO reqBO) {
        GeminiTemplateEditRspBO rspBO = new GeminiTemplateEditRspBO();
        this.validate(reqBO);
        GeminiTemplateEditBusiReqBO busiReqBO = new GeminiTemplateEditBusiReqBO();
        BeanUtils.copyProperties((Object)reqBO, (Object)((Object)busiReqBO));
        GeminiTemplateEditBusiRspBO busiRspBO = this.geminiDealTemplateBusiService.editTemplateInfo(busiReqBO);
        BeanUtils.copyProperties((Object)((Object)busiRspBO), (Object)rspBO);
        return rspBO;
    }

    public String validateStatus(GeminiTemplateEditStatusReqBO reqBO, Integer nowStatus) {
        if ("1".equals(reqBO.getCallWay())) {
            if (!GeminiConstants.StatusConstants.DISABLE_STATUS.equals(nowStatus) && !GeminiConstants.StatusConstants.ENABLE_STATUS.equals(nowStatus)) {
                return "\u65e0\u6cd5\u8bc6\u522b\u5f53\u524d\u9700\u8981\u8f6c\u6362\u7684\u72b6\u6001\uff01";
            }
            if (!GeminiConstants.StatusConstants.DISABLE_STATUS.equals(reqBO.getStatus()) && !GeminiConstants.StatusConstants.ENABLE_STATUS.equals(reqBO.getStatus())) {
                return "\u4e0d\u652f\u6301\u5f53\u524d\u5c06\u8981\u8f6c\u6362\u7684\u72b6\u6001\uff01";
            }
        }
        if (GeminiConstants.StatusConstants.DISABLE_STATUS.equals(reqBO.getStatus()) && !GeminiConstants.StatusConstants.ENABLE_STATUS.equals(nowStatus)) {
            return "\u5f53\u524d\u6a21\u677f\u72b6\u6001\u4e0d\u53ef\u6267\u884c\u505c\u7528\u64cd\u4f5c\uff01";
        }
        if (GeminiConstants.StatusConstants.DISABLE_STATUS.equals(reqBO.getStatus()) || GeminiConstants.StatusConstants.TASK_DELETE_STATUS.equals(reqBO.getStatus())) {
            GeminiTaskAtomReqBO taskAtomReqBO = new GeminiTaskAtomReqBO();
            taskAtomReqBO.setTemplateId(reqBO.getTemplateId());
            GeminiTaskListQryAtomRspBO taskAtomRspBO = this.geminiTaskAtomService.qryTaskList(taskAtomReqBO);
            for (GeminiTaskDataBO taskDataBO : taskAtomRspBO.getTaskDataBOList()) {
                if (!GeminiConstants.StatusConstants.TASK_OPEN_STATUS.equals(taskDataBO.getStatus()) && !GeminiConstants.StatusConstants.TASK_PUSH_STATUS.equals(taskDataBO.getStatus()) && !GeminiConstants.StatusConstants.TASK_DRAFT_STATUS.equals(taskDataBO.getStatus())) continue;
                return "\u6709\u4f7f\u7528\u4e2d\u7684\u4efb\u52a1\u6b63\u5728\u5e94\u7528\u8be5\u6a21\u677f\uff0c\u4e0d\u53ef\u6267\u884c\u5f53\u524d\u64cd\u4f5c\uff01";
            }
        }
        if (GeminiConstants.StatusConstants.ENABLE_STATUS.equals(reqBO.getStatus()) && !GeminiConstants.StatusConstants.DISABLE_STATUS.equals(nowStatus)) {
            return "\u5f53\u524d\u6a21\u677f\u72b6\u6001\u4e0d\u53ef\u6267\u884c\u542f\u7528\u64cd\u4f5c\uff01";
        }
        return null;
    }

    void validate(GeminiTemplateEditReqBO reqBO) {
        String validateStr = ArgValidator.validateArg((Object)reqBO);
        if (!StringUtils.isEmpty((Object)validateStr)) {
            throw new GeminiBusinessException("1002", validateStr);
        }
        GeminiTaskAtomReqBO taskAtomReqBO = new GeminiTaskAtomReqBO();
        taskAtomReqBO.setTemplateId(reqBO.getTemplateId());
        GeminiTaskListQryAtomRspBO taskAtomRspBO = this.geminiTaskAtomService.qryTaskList(taskAtomReqBO);
        for (GeminiTaskDataBO taskDataBO : taskAtomRspBO.getTaskDataBOList()) {
            if (!GeminiConstants.StatusConstants.TASK_OPEN_STATUS.equals(taskDataBO.getStatus()) && !GeminiConstants.StatusConstants.TASK_PUSH_STATUS.equals(taskDataBO.getStatus()) && !GeminiConstants.StatusConstants.TASK_DRAFT_STATUS.equals(taskDataBO.getStatus())) continue;
            throw new GeminiBusinessException("1006", "\u6709\u4f7f\u7528\u4e2d\u7684\u4efb\u52a1\u6b63\u5728\u5e94\u7528\u8be5\u6a21\u677f\uff0c\u4e0d\u53ef\u7f16\u8f91\uff01");
        }
        GeminiTemplateAtomReqBO templateIdAtomReqBO = new GeminiTemplateAtomReqBO();
        templateIdAtomReqBO.setTemplateId(reqBO.getTemplateId());
        GeminiTemplateDetailsAtomRspBO originalTemplateBO = this.geminiTemplateAtomService.qryTemplateDetails(templateIdAtomReqBO);
        if (originalTemplateBO.getModuleCode().equals(reqBO.getModuleCode()) && originalTemplateBO.getTemplateName().equals(reqBO.getTemplateName())) {
            return;
        }
        GeminiTemplateAtomReqBO templateAtomReqBO = new GeminiTemplateAtomReqBO();
        templateAtomReqBO.setTemplateName(reqBO.getTemplateName());
        templateAtomReqBO.setModuleCode(reqBO.getModuleCode());
        int quantity = this.geminiTemplateAtomService.qryTemplateNum(templateAtomReqBO);
        if (quantity > 0) {
            throw new GeminiBusinessException("1003", "\u6a21\u677f\u540d\u79f0\u91cd\u590d\u4e86\uff01");
        }
    }
}

