/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.gemini.able;

import com.tydic.gemini.able.MessageAble;
import com.tydic.gemini.enums.GeminiEnums;
import com.tydic.gemini.exception.GeminiBusinessException;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;
import org.springframework.util.Assert;

@Component
public class MessageAbleManager {
    private static final Logger log = LoggerFactory.getLogger(MessageAbleManager.class);
    private final Map<Long, MessageAble> messageAbleMap = new ConcurrentHashMap<Long, MessageAble>();
    private Long ableId;
    private String ableName;

    public MessageAble getAbleByAbleId(Long messageAbleId) {
        MessageAble messageAble = this.messageAbleMap.get(messageAbleId);
        if (messageAble == null) {
            log.error("\u83b7\u53d6MessageAble\u5b9e\u73b0\u7c7b\u5931\u8d25\uff0c\u6d88\u606f\u80fd\u529bID[{}]\u5bf9\u5e94\u5b9e\u73b0\u7c7b\u4e0d\u5b58\u5728", (Object)messageAbleId);
            throw new GeminiBusinessException("1005", "\u6d88\u606f\u80fd\u529bID(" + messageAbleId + ")\u65e0\u5bf9\u5e94\u6d88\u606f\u80fd\u529b\u5b9e\u73b0\u7c7b\uff01");
        }
        return messageAble;
    }

    public void registerMessageAble(MessageAble messageAble) {
        Assert.notNull((Object)messageAble, (String)"messageAble can not be null");
        this.ableId = messageAble.getMessageAbleId();
        Assert.notNull((Object)this.ableId, (String)"messageAble.getMessageAbleId can not be null");
        MessageAble messageAbleById = this.messageAbleMap.get(this.ableId);
        this.ableName = GeminiEnums.MessageAble.getMessageAble((Long)this.ableId).getAbleName();
        if (messageAbleById != null) {
            throw new GeminiBusinessException("1005", "\u6d88\u606f\u80fd\u529b[" + this.ableName + "]\u5bf9\u5e94\u5230\u4e86\u591a\u4e2a\u5b9e\u73b0\u7c7b\uff01");
        }
        log.info("MessageAbleManager.registerMessageAble()\uff1a\u6ce8\u518c\u4e86\u6d88\u606f\u80fd\u529b\uff1a" + this.ableName);
        this.messageAbleMap.put(messageAble.getMessageAbleId(), messageAble);
    }
}

