/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.gemini.atom.impl;

import com.alibaba.fastjson.JSON;
import com.ohaotian.plugin.db.Page;
import com.tydic.gemini.api.bo.GeminiTypeDataBO;
import com.tydic.gemini.atom.api.GeminiTypeListAtomService;
import com.tydic.gemini.atom.api.bo.GeminiTypeListAtomReqBO;
import com.tydic.gemini.atom.api.bo.GeminiTypeListAtomRspBO;
import com.tydic.gemini.base.GeminiRspPageBaseBO;
import com.tydic.gemini.busi.api.GeminiDictionaryBusiService;
import com.tydic.gemini.busi.api.bo.GeminiDictionaryBusiReqBO;
import com.tydic.gemini.busi.api.bo.GeminiDictionaryBusiRspBO;
import com.tydic.gemini.dao.GeminiTypeMapper;
import com.tydic.gemini.dao.po.GeminiTypePO;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Service(value="geminiTypeListAtomService")
public class GeminiTypeListAtomServiceImpl
implements GeminiTypeListAtomService {
    private static final Logger log = LoggerFactory.getLogger(GeminiTypeListAtomServiceImpl.class);
    private GeminiTypeMapper geminiTypeMapper;
    private GeminiDictionaryBusiService geminiDictionaryBusiService;
    private static final String DEFAULT_ORDER_BY = "status desc, create_time desc";

    public GeminiTypeListAtomServiceImpl(GeminiTypeMapper geminiTypeMapper, GeminiDictionaryBusiService geminiDictionaryBusiService) {
        this.geminiTypeMapper = geminiTypeMapper;
        this.geminiDictionaryBusiService = geminiDictionaryBusiService;
    }

    @Override
    public GeminiTypeListAtomRspBO getList(GeminiTypeListAtomReqBO reqBO) {
        List<GeminiTypePO> listPage;
        log.info("\u8fdb\u5165 \u901a\u77e5\u7c7b\u578b\u5206\u9875\u67e5\u8be2atom\u670d\u52a1\u5b9e\u73b0\u7c7b \u5f53\u524d\u65b9\u6cd5: getList(), \u5165\u53c2\uff1a{}", (Object)JSON.toJSONString((Object)((Object)reqBO)));
        GeminiTypeListAtomRspBO rspBo = new GeminiTypeListAtomRspBO();
        GeminiRspPageBaseBO data = new GeminiRspPageBaseBO();
        ArrayList<GeminiTypeDataBO> rows = new ArrayList<GeminiTypeDataBO>();
        rspBo.setData(data);
        data.setRows(rows);
        Page<GeminiTypePO> page = this.getPage(reqBO);
        GeminiTypePO queryPo = new GeminiTypePO();
        BeanUtils.copyProperties((Object)((Object)reqBO), (Object)queryPo);
        if (StringUtils.isEmpty((Object)reqBO.getOrderBy())) {
            queryPo.setOrderBy(DEFAULT_ORDER_BY);
        }
        if (!CollectionUtils.isEmpty(listPage = this.geminiTypeMapper.getListPage(queryPo, page))) {
            Map<String, Map<String, String>> dicMap = this.getDicMap();
            for (GeminiTypePO typePo : listPage) {
                GeminiTypeDataBO typeDataBO = new GeminiTypeDataBO();
                BeanUtils.copyProperties((Object)typePo, (Object)typeDataBO);
                typeDataBO.setStatus(dicMap.get("TYPE_STATUS").get(typePo.getStatus().toString()));
                rows.add(typeDataBO);
            }
        }
        data.setPageNo(Integer.valueOf(page.getPageNo()));
        data.setTotal(Integer.valueOf(page.getTotalPages()));
        data.setRecordsTotal(Integer.valueOf(page.getTotalCount()));
        return rspBo;
    }

    private Page<GeminiTypePO> getPage(GeminiTypeListAtomReqBO reqBO) {
        Page page;
        if (1 < reqBO.getPageNo()) {
            page = new Page(reqBO.getPageNo().intValue(), reqBO.getPageSize().intValue());
        } else {
            page = new Page();
            BeanUtils.copyProperties((Object)((Object)reqBO), (Object)page);
            if (1 > page.getPageNo()) {
                page.setPageNo(1);
            }
            if (1 > page.getPageSize()) {
                page.setPageSize(10);
            }
        }
        return page;
    }

    private Map<String, Map<String, String>> getDicMap() {
        ArrayList<String> pCodes = new ArrayList<String>();
        pCodes.add("TYPE_STATUS");
        GeminiDictionaryBusiReqBO dictionaryBusiReqBO = new GeminiDictionaryBusiReqBO();
        dictionaryBusiReqBO.setPCodes(pCodes);
        GeminiDictionaryBusiRspBO dicMap = this.geminiDictionaryBusiService.getDicMap(dictionaryBusiReqBO);
        return dicMap.getDicMaps();
    }
}

