/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.gemini.busi.impl;

import com.alibaba.fastjson.JSON;
import com.ohaotian.plugin.db.Sequence;
import com.tydic.gemini.api.bo.GeminiConditionDataBO;
import com.tydic.gemini.busi.api.GeminiDealTaskBusiService;
import com.tydic.gemini.busi.api.GeminiDealTemplateBusiService;
import com.tydic.gemini.busi.api.bo.GeminiTaskAddBusiReqBO;
import com.tydic.gemini.busi.api.bo.GeminiTaskAddBusiRspBO;
import com.tydic.gemini.busi.api.bo.GeminiTaskEditBusiReqBO;
import com.tydic.gemini.busi.api.bo.GeminiTaskEditBusiRspBO;
import com.tydic.gemini.busi.api.bo.GeminiTaskEditStatusBusiReqBO;
import com.tydic.gemini.busi.api.bo.GeminiTaskEditStatusBusiRspBO;
import com.tydic.gemini.busi.api.bo.GeminiTemplateAddBusiReqBO;
import com.tydic.gemini.busi.api.bo.GeminiTemplateAddBusiRspBO;
import com.tydic.gemini.constants.GeminiConstants;
import com.tydic.gemini.dao.GeminiTaskConditionMapper;
import com.tydic.gemini.dao.GeminiTaskMapper;
import com.tydic.gemini.dao.GeminiTaskReceiverMapper;
import com.tydic.gemini.dao.po.GeminiTaskConditionPO;
import com.tydic.gemini.dao.po.GeminiTaskPO;
import com.tydic.gemini.dao.po.GeminiTaskReceiverPO;
import com.tydic.gemini.exception.GeminiBusinessException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service(value="geminiDealTaskBusiService")
public class GeminiDealTaskBusiServiceImpl
implements GeminiDealTaskBusiService {
    private static final Logger log = LoggerFactory.getLogger(GeminiDealTaskBusiServiceImpl.class);
    private final GeminiTaskMapper geminiTaskMapper;
    private final GeminiTaskConditionMapper geminiTaskConditionMapper;
    private final GeminiTaskReceiverMapper geminiTaskReceiverMapper;
    private final GeminiDealTemplateBusiService geminiDealTemplateBusiService;

    public GeminiDealTaskBusiServiceImpl(GeminiTaskMapper geminiTaskMapper, GeminiTaskConditionMapper geminiTaskConditionMapper, GeminiTaskReceiverMapper geminiTaskReceiverMapper, GeminiDealTemplateBusiService geminiDealTemplateBusiService) {
        this.geminiTaskMapper = geminiTaskMapper;
        this.geminiTaskConditionMapper = geminiTaskConditionMapper;
        this.geminiTaskReceiverMapper = geminiTaskReceiverMapper;
        this.geminiDealTemplateBusiService = geminiDealTemplateBusiService;
    }

    @Override
    public GeminiTaskAddBusiRspBO addTaskInfo(GeminiTaskAddBusiReqBO busiReqBO) {
        GeminiTaskAddBusiRspBO busiRspBO = new GeminiTaskAddBusiRspBO();
        GeminiTaskPO taskInsertPo = new GeminiTaskPO();
        BeanUtils.copyProperties((Object)((Object)busiReqBO), (Object)taskInsertPo);
        Date createTime = this.geminiTaskMapper.getBaseDate();
        String createOperName = "";
        if (!StringUtils.isEmpty((CharSequence)busiReqBO.getUserName())) {
            createOperName = busiReqBO.getUserName();
        }
        taskInsertPo.setCreateTime(createTime);
        taskInsertPo.setUpdateTime(createTime);
        taskInsertPo.setCreateOperName(createOperName);
        taskInsertPo.setUpdateOperName(createOperName);
        int quantity = this.geminiTaskMapper.insert(taskInsertPo);
        if (quantity < 1) {
            throw new GeminiBusinessException("6001", "\u901a\u77e5\u4efb\u52a1\u8868\u65b0\u589e\u5f02\u5e38");
        }
        Long taskId = taskInsertPo.getTaskId();
        log.info("\u8fd4\u56de\u7684\u901a\u77e5\u4efb\u52a1Id\uff1a{}", (Object)taskId);
        if (!CollectionUtils.isEmpty(busiReqBO.getTaskConditionList())) {
            ArrayList<GeminiTaskConditionPO> taskConditionPoList = new ArrayList<GeminiTaskConditionPO>();
            for (GeminiConditionDataBO conditionDataBO : busiReqBO.getTaskConditionList()) {
                GeminiTaskConditionPO taskConditionPo = new GeminiTaskConditionPO();
                BeanUtils.copyProperties((Object)conditionDataBO, (Object)taskConditionPo);
                taskConditionPo.setTaskId(taskId);
                taskConditionPo.setStatus(GeminiConstants.StatusConstants.ENABLE_STATUS);
                taskConditionPo.setConditionCodeList(StringUtils.join((Iterable)conditionDataBO.getConditionCodeList(), (String)","));
                taskConditionPoList.add(taskConditionPo);
            }
            quantity = this.geminiTaskConditionMapper.insertBatch(taskConditionPoList);
            if (quantity < 1) {
                throw new GeminiBusinessException("6001", "\u4efb\u52a1\u6761\u4ef6\u4fe1\u606f\u8868\u65b0\u589e\u5f02\u5e38");
            }
        }
        if (!CollectionUtils.isEmpty(busiReqBO.getTaskReceiverList())) {
            List taskReceiverPoList = JSON.parseArray((String)JSON.toJSONString(busiReqBO.getTaskReceiverList()), GeminiTaskReceiverPO.class);
            String createName = createOperName;
            taskReceiverPoList.forEach(taskReceiverPo -> {
                taskReceiverPo.setRelId(null);
                taskReceiverPo.setTaskId(taskId);
                taskReceiverPo.setReceiverType(GeminiConstants.ReceiverConstants.RECEIVER_TYPE_USER);
                taskReceiverPo.setStatus(GeminiConstants.StatusConstants.EFFECTIVE_STATUS);
                taskReceiverPo.setCreateTime(createTime);
                taskReceiverPo.setCreateOperName(createName);
            });
            quantity = this.geminiTaskReceiverMapper.insertBatch(taskReceiverPoList);
            if (quantity < 1) {
                throw new GeminiBusinessException("6001", "\u4efb\u52a1\u63a5\u6536\u5bf9\u8c61\u8868\u65b0\u589e\u5f02\u5e38");
            }
        }
        GeminiTemplateAddBusiReqBO templateAddReqBO = new GeminiTemplateAddBusiReqBO();
        BeanUtils.copyProperties((Object)((Object)busiReqBO), (Object)((Object)templateAddReqBO));
        this.updateTemplateId(templateAddReqBO, taskId);
        return busiRspBO;
    }

    @Override
    public GeminiTaskEditStatusBusiRspBO editTaskStatus(GeminiTaskEditStatusBusiReqBO busiReqBO) {
        GeminiTaskEditStatusBusiRspBO busiRspBO = new GeminiTaskEditStatusBusiRspBO();
        GeminiTaskPO taskPo = new GeminiTaskPO();
        taskPo.setTaskId(busiReqBO.getTaskId());
        taskPo.setStatus(busiReqBO.getStatus());
        int quantity = this.geminiTaskMapper.updateById(taskPo);
        if (quantity < 1) {
            throw new GeminiBusinessException("6007", "\u901a\u77e5\u4efb\u52a1\u72b6\u6001\u4fee\u6539\u5931\u8d25");
        }
        return busiRspBO;
    }

    @Override
    public GeminiTaskEditBusiRspBO editTaskInfo(GeminiTaskEditBusiReqBO busiReqBO) {
        GeminiTaskEditBusiRspBO busiRspBO = new GeminiTaskEditBusiRspBO();
        GeminiTaskPO taskUpdatePo = new GeminiTaskPO();
        BeanUtils.copyProperties((Object)((Object)busiReqBO), (Object)taskUpdatePo);
        Date updateTime = this.geminiTaskMapper.getBaseDate();
        String updateOperName = "";
        if (!StringUtils.isEmpty((CharSequence)busiReqBO.getUserName())) {
            updateOperName = busiReqBO.getUserName();
        }
        taskUpdatePo.setUpdateTime(updateTime);
        taskUpdatePo.setUpdateOperName(updateOperName);
        int quantity = this.geminiTaskMapper.updateById(taskUpdatePo);
        if (quantity < 1) {
            throw new GeminiBusinessException("6006", "\u901a\u77e5\u4efb\u52a1\u4fee\u6539\u5931\u8d25");
        }
        if (!CollectionUtils.isEmpty(busiReqBO.getTaskConditionList())) {
            ArrayList<GeminiTaskConditionPO> taskConditionPoList = new ArrayList<GeminiTaskConditionPO>();
            for (GeminiConditionDataBO conditionDataBO : busiReqBO.getTaskConditionList()) {
                GeminiTaskConditionPO taskConditionPo = new GeminiTaskConditionPO();
                BeanUtils.copyProperties((Object)conditionDataBO, (Object)taskConditionPo);
                taskConditionPo.setStatus(GeminiConstants.StatusConstants.ENABLE_STATUS);
                taskConditionPo.setConditionCodeList(StringUtils.join((Iterable)conditionDataBO.getConditionCodeList(), (String)","));
                taskConditionPoList.add(taskConditionPo);
            }
            GeminiTaskConditionPO taskConditionUpdatePo = new GeminiTaskConditionPO();
            taskConditionUpdatePo.setTaskId(busiReqBO.getTaskId());
            taskConditionUpdatePo.setStatus(GeminiConstants.StatusConstants.DISABLE_STATUS);
            this.geminiTaskConditionMapper.updateStatusByTaskId(taskConditionUpdatePo);
            quantity = this.geminiTaskConditionMapper.insertBatch(taskConditionPoList);
            if (quantity < 1) {
                throw new GeminiBusinessException("6006", "\u4efb\u52a1\u6761\u4ef6\u4fe1\u606f\u4fee\u6539\u5f02\u5e38");
            }
        }
        if (!CollectionUtils.isEmpty(busiReqBO.getTaskReceiverList())) {
            List taskReceiverPoList = JSON.parseArray((String)JSON.toJSONString(busiReqBO.getTaskReceiverList()), GeminiTaskReceiverPO.class);
            GeminiTaskReceiverPO taskReceiverUpdatePo = new GeminiTaskReceiverPO();
            taskReceiverUpdatePo.setTaskId(busiReqBO.getTaskId());
            taskReceiverUpdatePo.setStatus(GeminiConstants.StatusConstants.INVALID_STATUS);
            this.geminiTaskReceiverMapper.updateStatusByTaskId(taskReceiverUpdatePo);
            String createName = updateOperName;
            taskReceiverPoList.forEach(taskReceiverPo -> {
                taskReceiverPo.setRelId(null);
                taskReceiverPo.setCreateTime(updateTime);
                taskReceiverPo.setCreateOperName(createName);
            });
            quantity = this.geminiTaskReceiverMapper.insertBatch(taskReceiverPoList);
            if (quantity < 1) {
                throw new GeminiBusinessException("6006", "\u4efb\u52a1\u63a5\u6536\u5bf9\u8c61\u8868\u65b0\u589e\u5f02\u5e38");
            }
        }
        GeminiTemplateAddBusiReqBO templateAddReqBO = new GeminiTemplateAddBusiReqBO();
        BeanUtils.copyProperties((Object)((Object)busiReqBO), (Object)((Object)templateAddReqBO));
        this.updateTemplateId(templateAddReqBO, busiReqBO.getTaskId());
        return busiRspBO;
    }

    public void updateTemplateId(GeminiTemplateAddBusiReqBO templateAddReqBO, Long taskId) {
        Long templateId;
        if (templateAddReqBO.getTemplateId() == null) {
            templateAddReqBO.setCreateWay(GeminiConstants.JudgmentWayConstants.SYSTEM_CREATE_WAY);
            templateAddReqBO.setTemplateName(templateAddReqBO.getMessageTitle() + Sequence.getInstance().nextId());
            templateAddReqBO.setStatus(GeminiConstants.StatusConstants.ENABLE_STATUS);
            GeminiTemplateAddBusiRspBO templateAddRspBO = this.geminiDealTemplateBusiService.addTemplateInfo(templateAddReqBO);
            if (!"0000".equals(templateAddRspBO.getRespCode())) {
                throw new GeminiBusinessException(templateAddRspBO.getRespCode(), templateAddRspBO.getRespDesc());
            }
            templateId = templateAddRspBO.getTemplateId();
        } else {
            templateId = templateAddReqBO.getTemplateId();
        }
        GeminiTaskPO taskUpdateTemplateIdPo = new GeminiTaskPO();
        taskUpdateTemplateIdPo.setTaskId(taskId);
        taskUpdateTemplateIdPo.setTemplateId(templateId);
        this.geminiTaskMapper.updateById(taskUpdateTemplateIdPo);
    }
}

