/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.gemini.busi.impl;

import com.alibaba.fastjson.JSON;
import com.ohaotian.plugin.cache.CacheClient;
import com.tydic.gemini.atom.api.bo.TaskBO;
import com.tydic.gemini.base.GeminiRspBaseBO;
import com.tydic.gemini.utils.filter.impl.IntervalMessageFilter;
import com.tydic.gemini.utils.filter.impl.ModuleMessageFilter;
import com.tydic.gemini.utils.filter.impl.TaskConditionFilter;
import javax.annotation.PostConstruct;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

@Component
public class GeminiTaskFilter {
    private static final Logger log = LoggerFactory.getLogger(GeminiTaskFilter.class);
    @Value(value="${platform.enable.cache.key:PES_DIC_platform_enable_setting}")
    private String dictionaryKeyPrefix;
    @Value(value="${interval.time.cache.key:PES_DIC_approveUrgedTimeInterval}")
    private String intervalTimeKey;
    private CacheClient cacheClient;
    private ModuleMessageFilter moduleFilters;
    private IntervalMessageFilter intervalFilter;

    public GeminiTaskFilter(CacheClient cacheClient) {
        this.cacheClient = cacheClient;
    }

    @PostConstruct
    public void init() {
        this.moduleFilters = new ModuleMessageFilter(this.cacheClient, this.dictionaryKeyPrefix);
        this.intervalFilter = new IntervalMessageFilter(this.cacheClient, this.intervalTimeKey);
    }

    public GeminiRspBaseBO doFilter(TaskBO taskBo) {
        TaskConditionFilter conditionFilter;
        log.info("\u4efb\u52a1\u8fc7\u6ee4\u5668\u89e6\u53d1\uff1aTASK=[{}]", (Object)JSON.toJSONString((Object)((Object)taskBo)));
        GeminiRspBaseBO retBo = new GeminiRspBaseBO();
        retBo.setRespCode("8888");
        if (!this.moduleFilters.doFilter(taskBo).booleanValue()) {
            log.info("\u6839\u636e\u6a21\u5757\u542f\u7528\u72b6\u6001\u8fc7\u6ee4\u5931\u8d25");
            retBo.setRespDesc("\u6a21\u5757\u672a\u542f\u7528");
            return retBo;
        }
        if (!this.intervalFilter.doFilter(taskBo).booleanValue()) {
            log.info("\u65f6\u95f4\u95f4\u9694\u8fc7\u6ee4\u5931\u8d25");
            retBo.setRespDesc("\u53d1\u9001\u9891\u7387\u8fc7\u5feb\u8bf7\u7a0d\u540e\u518d\u8bd5");
            return retBo;
        }
        if (!CollectionUtils.isEmpty(taskBo.getTaskConditionList()) && !(conditionFilter = new TaskConditionFilter()).doFilter(taskBo).booleanValue()) {
            log.info("\u4efb\u52a1\u81ea\u5b9a\u4e49\u6761\u4ef6\u8fc7\u6ee4\u5931\u8d25");
            retBo.setRespDesc("\u672a\u6ee1\u8db3\u4efb\u52a1\u81ea\u5b9a\u4e49\u53d1\u9001\u6761\u4ef6");
            return retBo;
        }
        retBo.setRespCode("0000");
        retBo.setRespDesc("\u6210\u529f");
        log.debug("\u4efb\u52a1\u8fc7\u6ee4\u901a\u8fc7");
        return retBo;
    }
}

