/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.gemini.busi.impl;

import com.alibaba.fastjson.JSON;
import com.tydic.gemini.busi.api.GeminiTypeBusiService;
import com.tydic.gemini.busi.api.bo.GeminiTypeAddBusiReqBO;
import com.tydic.gemini.busi.api.bo.GeminiTypeAddBusiRspBO;
import com.tydic.gemini.busi.api.bo.GeminiTypeDeleteBusiReqBO;
import com.tydic.gemini.busi.api.bo.GeminiTypeDeleteBusiRspBO;
import com.tydic.gemini.busi.api.bo.GeminiTypeEditBusiReqBO;
import com.tydic.gemini.busi.api.bo.GeminiTypeEditBusiRspBO;
import com.tydic.gemini.constants.GeminiConstants;
import com.tydic.gemini.dao.GeminiTaskMapper;
import com.tydic.gemini.dao.GeminiTypeMapper;
import com.tydic.gemini.dao.po.GeminiTaskPO;
import com.tydic.gemini.dao.po.GeminiTypePO;
import com.tydic.gemini.exception.GeminiBusinessException;
import java.util.Date;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Service(value="geminiTypeBusiService")
public class GeminiTypeBusiServiceImpl
implements GeminiTypeBusiService {
    private static final Logger log = LoggerFactory.getLogger(GeminiTypeBusiServiceImpl.class);
    private GeminiTypeMapper geminiTypeMapper;
    private GeminiTaskMapper taskMapper;

    public GeminiTypeBusiServiceImpl(GeminiTypeMapper geminiTypeMapper, GeminiTaskMapper taskMapper) {
        this.geminiTypeMapper = geminiTypeMapper;
        this.taskMapper = taskMapper;
    }

    @Override
    public GeminiTypeAddBusiRspBO addType(GeminiTypeAddBusiReqBO reqBO) {
        int quantity;
        log.info("\u8fdb\u5165\u6dfb\u52a0\u901a\u77e5\u7c7b\u578bbusi\u670d\u52a1\u5b9e\u73b0\u7c7b, \u5f53\u524d\u65b9\u6cd5\uff1aaddType(), \u5165\u53c2\uff1a{}", (Object)JSON.toJSONString((Object)((Object)reqBO)));
        GeminiTypeAddBusiRspBO retBo = new GeminiTypeAddBusiRspBO();
        String checkResult = this.checkAdd(reqBO);
        if (!StringUtils.isEmpty((Object)checkResult)) {
            retBo.setRespCode("8888");
            retBo.setRespDesc(checkResult);
            return retBo;
        }
        GeminiTypePO typePo = new GeminiTypePO();
        BeanUtils.copyProperties((Object)((Object)reqBO), (Object)typePo);
        String matchesResult = this.matchesType(typePo);
        if (!StringUtils.isEmpty((Object)matchesResult)) {
            retBo.setRespCode("8888");
            retBo.setRespDesc(matchesResult);
            return retBo;
        }
        Date nowTime = this.geminiTypeMapper.getDbDate();
        typePo.setCreateTime(nowTime);
        typePo.setUpdateTime(nowTime);
        if (!StringUtils.isEmpty((Object)reqBO.getUserName())) {
            typePo.setCreateOperName(reqBO.getUserName());
            typePo.setUpdateOperName(reqBO.getUserName());
        }
        if ((quantity = this.geminiTypeMapper.insert(typePo)) < 1) {
            log.info("\u901a\u77e5\u7c7b\u578b\u65b0\u589e\u5931\u8d25");
            throw new GeminiBusinessException("6004", "\u901a\u77e5\u7c7b\u578b\u65b0\u589e\u5931\u8d25");
        }
        log.info("\u65b0\u589e\u901a\u77e5\u7c7b\u578b\u6210\u529f");
        return retBo;
    }

    @Override
    public GeminiTypeEditBusiRspBO editType(GeminiTypeEditBusiReqBO reqBO) {
        log.info("\u8fdb\u5165\u6dfb\u52a0\u901a\u77e5\u7c7b\u578bbusi\u670d\u52a1\u5b9e\u73b0\u7c7b, \u5f53\u524d\u65b9\u6cd5\uff1aeditType(), \u5165\u53c2\uff1a{}", (Object)JSON.toJSONString((Object)((Object)reqBO)));
        GeminiTypeEditBusiRspBO rspBO = new GeminiTypeEditBusiRspBO();
        GeminiTypePO set = new GeminiTypePO();
        GeminiTypePO where = new GeminiTypePO();
        BeanUtils.copyProperties((Object)((Object)reqBO), (Object)set);
        String matchesResult = this.matchesType(set);
        if (!StringUtils.isEmpty((Object)matchesResult)) {
            rspBO.setRespCode("8888");
            rspBO.setRespDesc(matchesResult);
            return rspBO;
        }
        set.setUpdateTime(this.geminiTypeMapper.getDbDate());
        where.setTypeId(reqBO.getTypeId());
        int quantity = this.geminiTypeMapper.updateBy(set, where);
        if (quantity < 1) {
            throw new GeminiBusinessException("6005", "\u901a\u77e5\u7c7b\u578b\u7f16\u8f91\u5931\u8d25");
        }
        log.info("\u7f16\u8f91\u901a\u77e5\u7c7b\u578b\u4fe1\u606f\u6210\u529f");
        return rspBO;
    }

    @Override
    public GeminiTypeDeleteBusiRspBO delete(GeminiTypeDeleteBusiReqBO reqBO) {
        log.info("\u8fdb\u5165\u6dfb\u52a0\u901a\u77e5\u7c7b\u578bbusi\u670d\u52a1\u5b9e\u73b0\u7c7b, \u5f53\u524d\u65b9\u6cd5\uff1adelete(), \u5165\u53c2\uff1a{}", (Object)JSON.toJSONString((Object)((Object)reqBO)));
        GeminiTypeDeleteBusiRspBO rspBO = new GeminiTypeDeleteBusiRspBO();
        String checkDeleteResult = this.checkDelete(reqBO);
        if (!StringUtils.isEmpty((Object)checkDeleteResult)) {
            rspBO.setRespCode("8888");
            rspBO.setRespDesc(checkDeleteResult);
            return rspBO;
        }
        GeminiTypePO typePo = new GeminiTypePO();
        typePo.setTypeId(reqBO.getTypeId());
        int quantity = this.geminiTypeMapper.deleteBy(typePo);
        if (quantity < 1) {
            throw new GeminiBusinessException("6008", "\u5220\u9664\u901a\u77e5\u7c7b\u578b\u5931\u8d25");
        }
        return rspBO;
    }

    private String checkAdd(GeminiTypeAddBusiReqBO reqBO) {
        GeminiTypePO typePo = new GeminiTypePO();
        typePo.setTypeCode(reqBO.getTypeCode());
        int checkByCode = this.geminiTypeMapper.getCheckBy(typePo);
        if (checkByCode > 0) {
            return "\u7c7b\u578b\u7f16\u7801\u5df2\u5b58\u5728";
        }
        return null;
    }

    private String checkDelete(GeminiTypeDeleteBusiReqBO reqBO) {
        GeminiTypePO typePo = new GeminiTypePO();
        typePo.setTypeId(reqBO.getTypeId());
        int quantity = this.geminiTypeMapper.getCheckBy(typePo);
        if (quantity < 1) {
            return "\u901a\u77e5\u7c7b\u578b\u4e0d\u5b58\u5728\uff01";
        }
        GeminiTaskPO taskTypePo = new GeminiTaskPO();
        taskTypePo.setTypeId(reqBO.getTypeId());
        List<GeminiTaskPO> taskPoList = this.taskMapper.getList(taskTypePo);
        if (!CollectionUtils.isEmpty(taskPoList)) {
            for (GeminiTaskPO taskPo : taskPoList) {
                if (!GeminiConstants.StatusConstants.TASK_OPEN_STATUS.equals(taskPo.getStatus()) && !GeminiConstants.StatusConstants.TASK_PUSH_STATUS.equals(taskPo.getStatus()) && !GeminiConstants.StatusConstants.TASK_DRAFT_STATUS.equals(taskPo.getStatus())) continue;
                return "\u8be5\u901a\u77e5\u7c7b\u578b\u88ab\u4f7f\u7528\u4e2d\u7684\u4efb\u52a1\u5360\u7528\uff0c\u65e0\u6cd5\u5220\u9664";
            }
        }
        return null;
    }

    private String matchesType(GeminiTypePO reqBO) {
        String codeMatches = "[0-9A-Za-z_]{1,150}";
        String nameMatches = "^.{1,30}$";
        String remarkMatches = "^.{1,150}$";
        if (!StringUtils.isEmpty((Object)reqBO.getTypeCode()) && !reqBO.getTypeCode().matches("[0-9A-Za-z_]{1,150}")) {
            return "\u7c7b\u578b\u7f16\u7801\u8bf7\u8f93\u51651~150\u4e2a\u6570\u5b57\u3001\u5b57\u6bcd\u6216 _ \u7684\u7ec4\u5408";
        }
        if (!StringUtils.isEmpty((Object)reqBO.getTypeName()) && !reqBO.getTypeName().matches("^.{1,30}$")) {
            return "\u7c7b\u578b\u540d\u79f0\u8bf7\u8f93\u51651~30\u4e2a\u5b57\u7b26";
        }
        if (!StringUtils.isEmpty((Object)reqBO.getRemark()) && !reqBO.getRemark().matches("^.{1,150}$")) {
            return "\u5907\u6ce8\u8bf7\u8f93\u51651~150\u4e2a\u5b57\u7b26";
        }
        return null;
    }
}

