/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.gemini.comb.impl;

import cn.hutool.core.util.ObjectUtil;
import com.ohaotian.plugin.db.Sequence;
import com.tydic.gemini.api.bo.GeminiReceiverBO;
import com.tydic.gemini.api.bo.GeminiRecordDataBO;
import com.tydic.gemini.atom.api.GeminiRecordAtomService;
import com.tydic.gemini.atom.api.GeminiTaskAtomService;
import com.tydic.gemini.atom.api.bo.GeminiRecordListQryAtomReqBO;
import com.tydic.gemini.atom.api.bo.GeminiRecordListQryAtomRspBO;
import com.tydic.gemini.atom.api.bo.GeminiTaskAtomReqBO;
import com.tydic.gemini.atom.api.bo.GeminiTaskDetailsAtomRspBO;
import com.tydic.gemini.atom.api.bo.TaskBO;
import com.tydic.gemini.base.GeminiRspBaseBO;
import com.tydic.gemini.busi.api.GeminiRecordBusiService;
import com.tydic.gemini.busi.api.bo.GeminiRecordBusiReqBO;
import com.tydic.gemini.busi.api.bo.GeminiRecordBusiRspBO;
import com.tydic.gemini.busi.impl.GeminiTaskExecutor;
import com.tydic.gemini.busi.impl.GeminiTaskFilter;
import com.tydic.gemini.comb.api.GeminiSendCombService;
import com.tydic.gemini.comb.api.bo.GeminiSendCombServiceReqBO;
import com.tydic.gemini.comb.api.bo.GeminiSendCombServiceRspBO;
import com.tydic.gemini.constants.GeminiConstants;
import com.tydic.gemini.dao.GeminiTaskConditionMapper;
import com.tydic.gemini.dao.GeminiTaskMapper;
import com.tydic.gemini.dao.GeminiTemplateMapper;
import com.tydic.gemini.dao.GeminiVariableMapper;
import com.tydic.gemini.dao.po.GeminiTaskConditionPO;
import com.tydic.gemini.dao.po.GeminiTaskPO;
import com.tydic.gemini.dao.po.GeminiTemplatePO;
import com.tydic.gemini.dao.po.GeminiVariablePO;
import com.tydic.gemini.exception.GeminiBusinessException;
import com.tydic.gemini.utils.GeminiTranslationUtil;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.scheduling.annotation.EnableAsync;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@EnableAsync
@Service(value="geminiSendCombService")
public class GeminiSendCombServiceImpl
implements GeminiSendCombService {
    private static final Logger log = LoggerFactory.getLogger(GeminiSendCombServiceImpl.class);
    private GeminiTaskAtomService geminiTaskAtomService;
    private GeminiTaskConditionMapper geminiTaskConditionMapper;
    private GeminiRecordAtomService geminiRecordAtomService;
    private GeminiTaskFilter geminiTaskFilter;
    private GeminiTaskExecutor geminiTaskExecutor;
    private GeminiRecordBusiService geminiRecordBusiService;
    private GeminiTaskMapper geminiTaskMapper;
    private GeminiTemplateMapper geminiTemplateMapper;
    private GeminiVariableMapper geminiVariableMapper;

    public GeminiSendCombServiceImpl(GeminiTaskAtomService geminiTaskAtomService, GeminiTaskConditionMapper geminiTaskConditionMapper, GeminiTaskFilter geminiTaskFilter, GeminiRecordAtomService geminiRecordAtomService, GeminiTaskExecutor geminiTaskExecutor, GeminiTaskMapper geminiTaskMapper, GeminiRecordBusiService geminiRecordBusiService, GeminiTemplateMapper geminiTemplateMapper, GeminiVariableMapper geminiVariableMapper) {
        this.geminiTaskAtomService = geminiTaskAtomService;
        this.geminiTaskConditionMapper = geminiTaskConditionMapper;
        this.geminiTaskFilter = geminiTaskFilter;
        this.geminiRecordAtomService = geminiRecordAtomService;
        this.geminiTaskExecutor = geminiTaskExecutor;
        this.geminiRecordBusiService = geminiRecordBusiService;
        this.geminiTemplateMapper = geminiTemplateMapper;
        this.geminiVariableMapper = geminiVariableMapper;
        this.geminiTaskMapper = geminiTaskMapper;
    }

    @Override
    public GeminiSendCombServiceRspBO sendMessage(GeminiSendCombServiceReqBO reqBO) {
        GeminiSendCombServiceRspBO rspBO = new GeminiSendCombServiceRspBO();
        TaskBO taskBO = new TaskBO();
        BeanUtils.copyProperties((Object)((Object)reqBO), (Object)((Object)taskBO));
        GeminiTaskAtomReqBO taskAtomReqBO = new GeminiTaskAtomReqBO();
        taskAtomReqBO.setTaskId(reqBO.getTaskId());
        taskAtomReqBO.setStatus(GeminiConstants.StatusConstants.ENABLE_STATUS);
        GeminiTaskDetailsAtomRspBO taskAtomRspBO = this.geminiTaskAtomService.qryTaskDetails(taskAtomReqBO);
        if (!"0000".equals(taskAtomRspBO.getRespCode())) {
            BeanUtils.copyProperties((Object)((Object)taskAtomRspBO), (Object)((Object)rspBO));
            return rspBO;
        }
        taskBO.setModuleCode(taskAtomRspBO.getModuleCode());
        taskBO.setExecuteWay(taskAtomRspBO.getExecuteWay());
        taskBO.setIsSingle(taskAtomRspBO.getIsSingle());
        if (StringUtils.isEmpty((Object)taskBO.getSendType())) {
            taskBO.setSendType(taskAtomRspBO.getSendType());
        }
        if (GeminiConstants.StatusConstants.ENABLE_STATUS.equals(reqBO.getNeedInterval())) {
            GeminiRecordDataBO recordDataBO = new GeminiRecordDataBO();
            recordDataBO.setTaskId(taskBO.getTaskId());
            recordDataBO.setSendStatus(GeminiConstants.RecordStatus.SUCCESS);
            GeminiRecordListQryAtomReqBO recordListQryAtomReqBO = new GeminiRecordListQryAtomReqBO();
            recordListQryAtomReqBO.setRecordData(recordDataBO);
            GeminiRecordListQryAtomRspBO recordAtomRspBo = this.geminiRecordAtomService.qryRecordList(recordListQryAtomReqBO);
            if (!CollectionUtils.isEmpty(recordAtomRspBo.getRecordDataBOList())) {
                taskBO.setSendTime(recordAtomRspBo.getRecordDataBOList().get(0).getSendTime());
                log.debug("*** \u83b7\u53d6\u5230\u4e0a\u6b21\u7684\u53d1\u9001\u8bb0\u5f55\u65f6\u95f4:{}", (Object)taskBO.getSendTime());
            }
        }
        GeminiTaskConditionPO taskConditionReqPo = new GeminiTaskConditionPO();
        taskConditionReqPo.setTaskId(reqBO.getTaskId());
        taskConditionReqPo.setStatus(GeminiConstants.StatusConstants.ENABLE_STATUS);
        List<GeminiTaskConditionPO> taskConditionPoList = this.geminiTaskConditionMapper.getList(taskConditionReqPo);
        taskBO.setTaskConditionList(taskConditionPoList);
        GeminiRspBaseBO filterRetBo = this.geminiTaskFilter.doFilter(taskBO);
        if (!"0000".equals(filterRetBo.getRespCode())) {
            BeanUtils.copyProperties((Object)filterRetBo, (Object)((Object)rspBO));
            rspBO.setRespDesc("\u4efb\u52a1\u8fc7\u6ee4\u5931\u8d25\uff1a" + rspBO.getRespDesc());
            return rspBO;
        }
        this.generateMessageInfo(taskBO);
        GeminiRecordBusiReqBO recordBusiReqBo = new GeminiRecordBusiReqBO();
        taskBO.setRecordId(Sequence.getInstance().nextId());
        BeanUtils.copyProperties((Object)((Object)taskBO), (Object)((Object)recordBusiReqBo));
        recordBusiReqBo.setSendStatus(GeminiConstants.RecordStatus.SENDING);
        recordBusiReqBo.setResultDesc("\u53d1\u9001\u4e2d");
        Map<String, String> receiverMap = taskBO.getReceivers().stream().collect(Collectors.toMap(GeminiReceiverBO::getReceiverId, GeminiReceiverBO::getReceiverName));
        recordBusiReqBo.setReceiver(receiverMap.keySet().toString());
        recordBusiReqBo.setReceiverName(receiverMap.values().toString());
        recordBusiReqBo.setSendTime(this.geminiTaskMapper.getBaseDate());
        GeminiRecordBusiRspBO recordBusiRspBo = this.geminiRecordBusiService.addRecord(recordBusiReqBo);
        if (!"0000".equals(recordBusiRspBo.getRespCode())) {
            log.info("\u65b0\u589e\u53d1\u9001\u8bb0\u5f55\u5931\u8d25");
            BeanUtils.copyProperties((Object)((Object)recordBusiRspBo), (Object)((Object)rspBO));
            rspBO.setRespDesc("\u65b0\u589e\u53d1\u9001\u8bb0\u5f55\u5931\u8d25");
            return rspBO;
        }
        this.geminiTaskExecutor.execute(taskBO);
        return rspBO;
    }

    private void generateMessageInfo(TaskBO taskBo) {
        GeminiTaskPO taskPo = new GeminiTaskPO();
        taskPo.setTaskId(taskBo.getTaskId());
        taskPo = this.geminiTaskMapper.getModelBy(taskPo);
        GeminiTemplatePO templatePo = new GeminiTemplatePO();
        templatePo.setTemplateId(taskPo.getTemplateId());
        templatePo = this.geminiTemplateMapper.getModelBy(templatePo);
        if (ObjectUtil.isEmpty((Object)templatePo) || !GeminiConstants.StatusConstants.ENABLE_STATUS.equals(templatePo.getStatus())) {
            log.info("\u672a\u83b7\u53d6\u5230\u4efb\u52a1\uff1a[{}]\u6709\u6548\u7684\u6a21\u677f", (Object)taskPo.getTaskId());
            throw new GeminiBusinessException("1005", "\u672a\u83b7\u53d6\u5230\u4efb\u52a1\uff1a[" + taskPo.getTaskId() + "]\u6709\u6548\u7684\u6a21\u677f");
        }
        List<GeminiVariablePO> variableList = this.geminiVariableMapper.getRelVariable(templatePo.getTemplateId());
        Map<String, String> variableMap = variableList.stream().collect(Collectors.toMap(item -> item.getVariableId().toString(), GeminiVariablePO::getVariableCode));
        String messageContent = GeminiTranslationUtil.valueReplacementId((String)templatePo.getMessageContent(), variableMap, taskBo.getValueMap());
        taskBo.setMessageTitle(templatePo.getMessageTitle());
        taskBo.setMessageContent(messageContent);
        log.info("\u6839\u636e\u6a21\u677f\u548c\u5165\u53c2\u503c\u5f97\u5230\u7684\u6d88\u606f\u5185\u5bb9\u4e3a\uff1a{}", (Object)messageContent);
    }
}

