/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.gemini.utils.filter.impl;

import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSON;
import com.ohaotian.plugin.cache.CacheClient;
import com.tydic.gemini.api.bo.GeminiIntervalDataBO;
import com.tydic.gemini.atom.api.bo.TaskBO;
import com.tydic.gemini.utils.filter.MessageFilter;
import java.util.Date;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.StringUtils;

public class IntervalMessageFilter
implements MessageFilter {
    private static final Logger log = LoggerFactory.getLogger(IntervalMessageFilter.class);
    private String intervalTimeKey;
    private final CacheClient cacheClient;

    public IntervalMessageFilter(CacheClient cacheClient, String intervalTimeKey) {
        this.intervalTimeKey = intervalTimeKey;
        this.cacheClient = cacheClient;
    }

    @Override
    public Boolean doFilter(TaskBO taskBo) {
        if (StringUtils.isEmpty((Object)taskBo.getSendTime())) {
            return true;
        }
        Object intervalTime = this.cacheClient.get(this.intervalTimeKey);
        if (ObjectUtil.isEmpty((Object)intervalTime)) {
            return true;
        }
        GeminiIntervalDataBO intervalDataBO = (GeminiIntervalDataBO)JSON.parseObject((String)intervalTime.toString(), GeminiIntervalDataBO.class);
        Date date = new Date();
        Date beforeDate = new Date(date.getTime() - Long.parseLong(intervalDataBO.getDicValue()) * 60000L);
        return !taskBo.getSendTime().after(beforeDate);
    }
}

