/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.gemini.utils.filter.impl;

import com.tydic.gemini.atom.api.bo.TaskBO;
import com.tydic.gemini.dao.po.GeminiTaskConditionPO;
import com.tydic.gemini.utils.filter.MessageFilter;
import java.util.Map;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineManager;
import javax.script.ScriptException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.CollectionUtils;

public class TaskConditionFilter
implements MessageFilter {
    private static final Logger log = LoggerFactory.getLogger(TaskConditionFilter.class);

    @Override
    public Boolean doFilter(TaskBO taskBo) {
        if (CollectionUtils.isEmpty(taskBo.getValueMap())) {
            return false;
        }
        Map<String, String> valueMap = taskBo.getValueMap();
        ScriptEngine engine = this.getScriptEngine(valueMap);
        try {
            for (GeminiTaskConditionPO taskConditionPo : taskBo.getTaskConditionList()) {
                if (((Boolean)engine.eval(taskConditionPo.getConditionFormula())).booleanValue()) continue;
                return false;
            }
        }
        catch (ScriptException e) {
            log.error("\u811a\u672c\u5f15\u64ce\u8ba1\u7b97\u6761\u4ef6\u8fc7\u6ee4\u5f02\u5e38\uff1a{}", (Object)e.getMessage());
            return false;
        }
        return true;
    }

    private ScriptEngine getScriptEngine(Map<String, String> valueMap) {
        ScriptEngineManager manager = new ScriptEngineManager();
        ScriptEngine engine = manager.getEngineByName("js");
        for (Map.Entry<String, String> entry : valueMap.entrySet()) {
            engine.put(entry.getKey(), entry.getValue());
        }
        return engine;
    }
}

