/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.gemini.ability.impl;

import com.alibaba.fastjson.JSON;
import com.ohaotian.plugin.db.Page;
import com.tydic.gemini.api.GeminiInnerMessageQryService;
import com.tydic.gemini.api.bo.GeminiInnerMessageDataBO;
import com.tydic.gemini.api.bo.GeminiInnerMessageDetailsReqBO;
import com.tydic.gemini.api.bo.GeminiInnerMessageDetailsRspBO;
import com.tydic.gemini.api.bo.GeminiInnerMessageNumQryReqBO;
import com.tydic.gemini.api.bo.GeminiInnerMessageNumQryRspBO;
import com.tydic.gemini.api.bo.GeminiInnerMessagePageQryReqBO;
import com.tydic.gemini.api.bo.GeminiInnerMessagePageQryRspBO;
import com.tydic.gemini.base.GeminiRspPageBaseBO;
import com.tydic.gemini.constants.GeminiConstants;
import com.tydic.gemini.dao.GeminiInnerMessageMapper;
import com.tydic.gemini.dao.po.GeminiInnerMessagePO;
import com.tydic.gemini.exception.GeminiBusinessException;
import com.tydic.utils.generatedoc.util.ArgValidator;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Service
public class GeminiInnerMessageQryServiceImpl
implements GeminiInnerMessageQryService {
    private static final Logger log = LoggerFactory.getLogger(GeminiInnerMessageQryServiceImpl.class);
    private final GeminiInnerMessageMapper geminiInnerMessageMapper;

    public GeminiInnerMessageQryServiceImpl(GeminiInnerMessageMapper geminiInnerMessageMapper) {
        this.geminiInnerMessageMapper = geminiInnerMessageMapper;
    }

    public GeminiInnerMessagePageQryRspBO qryInnerMessagePageList(GeminiInnerMessagePageQryReqBO reqBO) {
        GeminiInnerMessagePageQryRspBO rspBO = new GeminiInnerMessagePageQryRspBO();
        log.info("\u5206\u9875\u67e5\u8be2\u7ad9\u5185\u4fe1\u5217\u8868\u5165\u53c2\uff1a{}", (Object)reqBO);
        String validateStr = ArgValidator.validateArg((Object)reqBO);
        if (!StringUtils.isEmpty((Object)validateStr)) {
            throw new GeminiBusinessException("1002", validateStr);
        }
        if (StringUtils.isEmpty((Object)reqBO.getUserId())) {
            throw new GeminiBusinessException("1002", "\u7528\u6237ID\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        GeminiRspPageBaseBO data = new GeminiRspPageBaseBO();
        ArrayList rows = new ArrayList();
        data.setRows(rows);
        rspBO.setData(data);
        Page<GeminiInnerMessagePO> page = this.getPage(reqBO);
        GeminiInnerMessagePO innerMessagePo = new GeminiInnerMessagePO();
        BeanUtils.copyProperties((Object)reqBO, (Object)innerMessagePo);
        innerMessagePo.setReceiverId(reqBO.getUserId());
        innerMessagePo.setOrderBy("CREATE_TIME desc");
        log.info("\u67e5\u8be2\u7ad9\u5185\u4fe1\u5165\u53c2\uff1a{}", (Object)innerMessagePo);
        List<GeminiInnerMessagePO> innerMessagePoList = this.geminiInnerMessageMapper.getListPage(innerMessagePo, page);
        if (!CollectionUtils.isEmpty(innerMessagePoList)) {
            data.setRows(JSON.parseArray((String)JSON.toJSONString(innerMessagePoList), GeminiInnerMessageDataBO.class));
        }
        data.setPageNo(Integer.valueOf(page.getPageNo()));
        data.setTotal(Integer.valueOf(page.getTotalPages()));
        data.setRecordsTotal(Integer.valueOf(page.getTotalCount()));
        return rspBO;
    }

    public GeminiInnerMessageDetailsRspBO qryInnerMessageDetails(GeminiInnerMessageDetailsReqBO reqBO) {
        GeminiInnerMessageDetailsRspBO rspBO = new GeminiInnerMessageDetailsRspBO();
        String validateStr = ArgValidator.validateArg((Object)reqBO);
        if (!StringUtils.isEmpty((Object)validateStr)) {
            throw new GeminiBusinessException("1002", validateStr);
        }
        if (StringUtils.isEmpty((Object)reqBO.getUserId())) {
            throw new GeminiBusinessException("1002", "\u7528\u6237ID\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        GeminiInnerMessagePO innerMessageReqPo = new GeminiInnerMessagePO();
        BeanUtils.copyProperties((Object)reqBO, (Object)innerMessageReqPo);
        int quantity = this.geminiInnerMessageMapper.getCheckBy(innerMessageReqPo);
        if (quantity < 1) {
            throw new GeminiBusinessException("8001", "\u672a\u67e5\u8be2\u5230\u5bf9\u5e94\u6d88\u606f\uff01");
        }
        GeminiInnerMessagePO innerMessageRspPo = this.geminiInnerMessageMapper.getModelBy(innerMessageReqPo);
        BeanUtils.copyProperties((Object)innerMessageRspPo, (Object)rspBO);
        GeminiInnerMessagePO innerMessageReadReqPo = new GeminiInnerMessagePO();
        innerMessageReadReqPo.setMessageId(reqBO.getMessageId());
        innerMessageReadReqPo.setStatus(GeminiConstants.StatusConstants.MESSAGE_READ_STATUS);
        quantity = this.geminiInnerMessageMapper.updateById(innerMessageReadReqPo);
        if (quantity < 1) {
            throw new GeminiBusinessException("8002", "\u7ad9\u5185\u4fe1\u8bbe\u4e3a\u5df2\u8bfb\u5931\u8d25");
        }
        return rspBO;
    }

    public GeminiInnerMessageNumQryRspBO qryInnerMessageCount(GeminiInnerMessageNumQryReqBO reqBO) {
        GeminiInnerMessageNumQryRspBO rspBO = new GeminiInnerMessageNumQryRspBO();
        String validateStr = ArgValidator.validateArg((Object)reqBO);
        if (!StringUtils.isEmpty((Object)validateStr)) {
            throw new GeminiBusinessException("1002", validateStr);
        }
        GeminiInnerMessagePO innerMessageReqPo = new GeminiInnerMessagePO();
        innerMessageReqPo.setTaskId(reqBO.getTaskId());
        innerMessageReqPo.setStatus(GeminiConstants.StatusConstants.MESSAGE_READ_STATUS);
        rspBO.setReadNumber(Integer.valueOf(this.geminiInnerMessageMapper.getCheckBy(innerMessageReqPo)));
        innerMessageReqPo.setStatus(GeminiConstants.StatusConstants.MESSAGE_UNREAD_STATUS);
        rspBO.setUnreadNumber(Integer.valueOf(this.geminiInnerMessageMapper.getCheckBy(innerMessageReqPo)));
        rspBO.setAllNumber(Integer.valueOf(rspBO.getReadNumber() + rspBO.getUnreadNumber()));
        return rspBO;
    }

    private Page<GeminiInnerMessagePO> getPage(GeminiInnerMessagePageQryReqBO reqBO) {
        Page page;
        if (1 < reqBO.getPageNo()) {
            page = new Page(reqBO.getPageNo().intValue(), reqBO.getPageSize().intValue());
        } else {
            page = new Page();
            BeanUtils.copyProperties((Object)reqBO, (Object)page);
            if (1 > page.getPageNo()) {
                page.setPageNo(1);
            }
            if (1 > page.getPageSize()) {
                page.setPageSize(10);
            }
        }
        return page;
    }
}

