/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.gemini.ability.impl;

import com.alibaba.fastjson.JSON;
import com.ohaotian.plugin.db.Page;
import com.tydic.gemini.api.GeminiPopupMessageQryService;
import com.tydic.gemini.api.bo.GeminiPopupMessageBO;
import com.tydic.gemini.api.bo.GeminiPopupMessageDetailQryReqBO;
import com.tydic.gemini.api.bo.GeminiPopupMessageDetailQryRspBO;
import com.tydic.gemini.api.bo.GeminiPopupMessagePageQryReqBO;
import com.tydic.gemini.api.bo.GeminiPopupMessagePageQryRspBO;
import com.tydic.gemini.base.GeminiRspPageBaseBO;
import com.tydic.gemini.dao.GeminiPopupMapper;
import com.tydic.gemini.dao.po.GeminiPopupPO;
import com.tydic.gemini.exception.GeminiBusinessException;
import com.tydic.utils.generatedoc.util.ArgValidator;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Service
public class GeminiPopupMessageQryServiceImpl
implements GeminiPopupMessageQryService {
    private static final Logger log = LoggerFactory.getLogger(GeminiPopupMessageQryServiceImpl.class);
    private GeminiPopupMapper geminiPopupMapper;

    public GeminiPopupMessageQryServiceImpl(GeminiPopupMapper geminiPopupMapper) {
        this.geminiPopupMapper = geminiPopupMapper;
    }

    public GeminiPopupMessagePageQryRspBO getPageList(GeminiPopupMessagePageQryReqBO reqBO) {
        log.info("\u8fdb\u5165\u5f39\u7a97\u6d88\u606f\u67e5\u8be2\u670d\u52a1\u5b9e\u73b0\u7c7b\uff0c \u5f53\u524d\u65b9\u6cd5\uff1agetPageList(), \u5165\u53c2\uff1a{}", (Object)JSON.toJSONString((Object)reqBO));
        GeminiPopupMessagePageQryRspBO rspBO = new GeminiPopupMessagePageQryRspBO();
        String validateStr = ArgValidator.validateArg((Object)reqBO);
        if (!StringUtils.isEmpty((Object)validateStr)) {
            throw new GeminiBusinessException("1002", validateStr);
        }
        if (StringUtils.isEmpty((Object)reqBO.getUserId())) {
            throw new GeminiBusinessException("1002", validateStr);
        }
        GeminiRspPageBaseBO data = new GeminiRspPageBaseBO();
        rspBO.setData(data);
        ArrayList rows = new ArrayList();
        data.setRows(rows);
        Page<GeminiPopupPO> page = this.getPage(reqBO);
        GeminiPopupPO geminiPopupPo = new GeminiPopupPO();
        BeanUtils.copyProperties((Object)reqBO, (Object)geminiPopupPo);
        geminiPopupPo.setReceiverId(reqBO.getUserId());
        geminiPopupPo.setStatus(reqBO.getStatus());
        List<GeminiPopupPO> popupPoList = this.geminiPopupMapper.getListPage(geminiPopupPo, page);
        if (!CollectionUtils.isEmpty(popupPoList)) {
            data.setRows(JSON.parseArray((String)JSON.toJSONString(popupPoList), GeminiPopupMessageBO.class));
        }
        data.setPageNo(Integer.valueOf(page.getPageNo()));
        data.setTotal(Integer.valueOf(page.getTotalPages()));
        data.setRecordsTotal(Integer.valueOf(page.getTotalCount()));
        GeminiPopupPO set = new GeminiPopupPO();
        set.setStatus(0);
        GeminiPopupPO where = new GeminiPopupPO();
        where.setReceiverId(reqBO.getUserId());
        int quantity = this.geminiPopupMapper.updateBy(set, where);
        if (quantity < 1) {
            throw new GeminiBusinessException("6024", "\u66f4\u65b0\u5f39\u7a97\u6d88\u606f\u63a8\u9001\u72b6\u6001\u5931\u8d25");
        }
        return rspBO;
    }

    public GeminiPopupMessageDetailQryRspBO getDetail(GeminiPopupMessageDetailQryReqBO reqBO) {
        String validateArg = ArgValidator.validateArg((Object)reqBO);
        if (StringUtils.isEmpty((Object)reqBO) || StringUtils.isEmpty((Object)reqBO.getUserId())) {
            throw new GeminiBusinessException("1002", validateArg);
        }
        GeminiPopupMessageDetailQryRspBO rspBO = new GeminiPopupMessageDetailQryRspBO();
        GeminiPopupPO popupPo = new GeminiPopupPO();
        popupPo.setReceiverId(reqBO.getUserId());
        popupPo.setPopupId(reqBO.getPopupId());
        GeminiPopupPO modelBy = this.geminiPopupMapper.getModelBy(popupPo);
        BeanUtils.copyProperties((Object)modelBy, (Object)rspBO);
        return rspBO;
    }

    private Page<GeminiPopupPO> getPage(GeminiPopupMessagePageQryReqBO reqBO) {
        Page page;
        if (1 < reqBO.getPageNo()) {
            page = new Page(reqBO.getPageNo().intValue(), reqBO.getPageSize().intValue());
        } else {
            page = new Page();
            BeanUtils.copyProperties((Object)reqBO, (Object)page);
            if (1 > page.getPageNo()) {
                page.setPageNo(1);
            }
            if (1 > page.getPageSize()) {
                page.setPageSize(10);
            }
        }
        return page;
    }
}

