/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.gemini.ability.impl;

import com.alibaba.fastjson.JSON;
import com.tydic.gemini.api.GeminiSendAbilityService;
import com.tydic.gemini.api.bo.GeminiReceiverBO;
import com.tydic.gemini.api.bo.GeminiSendAbilityReqBO;
import com.tydic.gemini.api.bo.GeminiSendAbilityRspBO;
import com.tydic.gemini.atom.api.GeminiTaskAtomService;
import com.tydic.gemini.atom.api.bo.GeminiTaskAtomReqBO;
import com.tydic.gemini.atom.api.bo.GeminiTaskDetailsAtomRspBO;
import com.tydic.gemini.comb.api.GeminiSendCombService;
import com.tydic.gemini.comb.api.bo.GeminiSendCombServiceReqBO;
import com.tydic.gemini.comb.api.bo.GeminiSendCombServiceRspBO;
import com.tydic.gemini.constants.GeminiConstants;
import com.tydic.gemini.dao.GeminiTaskReceiverMapper;
import com.tydic.gemini.dao.po.GeminiTaskReceiverPO;
import com.tydic.gemini.exception.GeminiBusinessException;
import com.tydic.gemini.external.api.GeminiUmcUserInfoService;
import com.tydic.gemini.external.api.bo.GeminiUmcUserInfoReqBO;
import com.tydic.gemini.external.api.bo.GeminiUmcUserInfoRspBO;
import com.tydic.utils.generatedoc.util.ArgValidator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Service
public class GeminiSendAbilityServiceImpl
implements GeminiSendAbilityService {
    private static final Logger log = LoggerFactory.getLogger(GeminiSendAbilityServiceImpl.class);
    private GeminiSendCombService geminiSendCombService;
    private GeminiTaskAtomService geminiTaskAtomService;
    private GeminiUmcUserInfoService geminiUmcUserInfoService;
    private GeminiTaskReceiverMapper geminiTaskReceiverMapper;

    public GeminiSendAbilityServiceImpl(GeminiSendCombService geminiSendCombService, GeminiTaskAtomService geminiTaskAtomService, GeminiUmcUserInfoService geminiUmcUserInfoService, GeminiTaskReceiverMapper geminiTaskReceiverMapper) {
        this.geminiSendCombService = geminiSendCombService;
        this.geminiTaskAtomService = geminiTaskAtomService;
        this.geminiUmcUserInfoService = geminiUmcUserInfoService;
        this.geminiTaskReceiverMapper = geminiTaskReceiverMapper;
    }

    public GeminiSendAbilityRspBO sendMessage(GeminiSendAbilityReqBO reqBo) {
        GeminiSendAbilityRspBO retBo = new GeminiSendAbilityRspBO();
        if (StringUtils.isEmpty((Object)reqBo.getTaskCode())) {
            throw new GeminiBusinessException("1002", "\u4efb\u52a1\u7f16\u7801[taskCode]\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        GeminiTaskAtomReqBO taskDetailsAtomReqBO = new GeminiTaskAtomReqBO();
        taskDetailsAtomReqBO.setTaskCode(reqBo.getTaskCode());
        taskDetailsAtomReqBO.setStatus(GeminiConstants.StatusConstants.TASK_OPEN_STATUS);
        GeminiTaskDetailsAtomRspBO taskDetailsAtomRspBO = this.geminiTaskAtomService.qryTaskDetails(taskDetailsAtomReqBO);
        if (!"0000".equals(taskDetailsAtomRspBO.getRespCode())) {
            log.info("\u4efb\u52a1\u7f16\u7801[{}]\u4e0d\u5b58\u5728", (Object)reqBo.getTaskCode());
            throw new GeminiBusinessException("1003", taskDetailsAtomRspBO.getRespDesc());
        }
        this.validateAndQueryUserInfo(reqBo, taskDetailsAtomRspBO.getTaskId());
        GeminiSendCombServiceReqBO combReqBo = new GeminiSendCombServiceReqBO();
        BeanUtils.copyProperties((Object)reqBo, (Object)((Object)combReqBo));
        combReqBo.setTaskId(taskDetailsAtomRspBO.getTaskId());
        Map valueMap = (Map)JSON.parseObject((String)reqBo.getData(), Map.class);
        combReqBo.setValueMap(valueMap);
        combReqBo.setModuleCode(taskDetailsAtomRspBO.getModuleCode());
        combReqBo.setExecuteWay(taskDetailsAtomRspBO.getExecuteWay());
        combReqBo.setIsSingle(taskDetailsAtomRspBO.getIsSingle());
        combReqBo.setPopupTime(taskDetailsAtomRspBO.getPopupTime());
        List<String> sendType = reqBo.getSendType().stream().filter(item -> taskDetailsAtomRspBO.getSendType().contains((CharSequence)item)).collect(Collectors.toList());
        combReqBo.setSendType(sendType);
        log.info("#############combReqBo:{}", (Object)JSON.toJSONString((Object)((Object)combReqBo)));
        GeminiSendCombServiceRspBO combRetBo = this.geminiSendCombService.sendMessage(combReqBo);
        BeanUtils.copyProperties((Object)((Object)combRetBo), (Object)retBo);
        return retBo;
    }

    public void validateAndQueryUserInfo(GeminiSendAbilityReqBO reqBO, Long taskId) {
        String validateStr = ArgValidator.validateArg((Object)reqBO);
        if (!StringUtils.isEmpty((Object)validateStr)) {
            throw new GeminiBusinessException("1003", validateStr);
        }
        if (!CollectionUtils.isEmpty((Collection)reqBO.getReceivers())) {
            return;
        }
        if (!StringUtils.isEmpty((Object)reqBO.getUmcParam())) {
            GeminiUmcUserInfoReqBO externalReqBo = new GeminiUmcUserInfoReqBO();
            externalReqBo.setUmcParam(reqBO.getUmcParam());
            GeminiUmcUserInfoRspBO externalRspBo = this.geminiUmcUserInfoService.getUserInfo(externalReqBo);
            reqBO.setReceivers(JSON.parseArray((String)JSON.toJSONString((Object)externalRspBo.getUserInfos()), GeminiReceiverBO.class));
            if (CollectionUtils.isEmpty((Collection)reqBO.getReceivers())) {
                throw new GeminiBusinessException("1003", "\u6839\u636e\u900f\u4f20\u53c2\u6570\u672a\u83b7\u53d6\u5230\u63a5\u53d7\u65b9\u4fe1\u606f");
            }
            return;
        }
        this.queryTaskReceiver(reqBO, taskId);
        if (CollectionUtils.isEmpty((Collection)reqBO.getReceivers())) {
            throw new GeminiBusinessException("1003", "\u6a21\u677f\u914d\u7f6e\u7684\u63a5\u6536\u65b9\u5728\u4f1a\u5458\u4e2d\u5fc3\u672a\u83b7\u53d6\u5230\u4fe1\u606f");
        }
    }

    private void queryTaskReceiver(GeminiSendAbilityReqBO reqBO, Long taskId) {
        GeminiUmcUserInfoRspBO externalRspBo;
        GeminiTaskReceiverPO taskReceiverPo = new GeminiTaskReceiverPO();
        taskReceiverPo.setTaskId(taskId);
        taskReceiverPo.setStatus(GeminiConstants.StatusConstants.EFFECTIVE_STATUS);
        List<GeminiTaskReceiverPO> taskReceiverPoList = this.geminiTaskReceiverMapper.getList(taskReceiverPo);
        if (CollectionUtils.isEmpty(taskReceiverPoList)) {
            throw new GeminiBusinessException("1002", "\u63a5\u53d7\u65b9\u4fe1\u606f\u4e3a\u7a7a");
        }
        List receivers = JSON.parseArray((String)JSON.toJSONString(taskReceiverPoList), GeminiReceiverBO.class);
        log.info("\u4ece\u4efb\u52a1\u914d\u7f6e\u4e2d\u83b7\u53d6\u63a5\u6536\u65b9\u4fe1\u606f\uff1a{}", (Object)receivers);
        List<Object> userIdList = new ArrayList();
        List<Object> roleIdList = new ArrayList();
        Map<Integer, List<GeminiReceiverBO>> receiverGroupMap = receivers.stream().collect(Collectors.groupingBy(GeminiReceiverBO::getReceiverType));
        for (Map.Entry<Integer, List<GeminiReceiverBO>> entry : receiverGroupMap.entrySet()) {
            if (GeminiConstants.ReceiverConstants.RECEIVER_TYPE_ROLE.equals(entry.getKey())) {
                roleIdList = entry.getValue().stream().map(item -> Long.valueOf(item.getReceiverId())).collect(Collectors.toList());
                continue;
            }
            userIdList = entry.getValue().stream().map(item -> Long.valueOf(item.getReceiverId())).collect(Collectors.toList());
        }
        receivers.clear();
        GeminiUmcUserInfoReqBO externalReqBo = new GeminiUmcUserInfoReqBO();
        if (!CollectionUtils.isEmpty(userIdList)) {
            externalReqBo.setMemIdList(userIdList);
            externalRspBo = this.geminiUmcUserInfoService.getUserInfo(externalReqBo);
            receivers = JSON.parseArray((String)JSON.toJSONString((Object)externalRspBo.getUserInfos()), GeminiReceiverBO.class);
        }
        if (!CollectionUtils.isEmpty(roleIdList)) {
            externalReqBo.setMemIdList(null);
            externalReqBo.setRoleIdList(roleIdList);
            externalRspBo = this.geminiUmcUserInfoService.getUserInfo(externalReqBo);
            List receiverBoList = JSON.parseArray((String)JSON.toJSONString((Object)externalRspBo.getUserInfos()), GeminiReceiverBO.class);
            receiverBoList.removeAll(receivers);
            receivers.addAll(receiverBoList);
        }
        reqBO.setReceivers(receivers);
    }
}

