/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.gemini.able.impl;

import com.alibaba.fastjson.JSON;
import com.tydic.gemini.able.MessageAble;
import com.tydic.gemini.able.bo.MessageSendReqBO;
import com.tydic.gemini.able.bo.MessageSendRspBO;
import com.tydic.gemini.dao.GeminiPopupMapper;
import com.tydic.gemini.dao.po.GeminiPopupPO;
import com.tydic.gemini.enums.GeminiEnums;
import com.tydic.gemini.exception.GeminiBusinessException;
import com.tydic.gemini.web.api.bo.GeminiPopupMessageDataBO;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Service;

@Service
public class PopupsMessageAbleImpl
implements MessageAble {
    private GeminiPopupMapper geminiPopupMapper;

    public PopupsMessageAbleImpl(GeminiPopupMapper geminiPopupMapper) {
        this.geminiPopupMapper = geminiPopupMapper;
    }

    public Long getMessageAbleId() {
        return GeminiEnums.MessageAble.POP_UPS.getAbleId();
    }

    public MessageSendRspBO sendMessage(MessageSendReqBO ableReqBO) {
        MessageSendRspBO rspBO = new MessageSendRspBO();
        ArrayList geminiPopupMessageDataBOList = new ArrayList();
        ableReqBO.getReceivers().forEach(bo -> {
            GeminiPopupMessageDataBO dataBO = new GeminiPopupMessageDataBO();
            BeanUtils.copyProperties((Object)ableReqBO, (Object)dataBO);
            dataBO.setReceiverId(bo.getReceiverId());
            dataBO.setMessageTitle(ableReqBO.getTitle());
            dataBO.setPopupTime(ableReqBO.getPopupTime());
            dataBO.setReceiverType(bo.getReceiverType());
            dataBO.setReceiverName(bo.getReceiverName());
            geminiPopupMessageDataBOList.add(dataBO);
        });
        Date nowDate = this.geminiPopupMapper.getDbDate();
        List popupPoList = JSON.parseArray((String)JSON.toJSONString(geminiPopupMessageDataBOList), GeminiPopupPO.class);
        popupPoList.forEach(popupPo -> {
            popupPo.setCreateTime(nowDate);
            popupPo.setStatus(1);
        });
        int quantity = this.geminiPopupMapper.insertBatch(popupPoList);
        if (quantity < 1) {
            throw new GeminiBusinessException("6018", "\u65b0\u589e\u5f39\u7a97\u6d88\u606f\u5f02\u5e38");
        }
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        return rspBO;
    }
}

