/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.gemini.aspect;

import cn.hutool.core.bean.BeanUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.ohaotian.plugin.cache.CacheClient;
import com.tydic.gemini.constants.GeminiDicValue;
import com.tydic.gemini.utils.GeminiRspBuildUtil;
import com.tydic.gemini.utils.IpUtils;
import com.tydic.gemini.web.api.GeminiInterceptQryService;
import com.tydic.gemini.web.api.GeminiSendTypeQryService;
import com.tydic.gemini.web.api.bo.GeminiInterceptDataBO;
import com.tydic.gemini.web.api.bo.GeminiInterceptQryReqBO;
import com.tydic.gemini.web.api.bo.GeminiInterceptQryRspBO;
import com.tydic.gemini.web.api.bo.GeminiSendTypeQryReqBO;
import com.tydic.gemini.web.api.bo.GeminiSendTypeQryRspBO;
import java.lang.reflect.Method;
import java.util.List;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.After;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Before;
import org.aspectj.lang.annotation.Pointcut;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

@Aspect
@Component
public class InterceptAspect {
    private static final Logger log = LoggerFactory.getLogger(InterceptAspect.class);
    @Autowired
    private CacheClient cacheClient;
    @Autowired
    private GeminiInterceptQryService geminiInterceptQryService;
    @Autowired
    private GeminiSendTypeQryService geminiSendTypeQryService;

    @Pointcut(value="@annotation(com.tydic.gemini.aspect.Intercept)")
    public void intercept() {
    }

    @Before(value="intercept()")
    public void doBefore() {
    }

    @After(value="intercept()")
    public void doAfter() {
    }

    @Around(value="intercept()")
    public Object doAround(ProceedingJoinPoint joinPoint) throws Throwable {
        ServletRequestAttributes attributes = (ServletRequestAttributes)RequestContextHolder.getRequestAttributes();
        HttpServletRequest request = attributes.getRequest();
        String ipAddress = IpUtils.getIpAddress(request);
        List<GeminiInterceptDataBO> interceptList = this.getInterceptInfo();
        List<String> sendTypeList = this.getValidSendType();
        if (CollectionUtils.isEmpty(interceptList)) {
            Object[] args = joinPoint.getArgs();
            BeanUtil.setFieldValue((Object)args[0], (String)"sendType", sendTypeList);
            return joinPoint.proceed();
        }
        boolean pass = this.handleIntercept(joinPoint, interceptList, sendTypeList, ipAddress);
        if (pass) {
            return joinPoint.proceed();
        }
        return this.buildRspInfo(joinPoint);
    }

    private Object buildRspInfo(ProceedingJoinPoint joinPoint) throws ClassNotFoundException, InstantiationException, IllegalAccessException, NoSuchFieldException {
        Method[] methods;
        String targetName = joinPoint.getTarget().getClass().getName();
        String methodName = joinPoint.getSignature().getName();
        Class<?> targetClass = Class.forName(targetName);
        Class<?> rspClass = null;
        for (Method method : methods = targetClass.getMethods()) {
            if (!method.getName().equals(methodName)) continue;
            rspClass = method.getReturnType();
            break;
        }
        Object retObj = rspClass.newInstance();
        GeminiRspBuildUtil.buildRspInfo(retObj, "8888", "\u901a\u77e5\u4e2d\u5fc3\u9ed1\u767d\u540d\u5355\u62e6\u622a");
        return retObj;
    }

    private boolean handleIntercept(ProceedingJoinPoint joinPoint, List<GeminiInterceptDataBO> interceptList, List<String> sendTypeList, String ipAddress) {
        for (GeminiInterceptDataBO item : interceptList) {
            String sendTypes;
            if (1 == item.getInterceptType()) {
                if (!item.getIpAddress().contains(ipAddress)) {
                    log.info("\u767d\u540d\u5355\u62e6\u622a\uff0c\u8bf7\u6c42\u8005IP\uff1a\u3010{}\u3011\u672a\u914d\u7f6e\u767d\u540d\u5355", (Object)ipAddress);
                    return false;
                }
                sendTypes = item.getSendType();
                if (StringUtils.isEmpty((Object)sendTypes)) continue;
                sendTypeList = sendTypeList.stream().filter(sendTypes::contains).collect(Collectors.toList());
                continue;
            }
            if (2 != item.getInterceptType() || !item.getIpAddress().contains(ipAddress)) continue;
            sendTypes = item.getSendType();
            if (StringUtils.isEmpty((Object)sendTypes)) {
                log.debug("\u9ed1\u540d\u5355\u62e6\u622a\u6210\u529f\uff0c\u8bf7\u6c42\u8005IP:\u3010{}\u3011", (Object)ipAddress);
                return false;
            }
            List sendTypeBlackList = sendTypeList.stream().filter(sendTypes::contains).collect(Collectors.toList());
            log.debug("\u9ed1\u540d\u5355\u62e6\u622a\uff0c\u5bf9\u8bf7\u6c42IP\u3010{}\u3011\uff0c\u9650\u5236\u4ee5\u4e0b\u53d1\u9001\u65b9\u5f0f\u3010{}\u3011", (Object)ipAddress, sendTypeBlackList);
            sendTypeList.removeAll(sendTypeBlackList);
        }
        Object[] args = joinPoint.getArgs();
        Object requestSendTypeObj = BeanUtil.getFieldValue((Object)args[0], (String)"sendType");
        if (!ObjectUtils.isEmpty((Object)requestSendTypeObj)) {
            List requestSendTypeList = JSONArray.parseArray((String)JSON.toJSONString((Object)requestSendTypeObj), String.class);
            sendTypeList = sendTypeList.stream().filter(requestSendTypeList::contains).collect(Collectors.toList());
        }
        BeanUtil.setFieldValue((Object)args[0], (String)"sendType", sendTypeList);
        return true;
    }

    private List<String> getValidSendType() {
        Object sendTypeObj = this.cacheClient.get("GEMINI_SEND_TYPE_CACHE_KEY");
        if (ObjectUtils.isEmpty((Object)sendTypeObj)) {
            GeminiSendTypeQryReqBO sendTypeQryReqBo = new GeminiSendTypeQryReqBO();
            sendTypeQryReqBo.setStatus(GeminiDicValue.GEMINI_TYPE_STATUS_ENABLE);
            sendTypeQryReqBo.setSign(GeminiDicValue.SIGN_BACK_END);
            GeminiSendTypeQryRspBO retBo = this.geminiSendTypeQryService.sendTypeListQry(sendTypeQryReqBo);
            return retBo.getSendTypeList();
        }
        return JSONArray.parseArray((String)sendTypeObj.toString(), String.class);
    }

    private List<GeminiInterceptDataBO> getInterceptInfo() {
        Object interceptObj = this.cacheClient.get("GEMINI_INTERCEPT_CACHE_KEY");
        if (ObjectUtils.isEmpty((Object)interceptObj)) {
            GeminiInterceptQryRspBO retBo = this.geminiInterceptQryService.qryIntercept(new GeminiInterceptQryReqBO());
            return retBo.getInterceptList();
        }
        return JSONArray.parseArray((String)interceptObj.toString(), GeminiInterceptDataBO.class);
    }
}

