/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.gemini.atom.impl;

import com.alibaba.fastjson.JSON;
import com.ohaotian.plugin.db.Page;
import com.tydic.gemini.atom.api.GeminiTaskAtomService;
import com.tydic.gemini.atom.api.bo.GeminiTaskAtomReqBO;
import com.tydic.gemini.atom.api.bo.GeminiTaskDetailsAtomRspBO;
import com.tydic.gemini.atom.api.bo.GeminiTaskListQryAtomRspBO;
import com.tydic.gemini.atom.api.bo.GeminiTaskPageQryAtomRspBO;
import com.tydic.gemini.constants.GeminiConstants;
import com.tydic.gemini.dao.GeminiRelTemplateMapper;
import com.tydic.gemini.dao.GeminiTaskMapper;
import com.tydic.gemini.dao.po.GeminiRelTemplatePO;
import com.tydic.gemini.dao.po.GeminiTaskPO;
import com.tydic.gemini.enums.GeminiEnums;
import com.tydic.gemini.web.api.bo.GeminiTaskDataBO;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Service(value="geminiTaskAtomService")
public class GeminiTaskAtomServiceImpl
implements GeminiTaskAtomService {
    private static final Logger log = LoggerFactory.getLogger(GeminiTaskAtomServiceImpl.class);
    private GeminiTaskMapper geminiTaskMapper;
    private GeminiRelTemplateMapper geminiRelTemplateMapper;

    public GeminiTaskAtomServiceImpl(GeminiTaskMapper geminiTaskMapper, GeminiRelTemplateMapper geminiRelTemplateMapper) {
        this.geminiTaskMapper = geminiTaskMapper;
        this.geminiRelTemplateMapper = geminiRelTemplateMapper;
    }

    @Override
    public GeminiTaskDetailsAtomRspBO qryTaskDetails(GeminiTaskAtomReqBO atomReqBO) {
        GeminiTaskDetailsAtomRspBO atomRspBO = new GeminiTaskDetailsAtomRspBO();
        GeminiTaskPO taskReqPo = new GeminiTaskPO();
        BeanUtils.copyProperties((Object)atomReqBO, (Object)taskReqPo);
        GeminiTaskPO taskRspPo = this.geminiTaskMapper.getModelByTypeCode(taskReqPo);
        if (StringUtils.isEmpty((Object)taskRspPo)) {
            atomRspBO.setRespCode("5001");
            atomRspBO.setRespDesc("\u672a\u83b7\u53d6\u5230\u4efb\u52a1Code:" + atomReqBO.getTaskCode() + "\u7684\u6709\u6548\u7684\u4fe1\u606f");
            return atomRspBO;
        }
        log.info("\u67e5\u8be2\u5230\u7684\u4efb\u52a1\u57fa\u672c\u4fe1\u606f:{}", (Object)taskRspPo);
        BeanUtils.copyProperties((Object)taskRspPo, (Object)((Object)atomRspBO));
        return atomRspBO;
    }

    @Override
    public GeminiTaskListQryAtomRspBO qryTaskList(GeminiTaskAtomReqBO atomReqBO) {
        GeminiTaskListQryAtomRspBO atomRspBO = new GeminiTaskListQryAtomRspBO();
        GeminiTaskPO taskReqPo = new GeminiTaskPO();
        BeanUtils.copyProperties((Object)atomReqBO, (Object)taskReqPo);
        List<GeminiTaskPO> taskPoList = this.geminiTaskMapper.getList(taskReqPo);
        atomRspBO.setTaskDataBOList(JSON.parseArray((String)JSON.toJSONString(taskPoList), GeminiTaskDataBO.class));
        return atomRspBO;
    }

    @Override
    public GeminiTaskPageQryAtomRspBO qryTaskPageList(GeminiTaskAtomReqBO atomReqBO, Page<GeminiTaskPO> page) {
        GeminiTaskPageQryAtomRspBO atomRspBO = new GeminiTaskPageQryAtomRspBO();
        GeminiTaskPO taskReqPo = new GeminiTaskPO();
        BeanUtils.copyProperties((Object)atomReqBO, (Object)taskReqPo);
        taskReqPo.setOrderBy("STATUS desc,CREATE_TIME desc");
        List<GeminiTaskPO> taskPoList = this.geminiTaskMapper.getListPage(taskReqPo, page);
        ArrayList<GeminiTaskDataBO> taskDataBoList = new ArrayList<GeminiTaskDataBO>();
        if (!CollectionUtils.isEmpty(taskPoList)) {
            for (GeminiTaskPO taskPo : taskPoList) {
                GeminiTaskDataBO taskDataBO = new GeminiTaskDataBO();
                BeanUtils.copyProperties((Object)taskPo, (Object)taskDataBO);
                String sendType = taskPo.getSendType();
                log.info("\u4efb\u52a1\u53d1\u9001\u65b9\u5f0f\uff1a{}", (Object)sendType);
                if (sendType.contains(String.valueOf(GeminiEnums.MessageAble.ALIBABA_MESSAGE.getAbleId())) || sendType.contains(String.valueOf(GeminiEnums.MessageAble.TENCENT_MESSAGE.getAbleId()))) {
                    GeminiRelTemplatePO relTemplateReqPo = new GeminiRelTemplatePO();
                    relTemplateReqPo.setTemplateId(taskPo.getTemplateId());
                    relTemplateReqPo.setStatus(GeminiConstants.StatusConstants.EFFECTIVE_STATUS);
                    GeminiRelTemplatePO relTemplateRspPo = this.geminiRelTemplateMapper.getModelBy(relTemplateReqPo);
                    if (!StringUtils.isEmpty((Object)relTemplateRspPo)) {
                        taskDataBO.setThirdpartyTemplateId(relTemplateRspPo.getThirdTemplateCode());
                    }
                }
                taskDataBoList.add(taskDataBO);
            }
        }
        atomRspBO.setTaskDataBOList(taskDataBoList);
        return atomRspBO;
    }
}

